/*
 * Decompiled with CFR 0.152.
 */
package shaded.bqjdbc.org.apache.hc.core5.http.impl.nio;

import java.io.IOException;
import shaded.bqjdbc.org.apache.hc.core5.http.HttpException;
import shaded.bqjdbc.org.apache.hc.core5.http.HttpRequest;
import shaded.bqjdbc.org.apache.hc.core5.http.HttpRequestFactory;
import shaded.bqjdbc.org.apache.hc.core5.http.MessageConstraintException;
import shaded.bqjdbc.org.apache.hc.core5.http.RequestHeaderFieldsTooLargeException;
import shaded.bqjdbc.org.apache.hc.core5.http.config.Http1Config;
import shaded.bqjdbc.org.apache.hc.core5.http.impl.nio.AbstractMessageParser;
import shaded.bqjdbc.org.apache.hc.core5.http.message.LineParser;
import shaded.bqjdbc.org.apache.hc.core5.http.message.RequestLine;
import shaded.bqjdbc.org.apache.hc.core5.http.nio.SessionInputBuffer;
import shaded.bqjdbc.org.apache.hc.core5.util.Args;
import shaded.bqjdbc.org.apache.hc.core5.util.CharArrayBuffer;

public class DefaultHttpRequestParser<T extends HttpRequest>
extends AbstractMessageParser<T> {
    private final HttpRequestFactory<T> requestFactory;

    public DefaultHttpRequestParser(HttpRequestFactory<T> requestFactory, LineParser parser, Http1Config http1Config) {
        super(parser, http1Config);
        this.requestFactory = Args.notNull(requestFactory, "Request factory");
    }

    public DefaultHttpRequestParser(HttpRequestFactory<T> requestFactory, Http1Config http1Config) {
        this(requestFactory, null, http1Config);
    }

    public DefaultHttpRequestParser(HttpRequestFactory<T> requestFactory) {
        this(requestFactory, null);
    }

    @Override
    public T parse(SessionInputBuffer sessionBuffer, boolean endOfStream) throws IOException, HttpException {
        try {
            return (T)((HttpRequest)super.parse(sessionBuffer, endOfStream));
        }
        catch (MessageConstraintException ex) {
            throw new RequestHeaderFieldsTooLargeException(ex.getMessage(), ex);
        }
    }

    @Override
    protected T createMessage(CharArrayBuffer buffer) throws HttpException {
        RequestLine requestLine = this.getLineParser().parseRequestLine(buffer);
        T request = this.requestFactory.newHttpRequest(requestLine.getMethod(), requestLine.getUri());
        request.setVersion(requestLine.getProtocolVersion());
        return request;
    }
}

