/*
 * Decompiled with CFR 0.152.
 */
package shaded.bqjdbc.org.apache.hc.core5.http.protocol;

import java.io.IOException;
import java.net.URISyntaxException;
import shaded.bqjdbc.org.apache.hc.core5.annotation.Contract;
import shaded.bqjdbc.org.apache.hc.core5.annotation.ThreadingBehavior;
import shaded.bqjdbc.org.apache.hc.core5.http.EntityDetails;
import shaded.bqjdbc.org.apache.hc.core5.http.Header;
import shaded.bqjdbc.org.apache.hc.core5.http.HttpException;
import shaded.bqjdbc.org.apache.hc.core5.http.HttpRequest;
import shaded.bqjdbc.org.apache.hc.core5.http.HttpRequestInterceptor;
import shaded.bqjdbc.org.apache.hc.core5.http.HttpVersion;
import shaded.bqjdbc.org.apache.hc.core5.http.ProtocolException;
import shaded.bqjdbc.org.apache.hc.core5.http.ProtocolVersion;
import shaded.bqjdbc.org.apache.hc.core5.http.protocol.HttpContext;
import shaded.bqjdbc.org.apache.hc.core5.net.URIAuthority;
import shaded.bqjdbc.org.apache.hc.core5.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestValidateHost
implements HttpRequestInterceptor {
    @Override
    public void process(HttpRequest request, EntityDetails entity, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        Header header = request.getHeader("Host");
        if (header != null) {
            URIAuthority authority;
            try {
                authority = URIAuthority.create(header.getValue());
            }
            catch (URISyntaxException ex) {
                throw new ProtocolException(ex.getMessage(), ex);
            }
            request.setAuthority(authority);
        } else {
            ProtocolVersion version;
            ProtocolVersion protocolVersion = version = request.getVersion() != null ? request.getVersion() : HttpVersion.HTTP_1_1;
            if (version.greaterEquals(HttpVersion.HTTP_1_1)) {
                throw new ProtocolException("Host header is absent");
            }
        }
    }
}

