/*
 * Decompiled with CFR 0.152.
 */
package shaded.bqjdbc.org.apache.hc.core5.http2.impl.nio;

import java.io.IOException;
import java.nio.ByteBuffer;
import shaded.bqjdbc.org.apache.hc.core5.annotation.Internal;
import shaded.bqjdbc.org.apache.hc.core5.concurrent.FutureCallback;
import shaded.bqjdbc.org.apache.hc.core5.http.ConnectionClosedException;
import shaded.bqjdbc.org.apache.hc.core5.http.impl.nio.BufferedData;
import shaded.bqjdbc.org.apache.hc.core5.http2.impl.nio.ClientH2PrefaceHandler;
import shaded.bqjdbc.org.apache.hc.core5.http2.impl.nio.PrefaceHandlerBase;
import shaded.bqjdbc.org.apache.hc.core5.http2.impl.nio.ProtocolNegotiationException;
import shaded.bqjdbc.org.apache.hc.core5.http2.impl.nio.ServerH2IOEventHandler;
import shaded.bqjdbc.org.apache.hc.core5.http2.impl.nio.ServerH2StreamMultiplexerFactory;
import shaded.bqjdbc.org.apache.hc.core5.reactor.IOSession;
import shaded.bqjdbc.org.apache.hc.core5.reactor.ProtocolIOSession;
import shaded.bqjdbc.org.apache.hc.core5.util.Args;

@Internal
public class ServerH2PrefaceHandler
extends PrefaceHandlerBase {
    static final byte[] PREFACE = ClientH2PrefaceHandler.PREFACE;
    private final ServerH2StreamMultiplexerFactory http2StreamHandlerFactory;
    private final BufferedData inBuf;

    public ServerH2PrefaceHandler(ProtocolIOSession ioSession, ServerH2StreamMultiplexerFactory http2StreamHandlerFactory) {
        this(ioSession, http2StreamHandlerFactory, null);
    }

    public ServerH2PrefaceHandler(ProtocolIOSession ioSession, ServerH2StreamMultiplexerFactory http2StreamHandlerFactory, FutureCallback<ProtocolIOSession> resultCallback) {
        super(ioSession, resultCallback);
        this.http2StreamHandlerFactory = Args.notNull(http2StreamHandlerFactory, "HTTP/2 stream handler factory");
        this.inBuf = BufferedData.allocate(1024);
    }

    @Override
    public void connected(IOSession session) throws IOException {
    }

    @Override
    public void inputReady(IOSession session, ByteBuffer src) throws IOException {
        ByteBuffer data;
        int bytesRead;
        if (src != null) {
            this.inBuf.put(src);
        }
        boolean endOfStream = false;
        if (this.inBuf.length() < PREFACE.length && (bytesRead = this.inBuf.readFrom(session)) == -1) {
            endOfStream = true;
        }
        if ((data = this.inBuf.data()).remaining() >= PREFACE.length) {
            for (int i = 0; i < PREFACE.length; ++i) {
                if (data.get() == PREFACE[i]) continue;
                throw new ProtocolNegotiationException("Unexpected HTTP/2 preface");
            }
            this.startProtocol(new ServerH2IOEventHandler(this.http2StreamHandlerFactory.create(this.ioSession)), data.hasRemaining() ? data : null);
        } else if (endOfStream) {
            throw new ConnectionClosedException();
        }
    }

    @Override
    public void outputReady(IOSession session) throws IOException {
    }

    public String toString() {
        return this.getClass().getName();
    }
}

