/*
 * Decompiled with CFR 0.152.
 */
package shaded.bqjdbc.org.apache.hc.core5.http2.impl.nio.bootstrap;

import java.util.ArrayList;
import java.util.List;
import shaded.bqjdbc.org.apache.hc.core5.function.Callback;
import shaded.bqjdbc.org.apache.hc.core5.function.Decorator;
import shaded.bqjdbc.org.apache.hc.core5.function.Supplier;
import shaded.bqjdbc.org.apache.hc.core5.http.config.CharCodingConfig;
import shaded.bqjdbc.org.apache.hc.core5.http.config.Http1Config;
import shaded.bqjdbc.org.apache.hc.core5.http.config.NamedElementChain;
import shaded.bqjdbc.org.apache.hc.core5.http.impl.DefaultConnectionReuseStrategy;
import shaded.bqjdbc.org.apache.hc.core5.http.impl.DefaultContentLengthStrategy;
import shaded.bqjdbc.org.apache.hc.core5.http.impl.Http1StreamListener;
import shaded.bqjdbc.org.apache.hc.core5.http.impl.HttpProcessors;
import shaded.bqjdbc.org.apache.hc.core5.http.impl.bootstrap.HttpAsyncServer;
import shaded.bqjdbc.org.apache.hc.core5.http.impl.bootstrap.StandardFilter;
import shaded.bqjdbc.org.apache.hc.core5.http.impl.nio.DefaultHttpRequestParserFactory;
import shaded.bqjdbc.org.apache.hc.core5.http.impl.nio.DefaultHttpResponseWriterFactory;
import shaded.bqjdbc.org.apache.hc.core5.http.impl.nio.ServerHttp1StreamDuplexerFactory;
import shaded.bqjdbc.org.apache.hc.core5.http.nio.AsyncFilterHandler;
import shaded.bqjdbc.org.apache.hc.core5.http.nio.AsyncServerExchangeHandler;
import shaded.bqjdbc.org.apache.hc.core5.http.nio.AsyncServerRequestHandler;
import shaded.bqjdbc.org.apache.hc.core5.http.nio.HandlerFactory;
import shaded.bqjdbc.org.apache.hc.core5.http.nio.ssl.TlsStrategy;
import shaded.bqjdbc.org.apache.hc.core5.http.nio.support.AsyncServerExpectationFilter;
import shaded.bqjdbc.org.apache.hc.core5.http.nio.support.AsyncServerFilterChainElement;
import shaded.bqjdbc.org.apache.hc.core5.http.nio.support.AsyncServerFilterChainExchangeHandlerFactory;
import shaded.bqjdbc.org.apache.hc.core5.http.nio.support.BasicAsyncServerExpectationDecorator;
import shaded.bqjdbc.org.apache.hc.core5.http.nio.support.BasicServerExchangeHandler;
import shaded.bqjdbc.org.apache.hc.core5.http.nio.support.DefaultAsyncResponseExchangeHandlerFactory;
import shaded.bqjdbc.org.apache.hc.core5.http.nio.support.TerminalAsyncServerFilter;
import shaded.bqjdbc.org.apache.hc.core5.http.protocol.HttpProcessor;
import shaded.bqjdbc.org.apache.hc.core5.http.protocol.LookupRegistry;
import shaded.bqjdbc.org.apache.hc.core5.http.protocol.RequestHandlerRegistry;
import shaded.bqjdbc.org.apache.hc.core5.http.protocol.UriPatternType;
import shaded.bqjdbc.org.apache.hc.core5.http2.HttpVersionPolicy;
import shaded.bqjdbc.org.apache.hc.core5.http2.config.H2Config;
import shaded.bqjdbc.org.apache.hc.core5.http2.impl.H2Processors;
import shaded.bqjdbc.org.apache.hc.core5.http2.impl.nio.H2StreamListener;
import shaded.bqjdbc.org.apache.hc.core5.http2.impl.nio.ServerH2StreamMultiplexerFactory;
import shaded.bqjdbc.org.apache.hc.core5.http2.impl.nio.ServerHttpProtocolNegotiationStarter;
import shaded.bqjdbc.org.apache.hc.core5.http2.impl.nio.bootstrap.FilterEntry;
import shaded.bqjdbc.org.apache.hc.core5.http2.impl.nio.bootstrap.HandlerEntry;
import shaded.bqjdbc.org.apache.hc.core5.http2.ssl.H2ServerTlsStrategy;
import shaded.bqjdbc.org.apache.hc.core5.net.InetAddressUtils;
import shaded.bqjdbc.org.apache.hc.core5.reactor.IOEventHandlerFactory;
import shaded.bqjdbc.org.apache.hc.core5.reactor.IOReactorConfig;
import shaded.bqjdbc.org.apache.hc.core5.reactor.IOSession;
import shaded.bqjdbc.org.apache.hc.core5.reactor.IOSessionListener;
import shaded.bqjdbc.org.apache.hc.core5.util.Args;
import shaded.bqjdbc.org.apache.hc.core5.util.Timeout;

public class H2ServerBootstrap {
    private final List<HandlerEntry<Supplier<AsyncServerExchangeHandler>>> handlerList = new ArrayList<HandlerEntry<Supplier<AsyncServerExchangeHandler>>>();
    private final List<FilterEntry<AsyncFilterHandler>> filters = new ArrayList<FilterEntry<AsyncFilterHandler>>();
    private String canonicalHostName;
    private LookupRegistry<Supplier<AsyncServerExchangeHandler>> lookupRegistry;
    private IOReactorConfig ioReactorConfig;
    private HttpProcessor httpProcessor;
    private CharCodingConfig charCodingConfig;
    private HttpVersionPolicy versionPolicy;
    private H2Config h2Config;
    private Http1Config http1Config;
    private TlsStrategy tlsStrategy;
    private Timeout handshakeTimeout;
    private Decorator<IOSession> ioSessionDecorator;
    private Callback<Exception> exceptionCallback;
    private IOSessionListener sessionListener;
    private H2StreamListener h2StreamListener;
    private Http1StreamListener http1StreamListener;

    private H2ServerBootstrap() {
    }

    public static H2ServerBootstrap bootstrap() {
        return new H2ServerBootstrap();
    }

    public final H2ServerBootstrap setCanonicalHostName(String canonicalHostName) {
        this.canonicalHostName = canonicalHostName;
        return this;
    }

    public final H2ServerBootstrap setIOReactorConfig(IOReactorConfig ioReactorConfig) {
        this.ioReactorConfig = ioReactorConfig;
        return this;
    }

    public final H2ServerBootstrap setHttpProcessor(HttpProcessor httpProcessor) {
        this.httpProcessor = httpProcessor;
        return this;
    }

    public final H2ServerBootstrap setVersionPolicy(HttpVersionPolicy versionPolicy) {
        this.versionPolicy = versionPolicy;
        return this;
    }

    public final H2ServerBootstrap setH2Config(H2Config h2Config) {
        this.h2Config = h2Config;
        return this;
    }

    public final H2ServerBootstrap setHttp1Config(Http1Config http1Config) {
        this.http1Config = http1Config;
        return this;
    }

    public final H2ServerBootstrap setCharset(CharCodingConfig charCodingConfig) {
        this.charCodingConfig = charCodingConfig;
        return this;
    }

    public final H2ServerBootstrap setTlsStrategy(TlsStrategy tlsStrategy) {
        this.tlsStrategy = tlsStrategy;
        return this;
    }

    public final H2ServerBootstrap setHandshakeTimeout(Timeout handshakeTimeout) {
        this.handshakeTimeout = handshakeTimeout;
        return this;
    }

    public final H2ServerBootstrap setIOSessionDecorator(Decorator<IOSession> ioSessionDecorator) {
        this.ioSessionDecorator = ioSessionDecorator;
        return this;
    }

    public final H2ServerBootstrap setExceptionCallback(Callback<Exception> exceptionCallback) {
        this.exceptionCallback = exceptionCallback;
        return this;
    }

    public final H2ServerBootstrap setIOSessionListener(IOSessionListener sessionListener) {
        this.sessionListener = sessionListener;
        return this;
    }

    public final H2ServerBootstrap setStreamListener(H2StreamListener h2StreamListener) {
        this.h2StreamListener = h2StreamListener;
        return this;
    }

    public final H2ServerBootstrap setStreamListener(Http1StreamListener http1StreamListener) {
        this.http1StreamListener = http1StreamListener;
        return this;
    }

    public final H2ServerBootstrap setLookupRegistry(LookupRegistry<Supplier<AsyncServerExchangeHandler>> lookupRegistry) {
        this.lookupRegistry = lookupRegistry;
        return this;
    }

    public final H2ServerBootstrap register(String uriPattern, Supplier<AsyncServerExchangeHandler> supplier) {
        Args.notBlank(uriPattern, "URI pattern");
        Args.notNull(supplier, "Supplier");
        this.handlerList.add(new HandlerEntry<Supplier<AsyncServerExchangeHandler>>(null, uriPattern, supplier));
        return this;
    }

    public final H2ServerBootstrap registerVirtual(String hostname, String uriPattern, Supplier<AsyncServerExchangeHandler> supplier) {
        Args.notBlank(hostname, "Hostname");
        Args.notBlank(uriPattern, "URI pattern");
        Args.notNull(supplier, "Supplier");
        this.handlerList.add(new HandlerEntry<Supplier<AsyncServerExchangeHandler>>(hostname, uriPattern, supplier));
        return this;
    }

    public final <T> H2ServerBootstrap register(String uriPattern, AsyncServerRequestHandler<T> requestHandler) {
        this.register(uriPattern, () -> new BasicServerExchangeHandler(requestHandler));
        return this;
    }

    public final <T> H2ServerBootstrap registerVirtual(String hostname, String uriPattern, AsyncServerRequestHandler<T> requestHandler) {
        this.registerVirtual(hostname, uriPattern, () -> new BasicServerExchangeHandler(requestHandler));
        return this;
    }

    public final H2ServerBootstrap addFilterBefore(String existing, String name, AsyncFilterHandler filterHandler) {
        Args.notBlank(existing, "Existing");
        Args.notBlank(name, "Name");
        Args.notNull(filterHandler, "Filter handler");
        this.filters.add(new FilterEntry<AsyncFilterHandler>(FilterEntry.Position.BEFORE, name, filterHandler, existing));
        return this;
    }

    public final H2ServerBootstrap addFilterAfter(String existing, String name, AsyncFilterHandler filterHandler) {
        Args.notBlank(existing, "Existing");
        Args.notBlank(name, "Name");
        Args.notNull(filterHandler, "Filter handler");
        this.filters.add(new FilterEntry<AsyncFilterHandler>(FilterEntry.Position.AFTER, name, filterHandler, existing));
        return this;
    }

    public final H2ServerBootstrap replaceFilter(String existing, AsyncFilterHandler filterHandler) {
        Args.notBlank(existing, "Existing");
        Args.notNull(filterHandler, "Filter handler");
        this.filters.add(new FilterEntry<AsyncFilterHandler>(FilterEntry.Position.REPLACE, existing, filterHandler, existing));
        return this;
    }

    public final H2ServerBootstrap addFilterFirst(String name, AsyncFilterHandler filterHandler) {
        Args.notNull(name, "Name");
        Args.notNull(filterHandler, "Filter handler");
        this.filters.add(new FilterEntry<AsyncFilterHandler>(FilterEntry.Position.FIRST, name, filterHandler, null));
        return this;
    }

    public final H2ServerBootstrap addFilterLast(String name, AsyncFilterHandler filterHandler) {
        Args.notNull(name, "Name");
        Args.notNull(filterHandler, "Filter handler");
        this.filters.add(new FilterEntry<AsyncFilterHandler>(FilterEntry.Position.LAST, name, filterHandler, null));
        return this;
    }

    public HttpAsyncServer create() {
        HandlerFactory<AsyncServerExchangeHandler> handlerFactory;
        String actualCanonicalHostName = this.canonicalHostName != null ? this.canonicalHostName : InetAddressUtils.getCanonicalLocalHostName();
        RequestHandlerRegistry<Supplier<AsyncServerExchangeHandler>> registry = new RequestHandlerRegistry<Supplier<AsyncServerExchangeHandler>>(actualCanonicalHostName, () -> this.lookupRegistry != null ? this.lookupRegistry : UriPatternType.newMatcher(UriPatternType.URI_PATTERN));
        for (HandlerEntry<Supplier<AsyncServerExchangeHandler>> entry : this.handlerList) {
            registry.register(entry.hostname, entry.uriPattern, (Supplier<AsyncServerExchangeHandler>)entry.handler);
        }
        if (!this.filters.isEmpty()) {
            NamedElementChain<AsyncFilterHandler> filterChainDefinition = new NamedElementChain<AsyncFilterHandler>();
            filterChainDefinition.addLast(new TerminalAsyncServerFilter(new DefaultAsyncResponseExchangeHandlerFactory(registry)), StandardFilter.MAIN_HANDLER.name());
            filterChainDefinition.addFirst(new AsyncServerExpectationFilter(), StandardFilter.EXPECT_CONTINUE.name());
            for (FilterEntry<AsyncFilterHandler> entry : this.filters) {
                switch (entry.position) {
                    case AFTER: {
                        filterChainDefinition.addAfter(entry.existing, (AsyncFilterHandler)entry.filterHandler, entry.name);
                        break;
                    }
                    case BEFORE: {
                        filterChainDefinition.addBefore(entry.existing, (AsyncFilterHandler)entry.filterHandler, entry.name);
                        break;
                    }
                    case REPLACE: {
                        filterChainDefinition.replace(entry.existing, (AsyncFilterHandler)entry.filterHandler);
                        break;
                    }
                    case FIRST: {
                        filterChainDefinition.addFirst((AsyncFilterHandler)entry.filterHandler, entry.name);
                        break;
                    }
                    case LAST: {
                        filterChainDefinition.addBefore(StandardFilter.MAIN_HANDLER.name(), (AsyncFilterHandler)entry.filterHandler, entry.name);
                    }
                }
            }
            AsyncServerFilterChainElement execChain = null;
            for (NamedElementChain.Node current = filterChainDefinition.getLast(); current != null; current = current.getPrevious()) {
                execChain = new AsyncServerFilterChainElement((AsyncFilterHandler)current.getValue(), execChain);
            }
            handlerFactory = new AsyncServerFilterChainExchangeHandlerFactory(execChain, this.exceptionCallback);
        } else {
            handlerFactory = new DefaultAsyncResponseExchangeHandlerFactory(registry, handler -> new BasicAsyncServerExpectationDecorator((AsyncServerExchangeHandler)handler, this.exceptionCallback));
        }
        ServerH2StreamMultiplexerFactory http2StreamHandlerFactory = new ServerH2StreamMultiplexerFactory(this.httpProcessor != null ? this.httpProcessor : H2Processors.server(), handlerFactory, this.h2Config != null ? this.h2Config : H2Config.DEFAULT, this.charCodingConfig != null ? this.charCodingConfig : CharCodingConfig.DEFAULT, this.h2StreamListener);
        TlsStrategy actualTlsStrategy = this.tlsStrategy != null ? this.tlsStrategy : new H2ServerTlsStrategy();
        ServerHttp1StreamDuplexerFactory http1StreamHandlerFactory = new ServerHttp1StreamDuplexerFactory(this.httpProcessor != null ? this.httpProcessor : HttpProcessors.server(), handlerFactory, this.http1Config != null ? this.http1Config : Http1Config.DEFAULT, this.charCodingConfig != null ? this.charCodingConfig : CharCodingConfig.DEFAULT, DefaultConnectionReuseStrategy.INSTANCE, DefaultHttpRequestParserFactory.INSTANCE, DefaultHttpResponseWriterFactory.INSTANCE, DefaultContentLengthStrategy.INSTANCE, DefaultContentLengthStrategy.INSTANCE, this.http1StreamListener);
        ServerHttpProtocolNegotiationStarter ioEventHandlerFactory = new ServerHttpProtocolNegotiationStarter(http1StreamHandlerFactory, http2StreamHandlerFactory, this.versionPolicy != null ? this.versionPolicy : HttpVersionPolicy.NEGOTIATE, actualTlsStrategy, this.handshakeTimeout);
        return new HttpAsyncServer((IOEventHandlerFactory)ioEventHandlerFactory, this.ioReactorConfig, this.ioSessionDecorator, this.exceptionCallback, this.sessionListener, actualCanonicalHostName);
    }
}

