/*
 * Decompiled with CFR 0.152.
 */
package shaded.bqjdbc.org.apache.http.impl.client;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import shaded.bqjdbc.org.apache.commons.logging.Log;
import shaded.bqjdbc.org.apache.commons.logging.LogFactory;
import shaded.bqjdbc.org.apache.http.FormattedHeader;
import shaded.bqjdbc.org.apache.http.Header;
import shaded.bqjdbc.org.apache.http.HttpResponse;
import shaded.bqjdbc.org.apache.http.annotation.Contract;
import shaded.bqjdbc.org.apache.http.annotation.ThreadingBehavior;
import shaded.bqjdbc.org.apache.http.auth.AuthScheme;
import shaded.bqjdbc.org.apache.http.auth.AuthSchemeRegistry;
import shaded.bqjdbc.org.apache.http.auth.AuthenticationException;
import shaded.bqjdbc.org.apache.http.auth.MalformedChallengeException;
import shaded.bqjdbc.org.apache.http.client.AuthenticationHandler;
import shaded.bqjdbc.org.apache.http.protocol.HTTP;
import shaded.bqjdbc.org.apache.http.protocol.HttpContext;
import shaded.bqjdbc.org.apache.http.util.Asserts;
import shaded.bqjdbc.org.apache.http.util.CharArrayBuffer;

@Deprecated
@Contract(threading=ThreadingBehavior.IMMUTABLE)
public abstract class AbstractAuthenticationHandler
implements AuthenticationHandler {
    private final Log log = LogFactory.getLog(this.getClass());
    private static final List<String> DEFAULT_SCHEME_PRIORITY = Collections.unmodifiableList(Arrays.asList("Negotiate", "NTLM", "Digest", "Basic"));

    protected Map<String, Header> parseChallenges(Header[] headers) throws MalformedChallengeException {
        HashMap<String, Header> map = new HashMap<String, Header>(headers.length);
        for (Header header : headers) {
            int pos;
            CharArrayBuffer buffer;
            if (header instanceof FormattedHeader) {
                buffer = ((FormattedHeader)header).getBuffer();
                pos = ((FormattedHeader)header).getValuePos();
            } else {
                String s2 = header.getValue();
                if (s2 == null) {
                    throw new MalformedChallengeException("Header value is null");
                }
                buffer = new CharArrayBuffer(s2.length());
                buffer.append(s2);
                pos = 0;
            }
            while (pos < buffer.length() && HTTP.isWhitespace(buffer.charAt(pos))) {
                ++pos;
            }
            int beginIndex = pos;
            while (pos < buffer.length() && !HTTP.isWhitespace(buffer.charAt(pos))) {
                ++pos;
            }
            int endIndex = pos;
            String s3 = buffer.substring(beginIndex, endIndex);
            map.put(s3.toLowerCase(Locale.ROOT), header);
        }
        return map;
    }

    protected List<String> getAuthPreferences() {
        return DEFAULT_SCHEME_PRIORITY;
    }

    protected List<String> getAuthPreferences(HttpResponse response, HttpContext context) {
        return this.getAuthPreferences();
    }

    @Override
    public AuthScheme selectScheme(Map<String, Header> challenges, HttpResponse response, HttpContext context) throws AuthenticationException {
        AuthSchemeRegistry registry = (AuthSchemeRegistry)context.getAttribute("http.authscheme-registry");
        Asserts.notNull(registry, "AuthScheme registry");
        List<String> authPrefs = this.getAuthPreferences(response, context);
        if (authPrefs == null) {
            authPrefs = DEFAULT_SCHEME_PRIORITY;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Authentication schemes in the order of preference: " + authPrefs));
        }
        AuthScheme authScheme = null;
        for (String id : authPrefs) {
            Header challenge = challenges.get(id.toLowerCase(Locale.ENGLISH));
            if (challenge != null) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)(id + " authentication scheme selected"));
                }
                try {
                    authScheme = registry.getAuthScheme(id, response.getParams());
                    break;
                }
                catch (IllegalStateException e) {
                    if (!this.log.isWarnEnabled()) continue;
                    this.log.warn((Object)("Authentication scheme " + id + " not supported"));
                    continue;
                }
            }
            if (!this.log.isDebugEnabled()) continue;
            this.log.debug((Object)("Challenge for " + id + " authentication scheme not available"));
        }
        if (authScheme == null) {
            throw new AuthenticationException("Unable to respond to any of these challenges: " + challenges);
        }
        return authScheme;
    }
}

