/*
 * Decompiled with CFR 0.152.
 */
package shaded.bqjdbc.org.apache.http.impl.client;

import shaded.bqjdbc.org.apache.http.HeaderElement;
import shaded.bqjdbc.org.apache.http.HttpResponse;
import shaded.bqjdbc.org.apache.http.annotation.Contract;
import shaded.bqjdbc.org.apache.http.annotation.ThreadingBehavior;
import shaded.bqjdbc.org.apache.http.conn.ConnectionKeepAliveStrategy;
import shaded.bqjdbc.org.apache.http.message.BasicHeaderElementIterator;
import shaded.bqjdbc.org.apache.http.protocol.HttpContext;
import shaded.bqjdbc.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class DefaultConnectionKeepAliveStrategy
implements ConnectionKeepAliveStrategy {
    public static final DefaultConnectionKeepAliveStrategy INSTANCE = new DefaultConnectionKeepAliveStrategy();

    @Override
    public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
        Args.notNull(response, "HTTP response");
        BasicHeaderElementIterator it = new BasicHeaderElementIterator(response.headerIterator("Keep-Alive"));
        while (it.hasNext()) {
            HeaderElement he = it.nextElement();
            String param = he.getName();
            String value = he.getValue();
            if (value == null || !param.equalsIgnoreCase("timeout")) continue;
            try {
                return Long.parseLong(value) * 1000L;
            }
            catch (NumberFormatException numberFormatException) {
            }
        }
        return -1L;
    }
}

