/*
 * Decompiled with CFR 0.152.
 */
package shaded.bqjdbc.org.apache.http.impl.client;

import shaded.bqjdbc.org.apache.http.HttpResponse;
import shaded.bqjdbc.org.apache.http.annotation.Contract;
import shaded.bqjdbc.org.apache.http.annotation.ThreadingBehavior;
import shaded.bqjdbc.org.apache.http.client.ServiceUnavailableRetryStrategy;
import shaded.bqjdbc.org.apache.http.protocol.HttpContext;
import shaded.bqjdbc.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class DefaultServiceUnavailableRetryStrategy
implements ServiceUnavailableRetryStrategy {
    private final int maxRetries;
    private final long retryInterval;

    public DefaultServiceUnavailableRetryStrategy(int maxRetries, int retryInterval) {
        Args.positive(maxRetries, "Max retries");
        Args.positive(retryInterval, "Retry interval");
        this.maxRetries = maxRetries;
        this.retryInterval = retryInterval;
    }

    public DefaultServiceUnavailableRetryStrategy() {
        this(1, 1000);
    }

    @Override
    public boolean retryRequest(HttpResponse response, int executionCount, HttpContext context) {
        return executionCount <= this.maxRetries && response.getStatusLine().getStatusCode() == 503;
    }

    @Override
    public long getRetryInterval() {
        return this.retryInterval;
    }
}

