/*
 * Decompiled with CFR 0.152.
 */
package shaded.bqjdbc.org.apache.http.protocol;

import java.io.IOException;
import shaded.bqjdbc.org.apache.http.HttpEntityEnclosingRequest;
import shaded.bqjdbc.org.apache.http.HttpException;
import shaded.bqjdbc.org.apache.http.HttpRequest;
import shaded.bqjdbc.org.apache.http.HttpRequestInterceptor;
import shaded.bqjdbc.org.apache.http.annotation.Contract;
import shaded.bqjdbc.org.apache.http.annotation.ThreadingBehavior;
import shaded.bqjdbc.org.apache.http.protocol.HttpContext;
import shaded.bqjdbc.org.apache.http.protocol.HttpDateGenerator;
import shaded.bqjdbc.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.SAFE)
public class RequestDate
implements HttpRequestInterceptor {
    private static final HttpDateGenerator DATE_GENERATOR = new HttpDateGenerator();

    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (request instanceof HttpEntityEnclosingRequest && !request.containsHeader("Date")) {
            String httpdate = DATE_GENERATOR.getCurrentDate();
            request.setHeader("Date", httpdate);
        }
    }
}

