/*
 * Decompiled with CFR 0.152.
 */
package shaded.bqjdbc.org.apache.http.protocol;

import java.io.IOException;
import shaded.bqjdbc.org.apache.http.HttpEntity;
import shaded.bqjdbc.org.apache.http.HttpEntityEnclosingRequest;
import shaded.bqjdbc.org.apache.http.HttpException;
import shaded.bqjdbc.org.apache.http.HttpRequest;
import shaded.bqjdbc.org.apache.http.HttpRequestInterceptor;
import shaded.bqjdbc.org.apache.http.HttpVersion;
import shaded.bqjdbc.org.apache.http.ProtocolVersion;
import shaded.bqjdbc.org.apache.http.annotation.Contract;
import shaded.bqjdbc.org.apache.http.annotation.ThreadingBehavior;
import shaded.bqjdbc.org.apache.http.protocol.HttpContext;
import shaded.bqjdbc.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestExpectContinue
implements HttpRequestInterceptor {
    private final boolean activeByDefault;

    @Deprecated
    public RequestExpectContinue() {
        this(false);
    }

    public RequestExpectContinue(boolean activeByDefault) {
        this.activeByDefault = activeByDefault;
    }

    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (!request.containsHeader("Expect") && request instanceof HttpEntityEnclosingRequest) {
            boolean active;
            ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
            HttpEntity entity = ((HttpEntityEnclosingRequest)request).getEntity();
            if (entity != null && entity.getContentLength() != 0L && !ver.lessEquals(HttpVersion.HTTP_1_0) && (active = request.getParams().getBooleanParameter("http.protocol.expect-continue", this.activeByDefault))) {
                request.addHeader("Expect", "100-continue");
            }
        }
    }
}

