/*
 * Decompiled with CFR 0.152.
 */
package shaded.bqjdbc.org.threeten.extra;

import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.chrono.ChronoLocalDate;
import java.time.chrono.Chronology;
import java.time.format.ResolverStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalUnit;
import java.time.temporal.ValueRange;
import java.util.Map;

public final class PackedFields {
    public static final TemporalField PACKED_DATE = PackedDate.INSTANCE;
    public static final TemporalField PACKED_HOUR_MIN = PackedHourMin.INSTANCE;
    public static final TemporalField PACKED_TIME = PackedTime.INSTANCE;

    private PackedFields() {
    }

    private static void updateCheckConflict(Map<TemporalField, Long> fieldValues, TemporalField targetField, TemporalField changeField, long changeValue) {
        Long old = fieldValues.put(changeField, changeValue);
        if (old != null && changeValue != old) {
            throw new DateTimeException("Conflict found: " + changeField + " " + old + " differs from " + changeField + " " + changeValue + " while resolving  " + targetField);
        }
    }

    private static enum PackedTime implements TemporalField
    {
        INSTANCE;

        private static final ValueRange RANGE;
        private static final long serialVersionUID = -98266827687L;

        @Override
        public TemporalUnit getBaseUnit() {
            return ChronoUnit.SECONDS;
        }

        @Override
        public TemporalUnit getRangeUnit() {
            return ChronoUnit.DAYS;
        }

        @Override
        public boolean isDateBased() {
            return false;
        }

        @Override
        public boolean isTimeBased() {
            return true;
        }

        @Override
        public ValueRange range() {
            return RANGE;
        }

        @Override
        public boolean isSupportedBy(TemporalAccessor temporal) {
            return temporal.isSupported(ChronoField.SECOND_OF_DAY);
        }

        @Override
        public ValueRange rangeRefinedBy(TemporalAccessor temporal) {
            if (!temporal.isSupported(this)) {
                throw new DateTimeException("Unsupported field: " + this);
            }
            return this.range();
        }

        @Override
        public long getFrom(TemporalAccessor temporal) {
            int sod = temporal.get(ChronoField.SECOND_OF_DAY);
            int hour = sod / 3600;
            int min2 = sod / 60 % 60;
            int sec = sod % 60;
            return hour * 10000 + min2 * 100 + sec;
        }

        @Override
        public <R extends Temporal> R adjustInto(R temporal, long newValue) {
            RANGE.checkValidValue(newValue, INSTANCE);
            long hour = newValue / 10000L;
            long min2 = newValue % 10000L / 100L;
            long sec = newValue % 100L;
            ChronoField.HOUR_OF_DAY.checkValidValue(hour);
            ChronoField.MINUTE_OF_HOUR.checkValidValue(min2);
            ChronoField.SECOND_OF_MINUTE.checkValidValue(sec);
            long sod = 3600L * hour + 60L * min2 + sec;
            return (R)temporal.with(ChronoField.SECOND_OF_DAY, sod);
        }

        @Override
        public ChronoLocalDate resolve(Map<TemporalField, Long> fieldValues, TemporalAccessor partialTemporal, ResolverStyle resolverStyle) {
            long value = fieldValues.remove(this);
            long hour = value / 10000L;
            long min2 = value % 10000L / 100L;
            long sec = value % 100L;
            if (resolverStyle != ResolverStyle.LENIENT) {
                ChronoField.HOUR_OF_DAY.checkValidValue(hour);
                ChronoField.MINUTE_OF_HOUR.checkValidValue(min2);
                ChronoField.SECOND_OF_MINUTE.checkValidValue(sec);
            }
            long sod = 3600L * hour + 60L * min2 + sec;
            PackedFields.updateCheckConflict(fieldValues, this, ChronoField.SECOND_OF_DAY, sod);
            return null;
        }

        @Override
        public String toString() {
            return "PackedTime";
        }

        static {
            RANGE = ValueRange.of(0L, 235959L);
        }
    }

    private static enum PackedHourMin implements TemporalField
    {
        INSTANCE;

        private static final ValueRange RANGE;
        private static final long serialVersionUID = -871357658587L;

        @Override
        public TemporalUnit getBaseUnit() {
            return ChronoUnit.MINUTES;
        }

        @Override
        public TemporalUnit getRangeUnit() {
            return ChronoUnit.DAYS;
        }

        @Override
        public boolean isDateBased() {
            return false;
        }

        @Override
        public boolean isTimeBased() {
            return true;
        }

        @Override
        public ValueRange range() {
            return RANGE;
        }

        @Override
        public boolean isSupportedBy(TemporalAccessor temporal) {
            return temporal.isSupported(ChronoField.MINUTE_OF_DAY);
        }

        @Override
        public ValueRange rangeRefinedBy(TemporalAccessor temporal) {
            if (!temporal.isSupported(this)) {
                throw new DateTimeException("Unsupported field: " + this);
            }
            return this.range();
        }

        @Override
        public long getFrom(TemporalAccessor temporal) {
            int mod = temporal.get(ChronoField.MINUTE_OF_DAY);
            int hour = mod / 60;
            int min2 = mod % 60;
            return hour * 100 + min2;
        }

        @Override
        public <R extends Temporal> R adjustInto(R temporal, long newValue) {
            long hour = newValue / 100L;
            long min2 = newValue % 100L;
            ChronoField.HOUR_OF_DAY.checkValidValue(hour);
            ChronoField.MINUTE_OF_HOUR.checkValidValue(min2);
            return (R)temporal.with(ChronoField.HOUR_OF_DAY, hour).with(ChronoField.MINUTE_OF_HOUR, min2);
        }

        @Override
        public ChronoLocalDate resolve(Map<TemporalField, Long> fieldValues, TemporalAccessor partialTemporal, ResolverStyle resolverStyle) {
            long value = fieldValues.remove(this);
            long hour = value / 100L;
            long min2 = value % 100L;
            if (resolverStyle != ResolverStyle.LENIENT) {
                ChronoField.HOUR_OF_DAY.checkValidValue(hour);
                ChronoField.MINUTE_OF_HOUR.checkValidValue(min2);
            }
            long mod = hour * 60L + min2;
            PackedFields.updateCheckConflict(fieldValues, this, ChronoField.MINUTE_OF_DAY, mod);
            return null;
        }

        @Override
        public String toString() {
            return "PackedHourMin";
        }

        static {
            RANGE = ValueRange.of(0L, 2359L);
        }
    }

    private static enum PackedDate implements TemporalField
    {
        INSTANCE;

        private static final ValueRange RANGE;
        private static final long serialVersionUID = -38752465672576L;

        @Override
        public TemporalUnit getBaseUnit() {
            return ChronoUnit.DAYS;
        }

        @Override
        public TemporalUnit getRangeUnit() {
            return ChronoUnit.FOREVER;
        }

        @Override
        public boolean isDateBased() {
            return true;
        }

        @Override
        public boolean isTimeBased() {
            return false;
        }

        @Override
        public ValueRange range() {
            return RANGE;
        }

        @Override
        public boolean isSupportedBy(TemporalAccessor temporal) {
            return temporal.isSupported(ChronoField.EPOCH_DAY);
        }

        @Override
        public ValueRange rangeRefinedBy(TemporalAccessor temporal) {
            if (!temporal.isSupported(this)) {
                throw new DateTimeException("Unsupported field: " + this);
            }
            return this.range();
        }

        @Override
        public long getFrom(TemporalAccessor temporal) {
            LocalDate date = LocalDate.ofEpochDay(temporal.getLong(ChronoField.EPOCH_DAY));
            int year = date.getYear();
            if (year < 1000 || year > 9999) {
                throw new DateTimeException("Unable to obtain PackedDate from LocalDate: " + date);
            }
            int moy = date.getMonthValue();
            int dom = date.getDayOfMonth();
            return year * 10000 + moy * 100 + dom;
        }

        @Override
        public <R extends Temporal> R adjustInto(R temporal, long newValue) {
            LocalDate date = this.toDate(newValue);
            return (R)temporal.with(date);
        }

        private LocalDate toDate(long newValue) {
            if (!this.range().isValidValue(newValue)) {
                throw new DateTimeException("Invalid value: PackedDate " + newValue);
            }
            int val = (int)newValue;
            int year = val / 10000;
            int moy = val % 10000 / 100;
            int dom = val % 100;
            return LocalDate.of(year, moy, dom);
        }

        @Override
        public ChronoLocalDate resolve(Map<TemporalField, Long> fieldValues, TemporalAccessor partialTemporal, ResolverStyle resolverStyle) {
            LocalDate date;
            long value = fieldValues.remove(this);
            if (resolverStyle == ResolverStyle.LENIENT) {
                int year = Math.toIntExact(value / 10000L);
                int moy = (int)(value % 10000L / 100L);
                long dom = value % 100L;
                date = LocalDate.of(year, 1, 1).plusMonths(moy - 1).plusDays(dom - 1L);
            } else {
                date = this.toDate(value);
            }
            Chronology chrono = Chronology.from(partialTemporal);
            return chrono.date(date);
        }

        @Override
        public String toString() {
            return "PackedDate";
        }

        static {
            RANGE = ValueRange.of(10000101L, 99991231L);
        }
    }
}

