/*
 * Decompiled with CFR 0.152.
 */
package shaded.bqjdbc.org.threeten.extra.chrono;

import java.io.Serializable;
import java.time.Clock;
import java.time.Instant;
import java.time.ZoneId;
import java.time.chrono.AbstractChronology;
import java.time.chrono.ChronoLocalDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.time.chrono.Era;
import java.time.format.ResolverStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalField;
import java.time.temporal.ValueRange;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import shaded.bqjdbc.org.threeten.extra.chrono.JulianDate;
import shaded.bqjdbc.org.threeten.extra.chrono.JulianEra;

public final class JulianChronology
extends AbstractChronology
implements Serializable {
    public static final JulianChronology INSTANCE = new JulianChronology();
    private static final long serialVersionUID = 7291205177830286973L;
    static final ValueRange YEAR_RANGE = ValueRange.of(-999998L, 999999L);
    static final ValueRange YOE_RANGE = ValueRange.of(1L, 999999L);
    static final ValueRange PROLEPTIC_MONTH_RANGE = ValueRange.of(-11999976L, 11999999L);

    @Deprecated
    public JulianChronology() {
    }

    private Object readResolve() {
        return INSTANCE;
    }

    @Override
    public String getId() {
        return "Julian";
    }

    @Override
    public String getCalendarType() {
        return "julian";
    }

    @Override
    public JulianDate date(Era era, int yearOfEra, int month, int dayOfMonth) {
        return this.date(this.prolepticYear(era, yearOfEra), month, dayOfMonth);
    }

    @Override
    public JulianDate date(int prolepticYear, int month, int dayOfMonth) {
        return JulianDate.of(prolepticYear, month, dayOfMonth);
    }

    @Override
    public JulianDate dateYearDay(Era era, int yearOfEra, int dayOfYear) {
        return this.dateYearDay(this.prolepticYear(era, yearOfEra), dayOfYear);
    }

    @Override
    public JulianDate dateYearDay(int prolepticYear, int dayOfYear) {
        return JulianDate.ofYearDay(prolepticYear, dayOfYear);
    }

    @Override
    public JulianDate dateEpochDay(long epochDay) {
        return JulianDate.ofEpochDay(epochDay);
    }

    @Override
    public JulianDate dateNow() {
        return JulianDate.now();
    }

    @Override
    public JulianDate dateNow(ZoneId zone) {
        return JulianDate.now(zone);
    }

    @Override
    public JulianDate dateNow(Clock clock) {
        return JulianDate.now(clock);
    }

    @Override
    public JulianDate date(TemporalAccessor temporal) {
        return JulianDate.from(temporal);
    }

    public ChronoLocalDateTime<JulianDate> localDateTime(TemporalAccessor temporal) {
        return super.localDateTime(temporal);
    }

    public ChronoZonedDateTime<JulianDate> zonedDateTime(TemporalAccessor temporal) {
        return super.zonedDateTime(temporal);
    }

    public ChronoZonedDateTime<JulianDate> zonedDateTime(Instant instant, ZoneId zone) {
        return super.zonedDateTime(instant, zone);
    }

    @Override
    public boolean isLeapYear(long prolepticYear) {
        return prolepticYear % 4L == 0L;
    }

    @Override
    public int prolepticYear(Era era, int yearOfEra) {
        if (!(era instanceof JulianEra)) {
            throw new ClassCastException("Era must be JulianEra");
        }
        return era == JulianEra.AD ? yearOfEra : 1 - yearOfEra;
    }

    @Override
    public JulianEra eraOf(int eraValue) {
        return JulianEra.of(eraValue);
    }

    @Override
    public List<Era> eras() {
        return Arrays.asList(JulianEra.values());
    }

    @Override
    public ValueRange range(ChronoField field) {
        switch (field) {
            case PROLEPTIC_MONTH: {
                return PROLEPTIC_MONTH_RANGE;
            }
            case YEAR_OF_ERA: {
                return YOE_RANGE;
            }
            case YEAR: {
                return YEAR_RANGE;
            }
        }
        return field.range();
    }

    @Override
    public JulianDate resolveDate(Map<TemporalField, Long> fieldValues, ResolverStyle resolverStyle) {
        return (JulianDate)super.resolveDate(fieldValues, resolverStyle);
    }
}

