/*
 * Decompiled with CFR 0.152.
 */
package shaded.bqjdbc.org.threeten.extra.chrono;

import java.io.Serializable;
import java.time.Clock;
import java.time.Instant;
import java.time.ZoneId;
import java.time.chrono.AbstractChronology;
import java.time.chrono.ChronoLocalDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.time.chrono.Era;
import java.time.format.ResolverStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalField;
import java.time.temporal.ValueRange;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import shaded.bqjdbc.org.threeten.extra.chrono.PaxDate;
import shaded.bqjdbc.org.threeten.extra.chrono.PaxEra;

public final class PaxChronology
extends AbstractChronology
implements Serializable {
    public static final PaxChronology INSTANCE = new PaxChronology();
    private static final long serialVersionUID = -7021464635577802085L;
    static final int WEEKS_IN_LEAP_MONTH = 1;
    static final int DAYS_IN_WEEK = 7;
    static final int WEEKS_IN_MONTH = 4;
    static final int MONTHS_IN_YEAR = 13;
    static final int DAYS_IN_MONTH = 28;
    static final int DAYS_IN_YEAR = 364;
    static final int WEEKS_IN_YEAR = 52;
    static final ValueRange ALIGNED_WEEK_OF_MONTH_RANGE = ValueRange.of(1L, 1L, 4L);
    static final ValueRange ALIGNED_WEEK_OF_YEAR_RANGE = ValueRange.of(1L, 52L, 53L);
    static final ValueRange DAY_OF_MONTH_RANGE = ValueRange.of(1L, 7L, 28L);
    static final ValueRange DAY_OF_YEAR_RANGE = ValueRange.of(1L, 364L, 371L);
    static final ValueRange MONTH_OF_YEAR_RANGE = ValueRange.of(1L, 13L, 14L);

    @Deprecated
    public PaxChronology() {
    }

    private Object readResolve() {
        return INSTANCE;
    }

    @Override
    public String getId() {
        return "Pax";
    }

    @Override
    public String getCalendarType() {
        return "pax";
    }

    @Override
    public PaxDate date(Era era, int yearOfEra, int month, int dayOfMonth) {
        return this.date(this.prolepticYear(era, yearOfEra), month, dayOfMonth);
    }

    @Override
    public PaxDate date(int prolepticYear, int month, int dayOfMonth) {
        return PaxDate.of(prolepticYear, month, dayOfMonth);
    }

    @Override
    public PaxDate dateYearDay(Era era, int yearOfEra, int dayOfYear) {
        return this.dateYearDay(this.prolepticYear(era, yearOfEra), dayOfYear);
    }

    @Override
    public PaxDate dateYearDay(int prolepticYear, int dayOfYear) {
        return PaxDate.ofYearDay(prolepticYear, dayOfYear);
    }

    @Override
    public PaxDate dateEpochDay(long epochDay) {
        return PaxDate.ofEpochDay(epochDay);
    }

    @Override
    public PaxDate dateNow() {
        return PaxDate.now();
    }

    @Override
    public PaxDate dateNow(ZoneId zone) {
        return PaxDate.now(zone);
    }

    @Override
    public PaxDate dateNow(Clock clock) {
        return PaxDate.now(clock);
    }

    @Override
    public PaxDate date(TemporalAccessor temporal) {
        return PaxDate.from(temporal);
    }

    public ChronoLocalDateTime<PaxDate> localDateTime(TemporalAccessor temporal) {
        return super.localDateTime(temporal);
    }

    public ChronoZonedDateTime<PaxDate> zonedDateTime(TemporalAccessor temporal) {
        return super.zonedDateTime(temporal);
    }

    public ChronoZonedDateTime<PaxDate> zonedDateTime(Instant instant, ZoneId zone) {
        return super.zonedDateTime(instant, zone);
    }

    @Override
    public boolean isLeapYear(long prolepticYear) {
        long lastTwoDigits = prolepticYear % 100L;
        return Math.abs(lastTwoDigits) == 99L || prolepticYear % 400L != 0L && (lastTwoDigits == 0L || lastTwoDigits % 6L == 0L);
    }

    @Override
    public int prolepticYear(Era era, int yearOfEra) {
        if (!(era instanceof PaxEra)) {
            throw new ClassCastException("Era must be PaxEra");
        }
        return era == PaxEra.CE ? yearOfEra : 1 - yearOfEra;
    }

    @Override
    public PaxEra eraOf(int eraValue) {
        return PaxEra.of(eraValue);
    }

    @Override
    public List<Era> eras() {
        return Arrays.asList(PaxEra.values());
    }

    @Override
    public ValueRange range(ChronoField field) {
        switch (field) {
            case ALIGNED_WEEK_OF_MONTH: {
                return ALIGNED_WEEK_OF_MONTH_RANGE;
            }
            case ALIGNED_WEEK_OF_YEAR: {
                return ALIGNED_WEEK_OF_YEAR_RANGE;
            }
            case DAY_OF_MONTH: {
                return DAY_OF_MONTH_RANGE;
            }
            case DAY_OF_YEAR: {
                return DAY_OF_YEAR_RANGE;
            }
            case MONTH_OF_YEAR: {
                return MONTH_OF_YEAR_RANGE;
            }
        }
        return field.range();
    }

    @Override
    public PaxDate resolveDate(Map<TemporalField, Long> fieldValues, ResolverStyle resolverStyle) {
        return (PaxDate)super.resolveDate(fieldValues, resolverStyle);
    }
}

