/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.services.bigquery.model.DatasetReference;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import io.opentelemetry.api.common.Attributes;
import java.io.Serializable;
import java.util.Objects;

public final class DatasetId
implements Serializable {
    private static final long serialVersionUID = -6186254820908152300L;
    private final String project;
    private final String dataset;

    public String getProject() {
        return this.project;
    }

    public String getDataset() {
        return this.dataset;
    }

    private DatasetId(String project, String dataset) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(dataset), "Provided dataset is null or empty");
        this.project = project;
        this.dataset = dataset;
    }

    public static DatasetId of(String project, String dataset) {
        return new DatasetId(project, dataset);
    }

    public static DatasetId of(String dataset) {
        return new DatasetId(null, dataset);
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof DatasetId && Objects.equals(this.toPb(), ((DatasetId)obj).toPb());
    }

    public int hashCode() {
        return Objects.hash(this.project, this.dataset);
    }

    public String toString() {
        return this.toPb().toString();
    }

    DatasetId setProjectId(String projectId) {
        return this.getProject() != null ? this : DatasetId.of(projectId, this.getDataset());
    }

    DatasetReference toPb() {
        return new DatasetReference().setProjectId(this.project).setDatasetId(this.dataset);
    }

    static DatasetId fromPb(DatasetReference datasetRef) {
        return new DatasetId(datasetRef.getProjectId(), datasetRef.getDatasetId());
    }

    protected Attributes getOtelAttributes() {
        return Attributes.builder().put("bq.dataset.project", this.getProject()).put("bq.dataset.id", this.getDataset()).build();
    }
}

