/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.common.base.MoreObjects;
import java.io.Serializable;
import java.util.Objects;

public final class EncryptionConfiguration
implements Serializable {
    private static final long serialVersionUID = -100849671239964L;
    private final String kmsKeyName;

    public String getKmsKeyName() {
        return this.kmsKeyName;
    }

    public com.google.api.services.bigquery.model.EncryptionConfiguration toPb() {
        com.google.api.services.bigquery.model.EncryptionConfiguration encryptionConfigurationPb = new com.google.api.services.bigquery.model.EncryptionConfiguration();
        encryptionConfigurationPb.setKmsKeyName(this.kmsKeyName);
        return encryptionConfigurationPb;
    }

    private EncryptionConfiguration(Builder builder) {
        this.kmsKeyName = builder.kmsKeyName;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("kmsKeyName", this.kmsKeyName).toString();
    }

    public int hashCode() {
        return Objects.hash(this.kmsKeyName);
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof EncryptionConfiguration && Objects.equals(this.kmsKeyName, ((EncryptionConfiguration)obj).getKmsKeyName());
    }

    public static final class Builder {
        private String kmsKeyName;

        private Builder() {
        }

        private Builder(EncryptionConfiguration options) {
            this.kmsKeyName = options.kmsKeyName;
        }

        public Builder(com.google.api.services.bigquery.model.EncryptionConfiguration encryptionConfigurationPb) {
            this.setKmsKeyName(encryptionConfigurationPb.getKmsKeyName());
        }

        public Builder setKmsKeyName(String kmsKeyName) {
            this.kmsKeyName = kmsKeyName;
            return this;
        }

        public EncryptionConfiguration build() {
            return new EncryptionConfiguration(this);
        }
    }
}

