/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.cloud.BaseWriteChannel;
import com.google.cloud.RestorableState;
import com.google.cloud.WriteChannel;
import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.BigQueryException;
import com.google.cloud.bigquery.BigQueryOptions;
import com.google.cloud.bigquery.BigQueryRetryConfig;
import com.google.cloud.bigquery.BigQueryRetryHelper;
import com.google.cloud.bigquery.Job;
import com.google.cloud.bigquery.JobId;
import com.google.cloud.bigquery.WriteChannelConfiguration;
import io.opentelemetry.context.ImplicitContextKeyed;
import io.opentelemetry.context.Scope;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;

public class TableDataWriteChannel
extends BaseWriteChannel<BigQueryOptions, WriteChannelConfiguration> {
    private static final BigQueryRetryConfig EMPTY_RETRY_CONFIG = BigQueryRetryConfig.newBuilder().build();
    private Job job;

    TableDataWriteChannel(BigQueryOptions options, JobId jobId, WriteChannelConfiguration writeChannelConfiguration) {
        this(options, writeChannelConfiguration, TableDataWriteChannel.open(options, jobId, writeChannelConfiguration));
    }

    TableDataWriteChannel(BigQueryOptions options, WriteChannelConfiguration config, String uploadId) {
        super(options, config, uploadId);
    }

    @Override
    protected void flushBuffer(final int length, final boolean last) {
        ImplicitContextKeyed flushBuffer = null;
        if (((BigQueryOptions)this.getOptions()).isOpenTelemetryTracingEnabled() && ((BigQueryOptions)this.getOptions()).getOpenTelemetryTracer() != null) {
            flushBuffer = ((BigQueryOptions)this.getOptions()).getOpenTelemetryTracer().spanBuilder("com.google.cloud.bigquery.TableDataWriteChannel.flushBuffer").setAttribute("bq.table_data_write_channel.flush_buffer.length", (long)length).setAttribute("bq.table_data_write_channel.flush_buffer.last", last).startSpan();
        }
        try (Scope flushBufferScope = flushBuffer != null ? flushBuffer.makeCurrent() : null;){
            com.google.api.services.bigquery.model.Job jobPb = BigQueryRetryHelper.runWithRetries(new Callable<com.google.api.services.bigquery.model.Job>(){

                @Override
                public com.google.api.services.bigquery.model.Job call() throws IOException {
                    return ((BigQueryOptions)TableDataWriteChannel.this.getOptions()).getBigQueryRpcV2().writeSkipExceptionTranslation(TableDataWriteChannel.this.getUploadId(), TableDataWriteChannel.this.getBuffer(), 0, TableDataWriteChannel.this.getPosition(), length, last);
                }
            }, ((BigQueryOptions)this.getOptions()).getRetrySettings(), ((BigQueryOptions)this.getOptions()).getResultRetryAlgorithm(), ((BigQueryOptions)this.getOptions()).getClock(), EMPTY_RETRY_CONFIG, ((BigQueryOptions)this.getOptions()).isOpenTelemetryTracingEnabled(), ((BigQueryOptions)this.getOptions()).getOpenTelemetryTracer());
            this.job = jobPb != null ? Job.fromPb((BigQuery)((BigQueryOptions)this.getOptions()).getService(), jobPb) : null;
        }
        catch (BigQueryRetryHelper.BigQueryRetryHelperException e) {
            throw BigQueryException.translateAndThrow(e);
        }
        finally {
            if (flushBuffer != null) {
                flushBuffer.end();
            }
        }
    }

    protected StateImpl.Builder stateBuilder() {
        return StateImpl.builder((BigQueryOptions)this.getOptions(), (WriteChannelConfiguration)this.getEntity(), this.getUploadId(), this.job);
    }

    private static String open(final BigQueryOptions options, final JobId jobId, final WriteChannelConfiguration writeChannelConfiguration) {
        ImplicitContextKeyed open = null;
        if (options.isOpenTelemetryTracingEnabled() && options.getOpenTelemetryTracer() != null) {
            open = options.getOpenTelemetryTracer().spanBuilder("com.google.cloud.bigquery.TableDataWriteChannel.open").setAllAttributes(jobId.getOtelAttributes()).setAllAttributes(writeChannelConfiguration.getDestinationTable().getOtelAttributes()).startSpan();
        }
        try {
            Scope openScope = open != null ? open.makeCurrent() : null;
            try {
                String string = BigQueryRetryHelper.runWithRetries(new Callable<String>(){

                    @Override
                    public String call() throws IOException {
                        return options.getBigQueryRpcV2().openSkipExceptionTranslation(new com.google.api.services.bigquery.model.Job().setConfiguration(writeChannelConfiguration.toPb()).setJobReference(jobId.toPb()));
                    }
                }, options.getRetrySettings(), options.getResultRetryAlgorithm(), options.getClock(), EMPTY_RETRY_CONFIG, options.isOpenTelemetryTracingEnabled(), options.getOpenTelemetryTracer());
                if (openScope != null) {
                    openScope.close();
                }
                return string;
            }
            catch (Throwable throwable) {
                try {
                    if (openScope != null) {
                        try {
                            openScope.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (BigQueryRetryHelper.BigQueryRetryHelperException e) {
                    throw BigQueryException.translateAndThrow(e);
                }
            }
        }
        finally {
            if (open != null) {
                open.end();
            }
        }
    }

    private void setJob(Job job) {
        this.job = job;
    }

    public Job getJob() {
        return this.job;
    }

    static class StateImpl
    extends BaseWriteChannel.BaseState<BigQueryOptions, WriteChannelConfiguration> {
        private static final long serialVersionUID = -2692851818766876346L;
        private final Job job;

        StateImpl(Builder builder) {
            super(builder);
            this.job = builder.job;
        }

        static Builder builder(BigQueryOptions options, WriteChannelConfiguration config, String uploadId, Job job) {
            return new Builder(options, config, uploadId, job);
        }

        @Override
        public WriteChannel restore() {
            TableDataWriteChannel channel = new TableDataWriteChannel((BigQueryOptions)this.serviceOptions, (WriteChannelConfiguration)this.entity, this.uploadId);
            channel.restore(this);
            channel.setJob(this.job);
            return channel;
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.job);
        }

        @Override
        public boolean equals(Object obj) {
            return super.equals(obj) && obj instanceof StateImpl && Objects.equals(this.job, ((StateImpl)obj).job);
        }

        @Override
        protected List<BaseWriteChannel.BaseState.ValueHolder> toStringHelper() {
            List<BaseWriteChannel.BaseState.ValueHolder> valueList = super.toStringHelper();
            valueList.add(BaseWriteChannel.BaseState.ValueHolder.create("job", this.job));
            return valueList;
        }

        static class Builder
        extends BaseWriteChannel.BaseState.Builder<BigQueryOptions, WriteChannelConfiguration> {
            private final Job job;

            private Builder(BigQueryOptions options, WriteChannelConfiguration configuration, String uploadId, Job job) {
                super(options, configuration, uploadId);
                this.job = job;
            }

            @Override
            public RestorableState<WriteChannel> build() {
                return new StateImpl(this);
            }
        }
    }
}

