/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.jdbc;

import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.Field;
import com.google.cloud.bigquery.FieldList;
import com.google.cloud.bigquery.Job;
import com.google.cloud.bigquery.JobId;
import com.google.cloud.bigquery.JobStatistics;
import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.StandardSQLTypeName;
import com.google.cloud.bigquery.exception.BigQueryConversionException;
import com.google.cloud.bigquery.exception.BigQueryJdbcCoercionException;
import com.google.cloud.bigquery.exception.BigQueryJdbcCoercionNotFoundException;
import com.google.cloud.bigquery.jdbc.BigQueryJdbcCustomLogger;
import com.google.cloud.bigquery.jdbc.BigQueryNoOpsResultSet;
import com.google.cloud.bigquery.jdbc.BigQueryResultSet;
import com.google.cloud.bigquery.jdbc.BigQueryResultSetMetadata;
import com.google.cloud.bigquery.jdbc.BigQueryStatement;
import com.google.cloud.bigquery.jdbc.BigQueryTypeCoercer;
import com.google.cloud.bigquery.jdbc.BigQueryTypeCoercionUtility;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import javax.sql.rowset.serial.SerialBlob;
import javax.sql.rowset.serial.SerialClob;

public abstract class BigQueryBaseResultSet
extends BigQueryNoOpsResultSet
implements BigQueryResultSet {
    protected final BigQueryJdbcCustomLogger LOG = new BigQueryJdbcCustomLogger(this.toString());
    private BigQuery bigQuery;
    private JobId jobId;
    private String queryId;
    private JobStatistics.QueryStatistics queryStatistics;
    protected final BigQueryStatement statement;
    protected final Schema schema;
    protected final FieldList schemaFieldList;
    protected final boolean isNested;
    protected boolean isClosed = false;
    protected boolean wasNull = false;
    protected final BigQueryTypeCoercer bigQueryTypeCoercer = BigQueryTypeCoercionUtility.INSTANCE;

    protected BigQueryBaseResultSet(BigQuery bigQuery, BigQueryStatement statement, Schema schema, boolean isNested) {
        this.bigQuery = bigQuery;
        this.statement = statement;
        this.schema = schema;
        this.schemaFieldList = schema != null ? schema.getFields() : null;
        this.isNested = isNested;
    }

    @Override
    public JobStatistics.QueryStatistics getQueryStatistics() {
        if (this.queryStatistics != null) {
            return this.queryStatistics;
        }
        if (this.jobId == null || this.bigQuery == null) {
            return null;
        }
        Job job = this.bigQuery.getJob(this.jobId, new BigQuery.JobOption[0]);
        this.queryStatistics = job != null ? (JobStatistics.QueryStatistics)job.getStatistics() : null;
        return this.queryStatistics;
    }

    public void setJobId(JobId jobId) {
        this.jobId = jobId;
    }

    @Override
    public JobId getJobId() {
        return this.jobId;
    }

    public void setQueryId(String queryId) {
        this.queryId = queryId;
    }

    @Override
    public String getQueryId() {
        return this.queryId;
    }

    @Override
    public void close() {
        try {
            if (this.statement != null && this.statement.isCloseOnCompletion() && !this.statement.hasMoreResults()) {
                this.statement.close();
            }
        }
        catch (SQLException ex) {
            this.LOG.warning(String.format("Exception during ResultState.close() operation: %s", ex.getMessage()));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected SQLException createCoercionException(int columnIndex, Class<?> targetClass, Exception cause) throws SQLException {
        String typeName;
        this.checkClosed();
        if (this.isNested) {
            if (columnIndex == 1) {
                return new BigQueryConversionException(String.format("Cannot convert index column to type %s.", targetClass.getSimpleName()), cause);
            }
            if (columnIndex != 2) throw new SQLException("For a nested ResultSet from an Array, columnIndex must be 1 or 2.", cause);
            Field arrayField = this.schema.getFields().get(0);
            StandardSQLTypeName type = arrayField.getType().getStandardType();
            typeName = type.name();
            return new BigQueryConversionException(String.format("Cannot convert value of type %s to type %s.", typeName, targetClass.getSimpleName()), cause);
        } else {
            Field field = this.schemaFieldList.get(columnIndex - 1);
            StandardSQLTypeName type = field.getType().getStandardType();
            typeName = type.name();
        }
        return new BigQueryConversionException(String.format("Cannot convert value of type %s to type %s.", typeName, targetClass.getSimpleName()), cause);
    }

    private StandardSQLTypeName getStandardSQLTypeName(int columnIndex) throws SQLException {
        this.checkClosed();
        if (this.isNested) {
            if (columnIndex == 1) {
                return StandardSQLTypeName.INT64;
            }
            if (columnIndex == 2) {
                if (this.schema == null || this.schema.getFields().isEmpty()) {
                    throw new SQLException("Schema not available for nested result set.");
                }
                Field arrayField = this.schema.getFields().get(0);
                return arrayField.getType().getStandardType();
            }
            throw new SQLException("For a nested ResultSet from an Array, columnIndex must be 1 or 2.");
        }
        if (this.schemaFieldList == null || columnIndex > this.schemaFieldList.size() || columnIndex < 1) {
            throw new SQLException("Invalid column index: " + columnIndex);
        }
        Field field = this.schemaFieldList.get(columnIndex - 1);
        return field.getType().getStandardType();
    }

    protected void setWasNull(Object val) {
        this.wasNull = val == null;
    }

    @Override
    public boolean wasNull() throws SQLException {
        this.checkClosed();
        return this.wasNull;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkClosed();
        if (this.isNested) {
            return BigQueryResultSetMetadata.of(this.schemaFieldList, this.statement);
        }
        return BigQueryResultSetMetadata.of(this.schema.getFields(), this.statement);
    }

    @Override
    public int getType() throws SQLException {
        this.checkClosed();
        return 1003;
    }

    @Override
    public int getConcurrency() throws SQLException {
        this.checkClosed();
        return 1007;
    }

    @Override
    public Statement getStatement() throws SQLException {
        this.checkClosed();
        return this.statement;
    }

    @Override
    public int getHoldability() throws SQLException {
        this.checkClosed();
        return 1;
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public abstract Object getObject(int var1) throws SQLException;

    protected int getColumnIndex(String columnLabel) throws SQLException {
        this.LOG.finest("++enter++");
        this.checkClosed();
        if (columnLabel == null) {
            throw new SQLException("Column label cannot be null");
        }
        return this.schemaFieldList.getIndex(columnLabel) + 1;
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        this.LOG.finest("++enter++");
        try {
            Object value = this.getObject(columnIndex);
            return this.bigQueryTypeCoercer.coerceTo(String.class, value);
        }
        catch (BigQueryJdbcCoercionNotFoundException e) {
            throw this.createCoercionException(columnIndex, String.class, e);
        }
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        this.LOG.finest("++enter++");
        StandardSQLTypeName type = this.getStandardSQLTypeName(columnIndex);
        if (type == StandardSQLTypeName.GEOGRAPHY || type == StandardSQLTypeName.RANGE || type == StandardSQLTypeName.JSON) {
            throw this.createCoercionException(columnIndex, Boolean.class, null);
        }
        try {
            Object value = this.getObject(columnIndex);
            return this.bigQueryTypeCoercer.coerceTo(Boolean.class, value);
        }
        catch (BigQueryJdbcCoercionNotFoundException e) {
            throw this.createCoercionException(columnIndex, Boolean.class, e);
        }
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        this.LOG.finest("++enter++");
        try {
            Object value = this.getObject(columnIndex);
            return this.bigQueryTypeCoercer.coerceTo(Byte.class, value);
        }
        catch (BigQueryJdbcCoercionException | BigQueryJdbcCoercionNotFoundException e) {
            throw this.createCoercionException(columnIndex, Byte.class, e);
        }
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        this.LOG.finest("++enter++");
        try {
            Object value = this.getObject(columnIndex);
            return this.bigQueryTypeCoercer.coerceTo(Short.class, value);
        }
        catch (BigQueryJdbcCoercionException | BigQueryJdbcCoercionNotFoundException e) {
            throw this.createCoercionException(columnIndex, Short.class, e);
        }
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        this.LOG.finest("++enter++");
        try {
            Object value = this.getObject(columnIndex);
            return this.bigQueryTypeCoercer.coerceTo(Integer.class, value);
        }
        catch (BigQueryJdbcCoercionException | BigQueryJdbcCoercionNotFoundException e) {
            throw this.createCoercionException(columnIndex, Integer.class, e);
        }
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        this.LOG.finest("++enter++");
        try {
            Object value = this.getObject(columnIndex);
            return this.bigQueryTypeCoercer.coerceTo(Long.class, value);
        }
        catch (BigQueryJdbcCoercionException | BigQueryJdbcCoercionNotFoundException e) {
            throw this.createCoercionException(columnIndex, Long.class, e);
        }
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        this.LOG.finest("++enter++");
        try {
            Object value = this.getObject(columnIndex);
            return this.bigQueryTypeCoercer.coerceTo(Float.class, value).floatValue();
        }
        catch (BigQueryJdbcCoercionException | BigQueryJdbcCoercionNotFoundException e) {
            throw this.createCoercionException(columnIndex, Float.class, e);
        }
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        this.LOG.finest("++enter++");
        try {
            Object value = this.getObject(columnIndex);
            return this.bigQueryTypeCoercer.coerceTo(Double.class, value);
        }
        catch (BigQueryJdbcCoercionException | BigQueryJdbcCoercionNotFoundException e) {
            throw this.createCoercionException(columnIndex, Double.class, e);
        }
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        this.LOG.finest("++enter++");
        try {
            Object value = this.getObject(columnIndex);
            return this.bigQueryTypeCoercer.coerceTo(BigDecimal.class, value);
        }
        catch (BigQueryJdbcCoercionException | BigQueryJdbcCoercionNotFoundException e) {
            throw this.createCoercionException(columnIndex, BigDecimal.class, e);
        }
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        this.LOG.finest("++enter++");
        try {
            Object value = this.getObject(columnIndex);
            return this.bigQueryTypeCoercer.coerceTo(byte[].class, value);
        }
        catch (BigQueryJdbcCoercionNotFoundException e) {
            throw this.createCoercionException(columnIndex, byte[].class, e);
        }
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        this.LOG.finest("++enter++");
        try {
            Object value = this.getObject(columnIndex);
            return this.bigQueryTypeCoercer.coerceTo(Date.class, value);
        }
        catch (BigQueryJdbcCoercionNotFoundException e) {
            throw this.createCoercionException(columnIndex, Date.class, e);
        }
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        this.LOG.finest("++enter++");
        StandardSQLTypeName type = this.getStandardSQLTypeName(columnIndex);
        if (type == StandardSQLTypeName.INT64) {
            throw this.createCoercionException(columnIndex, Time.class, null);
        }
        try {
            Object value = this.getObject(columnIndex);
            return this.bigQueryTypeCoercer.coerceTo(Time.class, value);
        }
        catch (BigQueryJdbcCoercionNotFoundException e) {
            throw this.createCoercionException(columnIndex, Time.class, e);
        }
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        this.LOG.finest("++enter++");
        StandardSQLTypeName type = this.getStandardSQLTypeName(columnIndex);
        if (type == StandardSQLTypeName.INT64) {
            throw this.createCoercionException(columnIndex, Timestamp.class, null);
        }
        try {
            Object value = this.getObject(columnIndex);
            return this.bigQueryTypeCoercer.coerceTo(Timestamp.class, value);
        }
        catch (BigQueryJdbcCoercionNotFoundException e) {
            throw this.createCoercionException(columnIndex, Timestamp.class, e);
        }
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        this.LOG.finest("++enter++");
        try {
            Object value = this.getObject(columnIndex);
            return this.bigQueryTypeCoercer.coerceTo(BigDecimal.class, value);
        }
        catch (BigQueryJdbcCoercionException | BigQueryJdbcCoercionNotFoundException e) {
            throw this.createCoercionException(columnIndex, BigDecimal.class, e);
        }
    }

    @Override
    public Array getArray(int columnIndex) throws SQLException {
        this.LOG.finest("++enter++");
        try {
            return (Array)this.getObject(columnIndex);
        }
        catch (ClassCastException e) {
            throw this.createCoercionException(columnIndex, Array.class, e);
        }
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        this.LOG.finest("++enter++");
        byte[] value = this.getBytes(columnIndex);
        return new SerialBlob(value);
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        this.LOG.finest("++enter++");
        String value = this.getString(columnIndex);
        return new SerialClob(value.toCharArray());
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        this.LOG.finest("++enter++");
        String value = this.getString(columnIndex);
        return value == null ? null : new StringReader(value);
    }

    private InputStream getInputStream(String value, Charset charset) {
        this.LOG.finest("++enter++");
        if (value == null) {
            return null;
        }
        return new ByteArrayInputStream(value.getBytes(charset));
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        this.LOG.finest("++enter++");
        return this.getInputStream(this.getString(columnIndex), StandardCharsets.US_ASCII);
    }

    @Override
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        this.LOG.finest("++enter++");
        return this.getInputStream(this.getString(columnIndex), StandardCharsets.UTF_16LE);
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        this.LOG.finest("++enter++");
        byte[] bytes = this.getBytes(columnIndex);
        return bytes == null ? null : new ByteArrayInputStream(bytes);
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        this.LOG.finest("++enter++");
        Date date = this.getDate(columnIndex);
        if (date == null || cal == null) {
            return null;
        }
        cal.setTimeInMillis(date.getTime());
        return new Date(cal.getTimeInMillis());
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        this.LOG.finest("++enter++");
        Time time = this.getTime(columnIndex);
        if (time == null || cal == null) {
            return null;
        }
        cal.setTimeInMillis(time.getTime());
        return new Time(cal.getTimeInMillis());
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        this.LOG.finest("++enter++");
        Timestamp timeStamp = this.getTimestamp(columnIndex);
        if (timeStamp == null || cal == null) {
            return null;
        }
        cal.setTimeInMillis(timeStamp.getTime());
        return new Timestamp(cal.getTimeInMillis());
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        this.LOG.finest("++enter++");
        return this.getColumnIndex(columnLabel);
    }

    @Override
    public Object getObject(String columnLabel) throws SQLException {
        return this.getObject(this.getColumnIndex(columnLabel));
    }

    @Override
    public String getString(String columnLabel) throws SQLException {
        return this.getString(this.getColumnIndex(columnLabel));
    }

    @Override
    public boolean getBoolean(String columnLabel) throws SQLException {
        return this.getBoolean(this.getColumnIndex(columnLabel));
    }

    @Override
    public byte getByte(String columnLabel) throws SQLException {
        return this.getByte(this.getColumnIndex(columnLabel));
    }

    @Override
    public short getShort(String columnLabel) throws SQLException {
        return this.getShort(this.getColumnIndex(columnLabel));
    }

    @Override
    public int getInt(String columnLabel) throws SQLException {
        return this.getInt(this.getColumnIndex(columnLabel));
    }

    @Override
    public long getLong(String columnLabel) throws SQLException {
        return this.getLong(this.getColumnIndex(columnLabel));
    }

    @Override
    public float getFloat(String columnLabel) throws SQLException {
        return this.getFloat(this.getColumnIndex(columnLabel));
    }

    @Override
    public double getDouble(String columnLabel) throws SQLException {
        return this.getDouble(this.getColumnIndex(columnLabel));
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel, int scale) throws SQLException {
        return this.getBigDecimal(this.getColumnIndex(columnLabel), scale);
    }

    @Override
    public byte[] getBytes(String columnLabel) throws SQLException {
        return this.getBytes(this.getColumnIndex(columnLabel));
    }

    @Override
    public Date getDate(String columnLabel) throws SQLException {
        return this.getDate(this.getColumnIndex(columnLabel));
    }

    @Override
    public Time getTime(String columnLabel) throws SQLException {
        return this.getTime(this.getColumnIndex(columnLabel));
    }

    @Override
    public Timestamp getTimestamp(String columnLabel) throws SQLException {
        return this.getTimestamp(this.getColumnIndex(columnLabel));
    }

    @Override
    public InputStream getAsciiStream(String columnLabel) throws SQLException {
        return this.getAsciiStream(this.getColumnIndex(columnLabel));
    }

    @Override
    public InputStream getUnicodeStream(String columnLabel) throws SQLException {
        return this.getUnicodeStream(this.getColumnIndex(columnLabel));
    }

    @Override
    public InputStream getBinaryStream(String columnLabel) throws SQLException {
        return this.getBinaryStream(this.getColumnIndex(columnLabel));
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel) throws SQLException {
        return this.getBigDecimal(this.getColumnIndex(columnLabel));
    }

    @Override
    public Blob getBlob(String columnLabel) throws SQLException {
        return this.getBlob(this.getColumnIndex(columnLabel));
    }

    @Override
    public Clob getClob(String columnLabel) throws SQLException {
        return this.getClob(this.getColumnIndex(columnLabel));
    }

    @Override
    public Array getArray(String columnLabel) throws SQLException {
        return this.getArray(this.getColumnIndex(columnLabel));
    }

    @Override
    public Reader getCharacterStream(String columnLabel) throws SQLException {
        return this.getCharacterStream(this.getColumnIndex(columnLabel));
    }

    @Override
    public Date getDate(String columnLabel, Calendar cal) throws SQLException {
        return this.getDate(this.getColumnIndex(columnLabel), cal);
    }

    @Override
    public Time getTime(String columnLabel, Calendar cal) throws SQLException {
        return this.getTime(this.getColumnIndex(columnLabel), cal);
    }

    @Override
    public Timestamp getTimestamp(String columnLabel, Calendar cal) throws SQLException {
        return this.getTimestamp(this.getColumnIndex(columnLabel), cal);
    }
}

