/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.jdbc;

import com.google.cloud.bigquery.Field;
import com.google.cloud.bigquery.FieldList;
import com.google.cloud.bigquery.StandardSQLTypeName;
import com.google.cloud.bigquery.exception.BigQueryJdbcSqlFeatureNotSupportedException;
import com.google.cloud.bigquery.jdbc.BigQueryJdbcCustomLogger;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Base64;
import java.util.Map;
import org.apache.arrow.vector.util.Text;

abstract class BigQueryBaseStruct
implements Struct {
    private static final BigQueryJdbcCustomLogger LOG = new BigQueryJdbcCustomLogger(BigQueryBaseStruct.class.getName());

    BigQueryBaseStruct() {
    }

    abstract FieldList getSchema();

    @Override
    public final String getSQLTypeName() throws SQLException {
        throw new BigQueryJdbcSqlFeatureNotSupportedException("Customized Types are not supported yet.");
    }

    @Override
    public final Object[] getAttributes(Map<String, Class<?>> map) throws SQLException {
        throw new BigQueryJdbcSqlFeatureNotSupportedException("Customized Types are not supported yet.");
    }

    static boolean isStruct(Field currentSchema) {
        LOG.finest("++enter++");
        return currentSchema.getType().getStandardType() == StandardSQLTypeName.STRUCT;
    }

    public String toString() {
        try {
            FieldList schema = this.getSchema();
            Object[] attributes = this.getAttributes();
            if (schema == null || attributes == null || schema.size() != attributes.length) {
                return "{}";
            }
            StringBuilder sb = new StringBuilder("{");
            for (int i = 0; i < attributes.length; ++i) {
                if (i > 0) {
                    sb.append(",");
                }
                String fieldName = schema.get(i).getName();
                Object value = attributes[i];
                sb.append("\"").append(fieldName.replace("\"", "\\\"")).append("\":");
                if (value == null) {
                    sb.append("null");
                    continue;
                }
                if (value instanceof String || value instanceof Text) {
                    String stringValue = value.toString().replace("\"", "\\\"");
                    sb.append("\"").append(stringValue).append("\"");
                    continue;
                }
                if (value instanceof Timestamp || value instanceof Date || value instanceof Time) {
                    sb.append("\"").append(value.toString()).append("\"");
                    continue;
                }
                if (value instanceof byte[]) {
                    sb.append("\"").append(Base64.getEncoder().encodeToString((byte[])value)).append("\"");
                    continue;
                }
                sb.append(value.toString());
            }
            sb.append("}");
            return sb.toString();
        }
        catch (SQLException e) {
            return "{ \"error\": \"Error converting struct to string: " + e.getMessage() + "\" }";
        }
    }
}

