/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.jdbc;

import com.google.api.gax.core.FixedCredentialsProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.FixedHeaderProvider;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.auth.Credentials;
import com.google.cloud.RetryOption;
import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.BigQueryException;
import com.google.cloud.bigquery.BigQueryOptions;
import com.google.cloud.bigquery.ConnectionProperty;
import com.google.cloud.bigquery.DatasetId;
import com.google.cloud.bigquery.Job;
import com.google.cloud.bigquery.JobInfo;
import com.google.cloud.bigquery.JobStatistics;
import com.google.cloud.bigquery.QueryJobConfiguration;
import com.google.cloud.bigquery.exception.BigQueryJdbcException;
import com.google.cloud.bigquery.exception.BigQueryJdbcRuntimeException;
import com.google.cloud.bigquery.exception.BigQueryJdbcSqlFeatureNotSupportedException;
import com.google.cloud.bigquery.jdbc.BigQueryCallableStatement;
import com.google.cloud.bigquery.jdbc.BigQueryDatabaseMetaData;
import com.google.cloud.bigquery.jdbc.BigQueryJdbcCustomLogger;
import com.google.cloud.bigquery.jdbc.BigQueryJdbcOAuthUtility;
import com.google.cloud.bigquery.jdbc.BigQueryJdbcProxyUtility;
import com.google.cloud.bigquery.jdbc.BigQueryJdbcUrlUtility;
import com.google.cloud.bigquery.jdbc.BigQueryNoOpsConnection;
import com.google.cloud.bigquery.jdbc.BigQueryPreparedStatement;
import com.google.cloud.bigquery.jdbc.BigQueryStatement;
import com.google.cloud.bigquery.storage.v1.BigQueryReadClient;
import com.google.cloud.bigquery.storage.v1.BigQueryReadSettings;
import com.google.cloud.bigquery.storage.v1.BigQueryWriteClient;
import com.google.cloud.bigquery.storage.v1.BigQueryWriteSettings;
import com.google.cloud.http.HttpTransportOptions;
import java.io.IOException;
import java.io.InputStream;
import java.sql.CallableStatement;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.time.Duration;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class BigQueryConnection
extends BigQueryNoOpsConnection {
    private final BigQueryJdbcCustomLogger LOG = new BigQueryJdbcCustomLogger(this.toString());
    String connectionClassName = this.toString();
    private static final String DEFAULT_JDBC_TOKEN_VALUE = "Google-BigQuery-JDBC-Driver";
    private static final String DEFAULT_VERSION = "0.0.0";
    private static HeaderProvider HEADER_PROVIDER;
    BigQueryReadClient bigQueryReadClient = null;
    BigQueryWriteClient bigQueryWriteClient = null;
    BigQuery bigQuery;
    String connectionUrl;
    Set<Statement> openStatements;
    boolean autoCommit;
    int transactionIsolation;
    List<SQLWarning> sqlWarnings;
    String catalog;
    int holdability;
    long retryTimeoutInSeconds;
    Duration retryTimeoutDuration;
    long retryInitialDelayInSeconds;
    Duration retryInitialDelayDuration;
    long retryMaxDelayInSeconds;
    Duration retryMaxDelayDuration;
    boolean transactionStarted;
    ConnectionProperty sessionInfoConnectionProperty;
    boolean isClosed;
    DatasetId defaultDataset;
    String location;
    boolean enableHighThroughputAPI;
    int highThroughputMinTableSize;
    int highThroughputActivationRatio;
    boolean enableSession;
    boolean unsupportedHTAPIFallback;
    boolean useQueryCache;
    String queryDialect;
    int metadataFetchThreadCount;
    boolean allowLargeResults;
    String destinationTable;
    String destinationDataset;
    long destinationDatasetExpirationTime;
    String kmsKeyName;
    String universeDomain;
    List<ConnectionProperty> queryProperties;
    Map<String, String> authProperties;
    Map<String, String> overrideProperties;
    Credentials credentials;
    boolean useStatelessQueryMode;
    int numBufferedRows;
    HttpTransportOptions httpTransportOptions;
    TransportChannelProvider transportChannelProvider;
    long maxResults;
    long jobTimeoutInSeconds;
    boolean enableWriteAPI;
    int writeAPIActivationRowCount;
    int writeAPIAppendRowCount;
    int requestGoogleDriveScope;
    List<String> additionalProjects;
    boolean filterTablesOnDefaultDataset;
    String sslTrustStorePath;
    String sslTrustStorePassword;
    long maxBytesBilled;
    Map<String, String> labels;

    BigQueryConnection(String url) throws IOException {
        this.connectionUrl = url;
        this.openStatements = ConcurrentHashMap.newKeySet();
        this.autoCommit = true;
        this.sqlWarnings = new ArrayList<SQLWarning>();
        this.transactionStarted = false;
        this.isClosed = false;
        this.labels = BigQueryJdbcUrlUtility.parseLabels(url, this.connectionClassName);
        this.maxBytesBilled = BigQueryJdbcUrlUtility.parseMaximumBytesBilled(url, this.connectionClassName);
        this.retryTimeoutInSeconds = BigQueryJdbcUrlUtility.parseRetryTimeoutInSecs(url, this.connectionClassName);
        this.retryTimeoutDuration = Duration.ofMillis(this.retryTimeoutInSeconds * 1000L);
        this.retryInitialDelayInSeconds = BigQueryJdbcUrlUtility.parseRetryInitialDelayInSecs(url, this.connectionClassName);
        this.retryInitialDelayDuration = Duration.ofMillis(this.retryInitialDelayInSeconds * 1000L);
        this.retryMaxDelayInSeconds = BigQueryJdbcUrlUtility.parseRetryMaxDelayInSecs(url, this.connectionClassName);
        this.retryMaxDelayDuration = Duration.ofMillis(this.retryMaxDelayInSeconds * 1000L);
        this.jobTimeoutInSeconds = BigQueryJdbcUrlUtility.parseJobTimeout(url, this.connectionClassName);
        this.authProperties = BigQueryJdbcOAuthUtility.parseOAuthProperties(url, this.connectionClassName);
        this.catalog = BigQueryJdbcUrlUtility.parseStringProperty(url, "ProjectId", BigQueryOptions.getDefaultProjectId(), this.connectionClassName);
        this.universeDomain = BigQueryJdbcUrlUtility.parseStringProperty(url, "universeDomain", "googleapis.com", this.connectionClassName);
        this.overrideProperties = BigQueryJdbcUrlUtility.parseOverrideProperties(url, this.connectionClassName);
        if (this.universeDomain != null) {
            this.overrideProperties.put("universeDomain", this.universeDomain);
        }
        this.credentials = BigQueryJdbcOAuthUtility.getCredentials(this.authProperties, this.overrideProperties, this.connectionClassName);
        String defaultDatasetString = BigQueryJdbcUrlUtility.parseStringProperty(url, "DefaultDataset", null, this.connectionClassName);
        if (defaultDatasetString == null || defaultDatasetString.trim().isEmpty()) {
            this.defaultDataset = null;
        } else {
            String[] parts = defaultDatasetString.split("\\.");
            if (parts.length == 2) {
                this.defaultDataset = DatasetId.of(parts[0], parts[1]);
            } else if (parts.length == 1) {
                this.defaultDataset = DatasetId.of(parts[0]);
            } else {
                throw new IllegalArgumentException("DefaultDataset format is invalid. Supported options are datasetId or projectId.datasetId");
            }
        }
        this.location = BigQueryJdbcUrlUtility.parseStringProperty(url, "Location", null, this.connectionClassName);
        this.enableHighThroughputAPI = BigQueryJdbcUrlUtility.parseBooleanProperty(url, "EnableHighThroughputAPI", false, this.connectionClassName);
        this.highThroughputMinTableSize = BigQueryJdbcUrlUtility.parseIntProperty(url, "HighThroughputMinTableSize", 100, this.connectionClassName);
        this.highThroughputActivationRatio = BigQueryJdbcUrlUtility.parseIntProperty(url, "HighThroughputActivationRatio", 2, this.connectionClassName);
        this.useQueryCache = BigQueryJdbcUrlUtility.parseBooleanProperty(url, "UseQueryCache", true, this.connectionClassName);
        this.useStatelessQueryMode = BigQueryJdbcUrlUtility.parseJobCreationMode(url, this.connectionClassName);
        this.queryDialect = BigQueryJdbcUrlUtility.parseStringProperty(url, "QueryDialect", "SQL", this.connectionClassName);
        this.allowLargeResults = BigQueryJdbcUrlUtility.parseBooleanProperty(url, "AllowLargeResults", true, this.connectionClassName);
        this.destinationTable = BigQueryJdbcUrlUtility.parseStringProperty(url, "LargeResultTable", null, this.connectionClassName);
        this.destinationDataset = BigQueryJdbcUrlUtility.parseStringProperty(url, "LargeResultDataset", null, this.connectionClassName);
        this.destinationDatasetExpirationTime = BigQueryJdbcUrlUtility.parseLongProperty(url, "LargeResultsDatasetExpirationTime", 3600000L, this.connectionClassName);
        this.kmsKeyName = BigQueryJdbcUrlUtility.parseStringProperty(url, "KMSKeyName", null, this.connectionClassName);
        Map<String, String> proxyProperties = BigQueryJdbcProxyUtility.parseProxyProperties(url, this.connectionClassName);
        this.sslTrustStorePath = BigQueryJdbcUrlUtility.parseStringProperty(url, "SSLTrustStore", null, this.connectionClassName);
        this.sslTrustStorePassword = BigQueryJdbcUrlUtility.parseStringProperty(url, "SSLTrustStorePwd", null, this.connectionClassName);
        this.httpTransportOptions = BigQueryJdbcProxyUtility.getHttpTransportOptions(proxyProperties, this.sslTrustStorePath, this.sslTrustStorePassword, this.connectionClassName);
        this.transportChannelProvider = BigQueryJdbcProxyUtility.getTransportChannelProvider(proxyProperties, this.sslTrustStorePath, this.sslTrustStorePassword, this.connectionClassName);
        this.enableSession = BigQueryJdbcUrlUtility.parseBooleanProperty(url, "EnableSession", false, this.connectionClassName);
        this.unsupportedHTAPIFallback = BigQueryJdbcUrlUtility.parseBooleanProperty(url, "UnsupportedHTAPIFallback", true, this.connectionClassName);
        this.maxResults = BigQueryJdbcUrlUtility.parseLongProperty(url, "MaxResults", 10000L, this.connectionClassName);
        Map<String, String> queryPropertiesMap = BigQueryJdbcUrlUtility.parseQueryProperties(url, this.connectionClassName);
        this.sessionInfoConnectionProperty = this.getSessionPropertyFromQueryProperties(queryPropertiesMap);
        this.queryProperties = this.convertMapToConnectionPropertiesList(queryPropertiesMap);
        this.enableWriteAPI = BigQueryJdbcUrlUtility.parseBooleanProperty(url, "EnableWriteAPI", false, this.connectionClassName);
        this.writeAPIActivationRowCount = BigQueryJdbcUrlUtility.parseIntProperty(url, "SWA_ActivationRowCount", 3, this.connectionClassName);
        this.writeAPIAppendRowCount = BigQueryJdbcUrlUtility.parseIntProperty(url, "SWA_AppendRowCount", 1000, this.connectionClassName);
        this.additionalProjects = BigQueryJdbcUrlUtility.parseStringListProperty(url, "AdditionalProjects", this.connectionClassName);
        this.filterTablesOnDefaultDataset = BigQueryJdbcUrlUtility.parseBooleanProperty(url, "FilterTablesOnDefaultDataset", false, this.connectionClassName);
        this.requestGoogleDriveScope = BigQueryJdbcUrlUtility.parseIntProperty(url, "RequestGoogleDriveScope", 0, this.connectionClassName);
        this.metadataFetchThreadCount = BigQueryJdbcUrlUtility.parseIntProperty(url, "MetaDataFetchThreadCount", 32, this.connectionClassName);
        HEADER_PROVIDER = this.createHeaderProvider();
        this.bigQuery = this.getBigQueryConnection();
    }

    String getLibraryVersion(Class<?> libraryClass) {
        this.LOG.finest("++enter++");
        String version = null;
        try (InputStream in = libraryClass.getResourceAsStream("/com/google/cloud/bigquery/jdbc/dependencies.properties");){
            if (in != null) {
                Properties props = new Properties();
                props.load(in);
                version = props.getProperty("version.jdbc");
            }
        }
        catch (IOException e) {
            return DEFAULT_VERSION;
        }
        return version != null ? version : DEFAULT_VERSION;
    }

    private String buildPartnerToken(String url) {
        String partnerTokenString = BigQueryJdbcUrlUtility.parsePartnerTokenProperty(url, this.connectionClassName);
        if (partnerTokenString == null || partnerTokenString.isEmpty()) {
            return "";
        }
        return partnerTokenString;
    }

    HeaderProvider createHeaderProvider() {
        String partnerToken = this.buildPartnerToken(this.connectionUrl);
        String headerToken = "Google-BigQuery-JDBC-Driver/" + this.getLibraryVersion(this.getClass()) + partnerToken;
        return FixedHeaderProvider.create("user-agent", headerToken);
    }

    protected void addOpenStatements(Statement statement) {
        this.LOG.finest(String.format("Statement %s added to Connection %s.", statement, this));
        this.openStatements.add(statement);
    }

    BigQueryReadClient getBigQueryReadClient() {
        try {
            if (this.bigQueryReadClient == null) {
                this.bigQueryReadClient = this.getBigQueryReadClientConnection();
            }
        }
        catch (IOException e) {
            throw new BigQueryJdbcRuntimeException(e);
        }
        return this.bigQueryReadClient;
    }

    BigQueryWriteClient getBigQueryWriteClient() {
        try {
            if (this.bigQueryWriteClient == null) {
                this.bigQueryWriteClient = this.getBigQueryWriteClientConnection();
            }
        }
        catch (IOException e) {
            throw new BigQueryJdbcRuntimeException(e);
        }
        return this.bigQueryWriteClient;
    }

    BigQuery getBigQuery() {
        return this.bigQuery;
    }

    String getConnectionUrl() {
        return this.connectionUrl;
    }

    @Override
    public Statement createStatement() throws SQLException {
        this.checkClosed();
        BigQueryStatement currentStatement = new BigQueryStatement(this);
        this.LOG.fine(String.format("Statement %s created.", currentStatement));
        this.addOpenStatements(currentStatement);
        return currentStatement;
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkClosed();
        if (resultSetType != 1003 || resultSetConcurrency != 1007) {
            throw new BigQueryJdbcSqlFeatureNotSupportedException("Unsupported createStatement feature.");
        }
        return this.createStatement();
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.LOG.finest("++enter++");
        this.checkClosed();
        if (resultSetType != 1003 || resultSetConcurrency != 1007 || resultSetHoldability != 2) {
            throw new BigQueryJdbcSqlFeatureNotSupportedException("Unsupported createStatement feature");
        }
        return this.createStatement();
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        this.checkClosed();
        BigQueryPreparedStatement currentStatement = new BigQueryPreparedStatement(this, sql);
        this.LOG.fine(String.format("Prepared Statement %s created.", currentStatement));
        this.addOpenStatements(currentStatement);
        return currentStatement;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        if (autoGeneratedKeys != 2) {
            throw new BigQueryJdbcSqlFeatureNotSupportedException("autoGeneratedKeys is not supported");
        }
        return this.prepareStatement(sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        throw new BigQueryJdbcSqlFeatureNotSupportedException("autoGeneratedKeys is not supported");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (resultSetType != 1003 || resultSetConcurrency != 1007 || resultSetHoldability != 2) {
            throw new BigQueryJdbcSqlFeatureNotSupportedException("Unsupported prepareStatement feature");
        }
        return this.prepareStatement(sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.LOG.finest("++enter++");
        if (resultSetType != 1003 || resultSetConcurrency != 1007) {
            throw new BigQueryJdbcSqlFeatureNotSupportedException("Unsupported prepareStatement feature");
        }
        return this.prepareStatement(sql);
    }

    public DatasetId getDefaultDataset() {
        this.checkClosed();
        return this.defaultDataset;
    }

    String getDestinationDataset() {
        return this.destinationDataset;
    }

    String getDestinationTable() {
        return this.destinationTable;
    }

    long getDestinationDatasetExpirationTime() {
        return this.destinationDatasetExpirationTime;
    }

    String getKmsKeyName() {
        return this.kmsKeyName;
    }

    List<ConnectionProperty> getQueryProperties() {
        return this.queryProperties;
    }

    public String getLocation() {
        this.checkClosed();
        return this.location;
    }

    public Map<String, String> getAuthProperties() {
        this.checkClosed();
        return this.authProperties;
    }

    long getMaxResults() {
        return this.maxResults;
    }

    long getRetryTimeoutInSeconds() {
        return this.retryTimeoutInSeconds;
    }

    Duration getRetryTimeoutDuration() {
        return this.retryTimeoutDuration;
    }

    long getRetryInitialDelayInSeconds() {
        return this.retryInitialDelayInSeconds;
    }

    Duration getRetryInitialDelayDuration() {
        return this.retryInitialDelayDuration;
    }

    long getRetryMaxDelayInSeconds() {
        return this.retryMaxDelayInSeconds;
    }

    Duration getRetryMaxDelayDuration() {
        return this.retryMaxDelayDuration;
    }

    long getJobTimeoutInSeconds() {
        return this.jobTimeoutInSeconds;
    }

    long getMaxBytesBilled() {
        return this.maxBytesBilled;
    }

    Map<String, String> getLabels() {
        return this.labels;
    }

    private void beginTransaction() {
        this.LOG.finest("++enter++");
        QueryJobConfiguration.Builder transactionBeginJobConfig = QueryJobConfiguration.newBuilder("BEGIN TRANSACTION;");
        try {
            if (this.sessionInfoConnectionProperty != null) {
                transactionBeginJobConfig.setConnectionProperties(this.queryProperties);
            } else {
                transactionBeginJobConfig.setCreateSession(true);
            }
            Job job = this.bigQuery.create(JobInfo.of(transactionBeginJobConfig.build()), new BigQuery.JobOption[0]);
            job = job.waitFor(new RetryOption[0]);
            Job transactionBeginJob = this.bigQuery.getJob(job.getJobId(), new BigQuery.JobOption[0]);
            if (this.sessionInfoConnectionProperty == null) {
                this.sessionInfoConnectionProperty = ConnectionProperty.newBuilder().setKey("session_id").setValue(((JobStatistics)transactionBeginJob.getStatistics()).getSessionInfo().getSessionId()).build();
                this.queryProperties.add(this.sessionInfoConnectionProperty);
            }
            this.transactionStarted = true;
        }
        catch (InterruptedException ex) {
            throw new BigQueryJdbcRuntimeException(ex);
        }
    }

    public boolean isTransactionStarted() {
        return this.transactionStarted;
    }

    boolean isSessionEnabled() {
        return this.enableSession;
    }

    boolean isUnsupportedHTAPIFallback() {
        return this.unsupportedHTAPIFallback;
    }

    ConnectionProperty getSessionInfoConnectionProperty() {
        return this.sessionInfoConnectionProperty;
    }

    boolean isEnableHighThroughputAPI() {
        return this.enableHighThroughputAPI;
    }

    boolean isUseQueryCache() {
        return this.useQueryCache;
    }

    boolean getUseStatelessQueryMode() {
        return this.useStatelessQueryMode;
    }

    boolean isAllowLargeResults() {
        return this.allowLargeResults;
    }

    String getQueryDialect() {
        return this.queryDialect;
    }

    Integer getNumBufferedRows() {
        return this.numBufferedRows;
    }

    int getHighThroughputMinTableSize() {
        return this.highThroughputMinTableSize;
    }

    List<String> getAdditionalProjects() {
        return this.additionalProjects;
    }

    int getHighThroughputActivationRatio() {
        return this.highThroughputActivationRatio;
    }

    boolean isFilterTablesOnDefaultDataset() {
        return this.filterTablesOnDefaultDataset;
    }

    int isRequestGoogleDriveScope() {
        return this.requestGoogleDriveScope;
    }

    int getMetadataFetchThreadCount() {
        return this.metadataFetchThreadCount;
    }

    boolean isEnableWriteAPI() {
        return this.enableWriteAPI;
    }

    int getWriteAPIActivationRowCount() {
        return this.writeAPIActivationRowCount;
    }

    int getWriteAPIAppendRowCount() {
        return this.writeAPIAppendRowCount;
    }

    String getSSLTrustStorePath() {
        return this.sslTrustStorePath;
    }

    String getSSLTrustStorePassword() {
        return this.sslTrustStorePassword;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isValid(int timeout) throws SQLException {
        if (timeout < 0) {
            throw new BigQueryJdbcException("timeout must be >= 0");
        }
        if (this.isClosed()) return false;
        try (Statement statement = this.createStatement();
             ResultSet rs = statement.executeQuery("SELECT 1");){
            this.LOG.finest("Running validation query");
            if (!rs.next()) return false;
            if (rs.getInt(1) != 1) return false;
            boolean bl = true;
            return bl;
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        this.LOG.finest("++enter++");
        this.close();
    }

    @Override
    public void setClientInfo(String name, String value) {
    }

    @Override
    public String getClientInfo(String name) {
        return null;
    }

    @Override
    public String getCatalog() {
        return this.catalog;
    }

    @Override
    public Properties getClientInfo() {
        return null;
    }

    @Override
    public void setClientInfo(Properties properties) {
    }

    @Override
    public SQLWarning getWarnings() {
        return this.sqlWarnings.isEmpty() ? null : this.sqlWarnings.get(0);
    }

    @Override
    public void clearWarnings() {
        this.sqlWarnings.clear();
    }

    @Override
    public boolean getAutoCommit() {
        this.checkClosed();
        return this.autoCommit;
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.LOG.finest("++enter++");
        this.checkClosed();
        this.checkIfEnabledSession("setAutoCommit");
        if (this.autoCommit == autoCommit) {
            return;
        }
        if (this.isTransactionStarted()) {
            this.commitTransaction();
        }
        this.autoCommit = autoCommit;
        if (!this.autoCommit) {
            this.beginTransaction();
        }
    }

    @Override
    public void commit() {
        this.LOG.finest("++enter++");
        this.checkClosed();
        this.checkIfEnabledSession("commit");
        if (!this.isTransactionStarted()) {
            throw new IllegalStateException("Cannot commit without an active transaction. Please set setAutoCommit to false to start a transaction.");
        }
        this.commitTransaction();
        if (!this.getAutoCommit()) {
            this.beginTransaction();
        }
    }

    @Override
    public void rollback() throws SQLException {
        this.LOG.finest("++enter++");
        this.checkClosed();
        this.checkIfEnabledSession("rollback");
        if (!this.isTransactionStarted()) {
            throw new IllegalStateException("Cannot rollback without an active transaction. Please set setAutoCommit to false to start a transaction.");
        }
        try {
            QueryJobConfiguration transactionRollbackJobConfig = QueryJobConfiguration.newBuilder("ROLLBACK TRANSACTION;").setConnectionProperties(this.queryProperties).build();
            Job rollbackJob = this.bigQuery.create(JobInfo.of(transactionRollbackJobConfig), new BigQuery.JobOption[0]);
            rollbackJob.waitFor(new RetryOption[0]);
            this.transactionStarted = false;
            if (!this.getAutoCommit()) {
                this.beginTransaction();
            }
        }
        catch (BigQueryException | InterruptedException ex) {
            throw new BigQueryJdbcException(ex);
        }
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return new BigQueryDatabaseMetaData(this);
    }

    @Override
    public int getTransactionIsolation() {
        return 8;
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        if (level != 8) {
            throw new BigQueryJdbcSqlFeatureNotSupportedException("Transaction serializable not supported");
        }
        this.transactionIsolation = level;
    }

    @Override
    public int getHoldability() {
        return this.holdability;
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        if (holdability != 2) {
            throw new BigQueryJdbcSqlFeatureNotSupportedException("CLOSE_CURSORS_AT_COMMIT not supported");
        }
        this.holdability = holdability;
    }

    @Override
    public void close() throws SQLException {
        this.LOG.fine("Closing Connection " + this);
        if (this.isClosed()) {
            return;
        }
        try {
            if (this.bigQueryReadClient != null) {
                this.bigQueryReadClient.shutdown();
                this.bigQueryReadClient.awaitTermination(1L, TimeUnit.MINUTES);
                this.bigQueryReadClient.close();
            }
            if (this.bigQueryWriteClient != null) {
                this.bigQueryWriteClient.shutdown();
                this.bigQueryWriteClient.awaitTermination(1L, TimeUnit.MINUTES);
                this.bigQueryWriteClient.close();
            }
            for (Statement statement : this.openStatements) {
                statement.close();
            }
            this.openStatements.clear();
        }
        catch (ConcurrentModificationException ex) {
            throw new BigQueryJdbcException(ex);
        }
        catch (InterruptedException e) {
            throw new BigQueryJdbcRuntimeException(e);
        }
        this.isClosed = true;
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    private void checkClosed() {
        if (this.isClosed()) {
            throw new IllegalStateException("This " + this.getClass().getName() + " has been closed");
        }
    }

    private void checkIfEnabledSession(String methodName) {
        if (!this.enableSession) {
            throw new IllegalStateException(String.format("Session needs to be enabled to use %s method.", methodName));
        }
    }

    private ConnectionProperty getSessionPropertyFromQueryProperties(Map<String, String> queryPropertiesMap) {
        this.LOG.finest("++enter++");
        if (queryPropertiesMap != null && queryPropertiesMap.containsKey("session_id")) {
            return ConnectionProperty.newBuilder().setKey("session_id").setValue(queryPropertiesMap.get("session_id")).build();
        }
        return null;
    }

    private List<ConnectionProperty> convertMapToConnectionPropertiesList(Map<String, String> queryPropertiesMap) {
        this.LOG.finest("++enter++");
        ArrayList<ConnectionProperty> connectionProperties = new ArrayList<ConnectionProperty>();
        if (queryPropertiesMap != null) {
            for (Map.Entry<String, String> entry : queryPropertiesMap.entrySet()) {
                connectionProperties.add(ConnectionProperty.newBuilder().setKey(entry.getKey()).setValue(entry.getValue()).build());
            }
        }
        return connectionProperties;
    }

    void removeStatement(Statement statement) {
        this.openStatements.remove(statement);
    }

    private BigQuery getBigQueryConnection() {
        BigQueryOptions.Builder bigQueryOptions = BigQueryOptions.newBuilder();
        if (this.retryTimeoutInSeconds > 0L || this.retryInitialDelayInSeconds > 0L && this.retryMaxDelayInSeconds > 0L) {
            RetrySettings.Builder retry_settings_builder = RetrySettings.newBuilder();
            if (this.retryTimeoutInSeconds > 0L) {
                retry_settings_builder.setTotalTimeoutDuration(this.retryTimeoutDuration);
            }
            if (this.retryInitialDelayInSeconds > 0L && this.retryMaxDelayInSeconds > 0L) {
                retry_settings_builder.setInitialRetryDelayDuration(this.retryInitialDelayDuration);
                retry_settings_builder.setMaxRetryDelayDuration(this.retryMaxDelayDuration);
            }
            bigQueryOptions.setRetrySettings(retry_settings_builder.build());
        }
        if (this.catalog != null) {
            bigQueryOptions.setProjectId(this.catalog);
        }
        if (this.credentials != null) {
            bigQueryOptions.setCredentials(this.credentials);
        }
        if (this.location != null) {
            bigQueryOptions.setLocation(this.location);
        }
        if (this.overrideProperties.containsKey("BIGQUERY")) {
            bigQueryOptions.setHost(this.overrideProperties.get("BIGQUERY"));
        }
        if (this.universeDomain != null) {
            bigQueryOptions.setUniverseDomain(this.universeDomain);
        }
        if (this.httpTransportOptions != null) {
            bigQueryOptions.setTransportOptions(this.httpTransportOptions);
        }
        BigQueryOptions options = ((BigQueryOptions.Builder)bigQueryOptions.setHeaderProvider(HEADER_PROVIDER)).build();
        options.setQueryPreviewEnabled(String.valueOf(this.useStatelessQueryMode));
        return (BigQuery)options.getService();
    }

    private BigQueryReadClient getBigQueryReadClientConnection() throws IOException {
        BigQueryReadSettings.Builder bigQueryReadSettings = (BigQueryReadSettings.Builder)BigQueryReadSettings.newBuilder().setHeaderProvider(HEADER_PROVIDER);
        if (this.getRetrySettings() != null) {
            bigQueryReadSettings.createReadSessionSettings().setRetrySettings(this.getRetrySettings());
        }
        if (this.catalog != null) {
            bigQueryReadSettings.setQuotaProjectId(this.catalog);
        }
        if (this.credentials != null) {
            FixedCredentialsProvider fixedProvider = FixedCredentialsProvider.create(this.credentials);
            bigQueryReadSettings.setCredentialsProvider(fixedProvider);
        }
        if (this.overrideProperties.containsKey("READ_API")) {
            bigQueryReadSettings.setEndpoint(this.overrideProperties.get("READ_API"));
        }
        if (this.universeDomain != null) {
            bigQueryReadSettings.setUniverseDomain(this.universeDomain);
        }
        if (this.transportChannelProvider != null) {
            bigQueryReadSettings.setTransportChannelProvider(this.transportChannelProvider);
        }
        return BigQueryReadClient.create(bigQueryReadSettings.build());
    }

    private BigQueryWriteClient getBigQueryWriteClientConnection() throws IOException {
        BigQueryWriteSettings.Builder bigQueryWriteSettings = (BigQueryWriteSettings.Builder)BigQueryWriteSettings.newBuilder().setHeaderProvider(HEADER_PROVIDER);
        if (this.getRetrySettings() != null) {
            bigQueryWriteSettings.createWriteStreamSettings().setRetrySettings(this.getRetrySettings());
        }
        if (this.catalog != null) {
            bigQueryWriteSettings.setQuotaProjectId(this.catalog);
        }
        if (this.credentials != null) {
            FixedCredentialsProvider fixedProvider = FixedCredentialsProvider.create(this.credentials);
            bigQueryWriteSettings.setCredentialsProvider(fixedProvider);
        }
        if (this.overrideProperties.containsKey("READ_API")) {
            bigQueryWriteSettings.setEndpoint(this.overrideProperties.get("READ_API"));
        }
        if (this.universeDomain != null) {
            bigQueryWriteSettings.setUniverseDomain(this.universeDomain);
        }
        if (this.transportChannelProvider != null) {
            bigQueryWriteSettings.setTransportChannelProvider(this.transportChannelProvider);
        }
        return BigQueryWriteClient.create(bigQueryWriteSettings.build());
    }

    RetrySettings getRetrySettings() {
        RetrySettings.Builder retrySettingsBuilder = null;
        if (this.retryTimeoutInSeconds > 0L || this.retryInitialDelayInSeconds > 0L && this.retryMaxDelayInSeconds > 0L) {
            retrySettingsBuilder = RetrySettings.newBuilder();
            if (this.retryTimeoutInSeconds > 0L) {
                retrySettingsBuilder.setTotalTimeoutDuration(this.retryTimeoutDuration);
            }
            if (this.retryInitialDelayInSeconds > 0L && this.retryMaxDelayInSeconds > 0L) {
                retrySettingsBuilder.setInitialRetryDelayDuration(this.retryInitialDelayDuration);
                retrySettingsBuilder.setMaxRetryDelayDuration(this.retryMaxDelayDuration);
            }
        }
        return retrySettingsBuilder == null ? null : retrySettingsBuilder.build();
    }

    private void commitTransaction() {
        try {
            QueryJobConfiguration transactionCommitJobConfig = QueryJobConfiguration.newBuilder("COMMIT TRANSACTION;").setConnectionProperties(this.queryProperties).build();
            Job commitJob = this.bigQuery.create(JobInfo.of(transactionCommitJobConfig), new BigQuery.JobOption[0]);
            commitJob.waitFor(new RetryOption[0]);
            this.transactionStarted = false;
        }
        catch (InterruptedException ex) {
            throw new BigQueryJdbcRuntimeException(ex);
        }
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        this.checkClosed();
        BigQueryCallableStatement currentStatement = new BigQueryCallableStatement(this, sql);
        this.LOG.fine(String.format("Callable Statement %s created.", currentStatement));
        this.addOpenStatements(currentStatement);
        return currentStatement;
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.LOG.finest("++enter++");
        this.checkClosed();
        if (resultSetType != 1003 || resultSetConcurrency != 1007) {
            throw new BigQueryJdbcSqlFeatureNotSupportedException("Unsupported CallableStatement feature");
        }
        return this.prepareCall(sql);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.LOG.finest("++enter++");
        this.checkClosed();
        if (resultSetType != 1003 || resultSetConcurrency != 1007 || resultSetHoldability != 2) {
            throw new BigQueryJdbcSqlFeatureNotSupportedException("Unsupported CallableStatement feature");
        }
        return this.prepareCall(sql);
    }
}

