/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.jdbc;

import com.google.api.client.util.PemReader;
import com.google.api.client.util.SecurityUtils;
import com.google.auth.oauth2.AccessToken;
import com.google.auth.oauth2.ClientId;
import com.google.auth.oauth2.ExternalAccountCredentials;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.auth.oauth2.ImpersonatedCredentials;
import com.google.auth.oauth2.ServiceAccountCredentials;
import com.google.auth.oauth2.UserAuthorizer;
import com.google.auth.oauth2.UserCredentials;
import com.google.cloud.bigquery.exception.BigQueryJdbcRuntimeException;
import com.google.cloud.bigquery.jdbc.BigQueryJdbcCustomLogger;
import com.google.cloud.bigquery.jdbc.BigQueryJdbcUrlUtility;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.Strictness;
import com.google.gson.stream.JsonReader;
import java.awt.Desktop;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class BigQueryJdbcOAuthUtility {
    private static final String USER_AUTH_SUCCESS_HTTP_RESPONSE = "HTTP/1.1 200 OK\nContent-Length: 300\nConnection: close\nContent-Type: text/html; charset=utf-8\n\n<!DOCTYPE html><html><body>\nThank you for using JDBC Driver for Google BigQuery!\nYou may now close the window.</body></html>";
    private static final int USER_AUTH_TIMEOUT_MS = 120000;
    private static final BigQueryJdbcCustomLogger LOG = new BigQueryJdbcCustomLogger(BigQueryJdbcOAuthUtility.class.getName());
    private static final Map<String, String> BYOID_NAME_MAP = new HashMap<String, String>(){
        {
            this.put("BYOID_AudienceUri", "audience");
            this.put("BYOID_CredentialSource", "credential_source");
            this.put("BYOID_SubjectTokenType", "subject_token_type");
            this.put("BYOID_TokenUri", "token_url");
            this.put("BYOID_PoolUserProject", "workforce_pool_user_project");
            this.put("BYOID_SA_Impersonation_Uri", "service_account_impersonation_url");
        }
    };

    BigQueryJdbcOAuthUtility() {
    }

    static Map<String, String> parseOAuthProperties(String url, String callerClassName) {
        AuthType authType;
        LOG.finest("++enter++\t" + callerClassName);
        HashMap<String, String> oauthProperties = new HashMap<String, String>();
        try {
            authType = AuthType.fromValue(BigQueryJdbcUrlUtility.parseIntProperty(url, "OAuthType", -1, callerClassName));
        }
        catch (NumberFormatException exception) {
            throw new IllegalArgumentException("Invalid Auth type specified");
        }
        oauthProperties.put("OAuthType", String.valueOf((Object)authType));
        switch (authType) {
            case GOOGLE_SERVICE_ACCOUNT: {
                String serviceAccountEmail = BigQueryJdbcUrlUtility.parseUriProperty(url, "OAuthServiceAcctEmail");
                String serviceAccountPK = BigQueryJdbcUrlUtility.parseUriProperty(url, "OAuthPvtKey");
                String serviceAccountPrivateKeyPath = BigQueryJdbcUrlUtility.parseUriProperty(url, "OAuthPvtKeyPath");
                String p12Password = BigQueryJdbcUrlUtility.parseStringProperty(url, "OAuthP12Password", "notasecret", callerClassName);
                oauthProperties.put("OAuthServiceAcctEmail", serviceAccountEmail);
                oauthProperties.put("OAuthP12Password", p12Password);
                if (serviceAccountEmail != null && serviceAccountPK != null) {
                    oauthProperties.put("OAuthPvtKey", serviceAccountPK);
                    break;
                }
                oauthProperties.put("OAuthPvtKeyPath", serviceAccountPrivateKeyPath);
                break;
            }
            case GOOGLE_USER_ACCOUNT: {
                oauthProperties.put("OAuthClientId", BigQueryJdbcUrlUtility.parseUriProperty(url, "OAuthClientId"));
                oauthProperties.put("OAuthClientSecret", BigQueryJdbcUrlUtility.parseUriProperty(url, "OAuthClientSecret"));
                int reqGoogleDriveScope = BigQueryJdbcUrlUtility.parseIntProperty(url, "RequestGoogleDriveScope", 0, callerClassName);
                oauthProperties.put("RequestGoogleDriveScope", String.valueOf(reqGoogleDriveScope));
                LOG.fine("RequestGoogleDriveScope parsed.");
                break;
            }
            case PRE_GENERATED_TOKEN: {
                String refreshToken = BigQueryJdbcUrlUtility.parseUriProperty(url, "OAuthRefreshToken");
                if (refreshToken != null) {
                    oauthProperties.put("OAuthRefreshToken", refreshToken);
                    LOG.fine("OAuthRefreshToken provided.");
                    oauthProperties.put("OAuthClientId", BigQueryJdbcUrlUtility.parseUriProperty(url, "OAuthClientId"));
                    LOG.fine("OAuthClientId provided.");
                    oauthProperties.put("OAuthClientSecret", BigQueryJdbcUrlUtility.parseUriProperty(url, "OAuthClientSecret"));
                    LOG.fine("OAuthClientSecret provided.");
                    break;
                }
                oauthProperties.put("OAuthAccessToken", BigQueryJdbcUrlUtility.parseUriProperty(url, "OAuthAccessToken"));
                LOG.fine("OAuthAccessToken provided.");
                break;
            }
            case APPLICATION_DEFAULT_CREDENTIALS: {
                break;
            }
            case EXTERNAL_ACCOUNT_AUTH: {
                String pvtKey = BigQueryJdbcUrlUtility.parseUriProperty(url, "OAuthPvtKey");
                String pvtKeyPath = BigQueryJdbcUrlUtility.parseUriProperty(url, "OAuthPvtKeyPath");
                if (pvtKey != null) {
                    oauthProperties.put("OAuthPvtKey", BigQueryJdbcUrlUtility.parseUriProperty(url, "OAuthPvtKey"));
                    LOG.fine("OAuthPvtKey provided.");
                    break;
                }
                if (pvtKeyPath != null) {
                    oauthProperties.put("OAuthPvtKeyPath", BigQueryJdbcUrlUtility.parseUriProperty(url, "OAuthPvtKeyPath"));
                    LOG.fine("OAuthPvtKeyPath provided.");
                    break;
                }
                for (String property : BigQueryJdbcUrlUtility.BYOID_PROPERTIES) {
                    String value = BigQueryJdbcUrlUtility.parseBYOIDProperty(url, property, callerClassName);
                    if (value == null) continue;
                    oauthProperties.put(property, value);
                    LOG.fine(property + " provided.");
                }
                String universeDomainProp = "universeDomain";
                String universeDomain = BigQueryJdbcUrlUtility.parseUriProperty(url, universeDomainProp);
                if (universeDomain == null) break;
                oauthProperties.put(universeDomainProp, universeDomain);
                LOG.fine(universeDomainProp + " provided. Caller : " + callerClassName);
            }
        }
        if (authType == AuthType.GOOGLE_SERVICE_ACCOUNT || authType == AuthType.GOOGLE_USER_ACCOUNT || authType == AuthType.PRE_GENERATED_TOKEN) {
            oauthProperties.put("ServiceAccountImpersonationEmail", BigQueryJdbcUrlUtility.parseStringProperty(url, "ServiceAccountImpersonationEmail", BigQueryJdbcUrlUtility.DEFAULT_OAUTH_SA_IMPERSONATION_EMAIL_VALUE, callerClassName));
            oauthProperties.put("ServiceAccountImpersonationChain", BigQueryJdbcUrlUtility.parseStringProperty(url, "ServiceAccountImpersonationChain", BigQueryJdbcUrlUtility.DEFAULT_OAUTH_SA_IMPERSONATION_CHAIN_VALUE, callerClassName));
            oauthProperties.put("ServiceAccountImpersonationScopes", BigQueryJdbcUrlUtility.parseStringProperty(url, "ServiceAccountImpersonationScopes", "https://www.googleapis.com/auth/bigquery", callerClassName));
            oauthProperties.put("ServiceAccountImpersonationTokenLifetime", BigQueryJdbcUrlUtility.parseStringProperty(url, "ServiceAccountImpersonationTokenLifetime", "3600", callerClassName));
        }
        return oauthProperties;
    }

    static GoogleCredentials getCredentials(Map<String, String> authProperties, Map<String, String> overrideProperties, String callerClassName) {
        GoogleCredentials credentials;
        LOG.finest("++enter++\t" + callerClassName);
        AuthType authType = AuthType.valueOf(authProperties.get("OAuthType"));
        switch (authType) {
            case GOOGLE_SERVICE_ACCOUNT: {
                credentials = BigQueryJdbcOAuthUtility.getGoogleServiceAccountCredentials(authProperties, overrideProperties, callerClassName);
                break;
            }
            case GOOGLE_USER_ACCOUNT: {
                credentials = BigQueryJdbcOAuthUtility.getGoogleUserAccountCredentials(authProperties, overrideProperties, callerClassName);
                break;
            }
            case PRE_GENERATED_TOKEN: {
                credentials = BigQueryJdbcOAuthUtility.getPreGeneratedTokensCredentials(authProperties, overrideProperties, callerClassName);
                break;
            }
            case APPLICATION_DEFAULT_CREDENTIALS: {
                return BigQueryJdbcOAuthUtility.getApplicationDefaultCredentials(callerClassName);
            }
            case EXTERNAL_ACCOUNT_AUTH: {
                return BigQueryJdbcOAuthUtility.getExternalAccountAuthCredentials(authProperties, callerClassName);
            }
            default: {
                throw new IllegalStateException("Invalid Auth type specified");
            }
        }
        return BigQueryJdbcOAuthUtility.getServiceAccountImpersonatedCredentials(credentials, authProperties);
    }

    private static boolean isFileExists(String filename) {
        try {
            return filename != null && !filename.isEmpty() && Files.exists(Paths.get(filename, new String[0]), new LinkOption[0]);
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean isJson(String value) {
        try {
            ByteArrayInputStream stream = new ByteArrayInputStream(value.getBytes());
            InputStreamReader reader = new InputStreamReader(stream);
            JsonReader jsonReader = new JsonReader(reader);
            jsonReader.setStrictness(Strictness.STRICT);
            JsonElement json = JsonParser.parseReader(jsonReader);
            return json != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static GoogleCredentials getGoogleServiceAccountCredentials(Map<String, String> authProperties, Map<String, String> overrideProperties, String callerClassName) {
        ServiceAccountCredentials.Builder builder;
        LOG.finest("++enter++\t" + callerClassName);
        try {
            String pvtKeyPath = authProperties.get("OAuthPvtKeyPath");
            String pvtKey = authProperties.get("OAuthPvtKey");
            String pvtEmail = authProperties.get("OAuthServiceAcctEmail");
            String p12Password = authProperties.get("OAuthP12Password");
            String keyPath = pvtKeyPath != null ? pvtKeyPath : pvtKey;
            PrivateKey key = null;
            InputStream stream = null;
            if (BigQueryJdbcOAuthUtility.isFileExists(keyPath)) {
                key = BigQueryJdbcOAuthUtility.privateKeyFromP12File(keyPath, p12Password);
                if (key == null) {
                    stream = Files.newInputStream(Paths.get(keyPath, new String[0]), new OpenOption[0]);
                }
            } else if (BigQueryJdbcOAuthUtility.isJson(pvtKey)) {
                stream = new ByteArrayInputStream(pvtKey.getBytes());
            } else if (pvtKey != null) {
                key = BigQueryJdbcOAuthUtility.privateKeyFromPkcs8(pvtKey);
            }
            if (stream != null) {
                builder = ServiceAccountCredentials.fromStream(stream).toBuilder();
            } else if (pvtEmail != null && key != null) {
                builder = ServiceAccountCredentials.newBuilder().setClientEmail(pvtEmail).setPrivateKey(key);
            } else {
                LOG.severe("No valid Service Account credentials provided.");
                throw new BigQueryJdbcRuntimeException("No valid credentials provided.");
            }
            if (overrideProperties.containsKey("OAUTH2")) {
                builder.setTokenServerUri(new URI(overrideProperties.get("OAUTH2")));
            }
            if (overrideProperties.containsKey("universeDomain")) {
                builder.setUniverseDomain(overrideProperties.get("universeDomain"));
            }
        }
        catch (IOException | URISyntaxException e) {
            LOG.severe("Validation failure for Service Account credentials.");
            throw new BigQueryJdbcRuntimeException(e);
        }
        LOG.info("GoogleCredentials instantiated. Auth Method: Service Account.");
        return builder.build();
    }

    static UserAuthorizer getUserAuthorizer(Map<String, String> authProperties, Map<String, String> overrideProperties, int port, String callerClassName) throws URISyntaxException {
        LOG.finest("++enter++\t" + callerClassName);
        ArrayList<String> scopes = new ArrayList<String>();
        scopes.add("https://www.googleapis.com/auth/bigquery");
        if (authProperties.containsKey("RequestGoogleDriveScope")) {
            try {
                int driveScopeValue = Integer.parseInt(authProperties.get("RequestGoogleDriveScope"));
                if (driveScopeValue == 1) {
                    scopes.add("https://www.googleapis.com/auth/drive.readonly");
                    LOG.fine("Added Google Drive read-only scope. Caller: " + callerClassName);
                }
            }
            catch (NumberFormatException e) {
                LOG.severe("Invalid value for RequestGoogleDriveScope, defaulting to not request Drive scope. Caller: " + callerClassName);
            }
        }
        ArrayList<String> responseTypes = new ArrayList<String>();
        responseTypes.add("code");
        ClientId clientId = ClientId.of(authProperties.get("OAuthClientId"), authProperties.get("OAuthClientSecret"));
        UserAuthorizer.Builder userAuthorizerBuilder = UserAuthorizer.newBuilder().setClientId(clientId).setScopes(scopes).setCallbackUri(URI.create("http://localhost:" + port));
        if (overrideProperties.containsKey("OAUTH2")) {
            userAuthorizerBuilder.setTokenServerUri(new URI(overrideProperties.get("OAUTH2")));
        }
        return userAuthorizerBuilder.build();
    }

    static UserCredentials getCredentialsFromCode(UserAuthorizer userAuthorizer, String code, String callerClassName) throws IOException {
        LOG.finest("++enter++\t" + callerClassName);
        return userAuthorizer.getCredentialsFromCode(code, URI.create(""));
    }

    private static GoogleCredentials getGoogleUserAccountCredentials(Map<String, String> authProperties, Map<String, String> overrideProperties, String callerClassName) {
        LOG.finest("++enter++\t" + callerClassName);
        try {
            Matcher m4;
            PrintWriter printWriter;
            Socket socket;
            ServerSocket serverSocket = new ServerSocket(0);
            serverSocket.setSoTimeout(120000);
            int port = serverSocket.getLocalPort();
            UserAuthorizer userAuthorizer = BigQueryJdbcOAuthUtility.getUserAuthorizer(authProperties, overrideProperties, port, callerClassName);
            URL authURL = userAuthorizer.getAuthorizationUrl("user", "", URI.create(""));
            if (Desktop.isDesktopSupported()) {
                Desktop.getDesktop().browse(authURL.toURI());
                socket = serverSocket.accept();
                OutputStream outputStream = socket.getOutputStream();
                printWriter = new PrintWriter(outputStream);
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                String response = bufferedReader.readLine();
                Pattern p = Pattern.compile("(?<=code=).*?(?=&|$)");
                m4 = p.matcher(response);
                if (!m4.find()) {
                    throw new BigQueryJdbcRuntimeException("Could not retrieve the code for user auth");
                }
            } else {
                throw new BigQueryJdbcRuntimeException("User auth only supported in desktop environments");
            }
            String code = m4.group();
            printWriter.println(USER_AUTH_SUCCESS_HTTP_RESPONSE);
            printWriter.flush();
            socket.close();
            serverSocket.close();
            return BigQueryJdbcOAuthUtility.getCredentialsFromCode(userAuthorizer, code, callerClassName);
        }
        catch (IOException | URISyntaxException ex) {
            LOG.severe(String.format("Failed to establish connection using User Account authentication: %s", ex.getMessage()));
            throw new BigQueryJdbcRuntimeException(ex);
        }
    }

    private static GoogleCredentials getPreGeneratedAccessTokenCredentials(Map<String, String> authProperties, Map<String, String> overrideProperties, String callerClassName) {
        LOG.finest("++enter++\t" + callerClassName);
        GoogleCredentials.Builder builder = GoogleCredentials.newBuilder();
        if (overrideProperties.containsKey("universeDomain")) {
            builder.setUniverseDomain(overrideProperties.get("universeDomain"));
        }
        LOG.info("Connection established. Auth Method: Pre-generated Access Token.");
        return builder.setAccessToken(AccessToken.newBuilder().setTokenValue(authProperties.get("OAuthAccessToken")).build()).build();
    }

    static GoogleCredentials getPreGeneratedTokensCredentials(Map<String, String> authProperties, Map<String, String> overrideProperties, String callerClassName) {
        LOG.finest("++enter++\t" + callerClassName);
        if (authProperties.containsKey("OAuthRefreshToken")) {
            try {
                return BigQueryJdbcOAuthUtility.getPreGeneratedRefreshTokenCredentials(authProperties, overrideProperties, callerClassName);
            }
            catch (URISyntaxException ex) {
                throw new BigQueryJdbcRuntimeException(ex);
            }
        }
        return BigQueryJdbcOAuthUtility.getPreGeneratedAccessTokenCredentials(authProperties, overrideProperties, callerClassName);
    }

    static UserCredentials getPreGeneratedRefreshTokenCredentials(Map<String, String> authProperties, Map<String, String> overrideProperties, String callerClassName) throws URISyntaxException {
        LOG.finest("++enter++\t" + callerClassName);
        UserCredentials.Builder userCredentialsBuilder = UserCredentials.newBuilder().setRefreshToken(authProperties.get("OAuthRefreshToken")).setClientId(authProperties.get("OAuthClientId")).setClientSecret(authProperties.get("OAuthClientSecret"));
        if (overrideProperties.containsKey("OAUTH2")) {
            userCredentialsBuilder.setTokenServerUri(new URI(overrideProperties.get("OAUTH2")));
        }
        if (overrideProperties.containsKey("universeDomain")) {
            userCredentialsBuilder.setUniverseDomain(overrideProperties.get("universeDomain"));
        }
        LOG.info("Connection established. Auth Method: Pre-generated Refresh Token.");
        return userCredentialsBuilder.build();
    }

    private static GoogleCredentials getApplicationDefaultCredentials(String callerClassName) {
        LOG.finest("++enter++\t" + callerClassName);
        try {
            GoogleCredentials credentials = GoogleCredentials.getApplicationDefault();
            String principal = "unknown";
            if (credentials instanceof ServiceAccountCredentials) {
                principal = ((ServiceAccountCredentials)credentials).getClientEmail();
            } else if (credentials instanceof UserCredentials) {
                principal = "user credentials";
            } else if (credentials instanceof ExternalAccountCredentials) {
                principal = "external account";
            }
            LOG.info(String.format("Connection established. Auth Method: Application Default Credentials, Principal: %s.", principal));
            return credentials;
        }
        catch (IOException exception) {
            throw new BigQueryJdbcRuntimeException("Application default credentials not found.");
        }
    }

    private static GoogleCredentials getExternalAccountAuthCredentials(Map<String, String> authProperties, String callerClassName) {
        LOG.finest("++enter++\t" + callerClassName);
        try {
            JsonObject jsonObject = null;
            String credentialsPath = null;
            if (authProperties.containsKey("OAuthPvtKey")) {
                String pvtKeyPath = authProperties.get("OAuthPvtKey").trim();
                if (pvtKeyPath.startsWith("{")) {
                    jsonObject = JsonParser.parseString(pvtKeyPath).getAsJsonObject();
                } else {
                    credentialsPath = pvtKeyPath;
                }
            } else if (authProperties.containsKey("OAuthPvtKeyPath")) {
                credentialsPath = authProperties.get("OAuthPvtKeyPath");
            } else {
                jsonObject = new JsonObject();
                for (String property : BigQueryJdbcUrlUtility.BYOID_PROPERTIES) {
                    if (Objects.equals(property, "BYOID_CredentialSource")) {
                        jsonObject.add(BYOID_NAME_MAP.get(property), JsonParser.parseString(authProperties.get(property)).getAsJsonObject());
                        continue;
                    }
                    if (!authProperties.containsKey(property)) continue;
                    jsonObject.addProperty(BYOID_NAME_MAP.get(property), authProperties.get(property));
                }
                if (authProperties.containsKey("universeDomain")) {
                    jsonObject.addProperty("universe_domain", authProperties.get("universeDomain"));
                }
            }
            if (credentialsPath != null) {
                return ExternalAccountCredentials.fromStream(Files.newInputStream(Paths.get(credentialsPath, new String[0]), new OpenOption[0]));
            }
            if (jsonObject != null) {
                return ExternalAccountCredentials.fromStream(new ByteArrayInputStream(jsonObject.toString().getBytes()));
            }
            throw new IllegalArgumentException("Insufficient info provided for external authentication");
        }
        catch (IOException e) {
            throw new BigQueryJdbcRuntimeException(e);
        }
    }

    private static GoogleCredentials getServiceAccountImpersonatedCredentials(GoogleCredentials credentials, Map<String, String> authProperties) {
        String impersonationEmail = authProperties.get("ServiceAccountImpersonationEmail");
        if (impersonationEmail == null || impersonationEmail.isEmpty()) {
            return credentials;
        }
        String impersonationChainString = authProperties.get("ServiceAccountImpersonationChain");
        List<String> impersonationChain = null;
        if (impersonationChainString != null && !impersonationChainString.isEmpty()) {
            impersonationChain = Arrays.asList(impersonationChainString.split(","));
        }
        List<String> impersonationScopes = Arrays.asList(authProperties.get("ServiceAccountImpersonationScopes").split(","));
        String impersonationLifetime = authProperties.get("ServiceAccountImpersonationTokenLifetime");
        int impersonationLifetimeInt = 0;
        try {
            impersonationLifetimeInt = Integer.parseInt(impersonationLifetime);
        }
        catch (NumberFormatException e) {
            LOG.severe("Invalid value for ServiceAccountImpersonationTokenLifetime.");
            throw new IllegalArgumentException("Invalid value for ServiceAccountImpersonationTokenLifetime: must be a positive integer.", e);
        }
        return ImpersonatedCredentials.create(credentials, impersonationEmail, impersonationChain, impersonationScopes, impersonationLifetimeInt);
    }

    static PrivateKey privateKeyFromP12File(String privateKeyFile, String password) {
        try {
            InputStream stream = Files.newInputStream(Paths.get(privateKeyFile, new String[0]), new OpenOption[0]);
            return SecurityUtils.loadPrivateKeyFromKeyStore(SecurityUtils.getPkcs12KeyStore(), stream, "notasecret", "privatekey", password);
        }
        catch (IOException | GeneralSecurityException e) {
            LOG.warning("Unable to parse p12 file: " + e.getMessage());
            return null;
        }
    }

    static PrivateKey privateKeyFromPkcs8(String privateKeyPkcs8) {
        try {
            StringReader reader = new StringReader(privateKeyPkcs8);
            PemReader.Section section = PemReader.readFirstSectionAndClose(reader, "PRIVATE KEY");
            if (section == null) {
                throw new IOException("Invalid PKCS#8 data.");
            }
            byte[] bytes = section.getBase64DecodedBytes();
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(bytes);
            KeyFactory keyFactory = SecurityUtils.getRsaKeyFactory();
            return keyFactory.generatePrivate(keySpec);
        }
        catch (IOException | NoSuchAlgorithmException | InvalidKeySpecException e) {
            LOG.warning("Unable to parse pkcs8 secret: " + e.getMessage());
            return null;
        }
    }

    static enum AuthType {
        GOOGLE_SERVICE_ACCOUNT(0),
        GOOGLE_USER_ACCOUNT(1),
        PRE_GENERATED_TOKEN(2),
        APPLICATION_DEFAULT_CREDENTIALS(3),
        EXTERNAL_ACCOUNT_AUTH(4);

        private final int value;

        private AuthType(int value) {
            this.value = value;
        }

        static AuthType fromValue(int value) {
            for (AuthType authType : AuthType.values()) {
                if (authType.value != value) continue;
                return authType;
            }
            throw new IllegalStateException("Invalid Auth type specified: " + value);
        }
    }
}

