/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.jdbc;

import com.google.api.client.http.apache.v5.Apache5HttpTransport;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.auth.http.HttpTransportFactory;
import com.google.cloud.bigquery.exception.BigQueryJdbcRuntimeException;
import com.google.cloud.bigquery.jdbc.BigQueryJdbcCustomLogger;
import com.google.cloud.bigquery.jdbc.BigQueryJdbcUrlUtility;
import com.google.cloud.bigquery.storage.v1.stub.BigQueryReadStubSettings;
import com.google.cloud.http.HttpTransportOptions;
import io.grpc.HttpConnectProxiedSocketAddress;
import io.grpc.ProxiedSocketAddress;
import io.grpc.ProxyDetector;
import io.grpc.netty.shaded.io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.shaded.io.grpc.netty.NettyChannelBuilder;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContext;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.impl.DefaultAuthenticationStrategy;
import org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.impl.routing.DefaultProxyRoutePlanner;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactory;
import org.apache.hc.core5.http.HttpHost;

final class BigQueryJdbcProxyUtility {
    private static final BigQueryJdbcCustomLogger LOG = new BigQueryJdbcCustomLogger(BigQueryJdbcProxyUtility.class.getName());
    static final String validPortRegex = "^([1-9][0-9]{0,3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])$";

    private BigQueryJdbcProxyUtility() {
    }

    static Map<String, String> parseProxyProperties(String URL2, String callerClassName) {
        boolean isProxyAuthSetWithoutProxySettings;
        boolean isMissingProxyUidOrPwdWhenAuthSet;
        boolean isMissingProxyHostOrPortWhenProxySet;
        String proxyPwd;
        String proxyUid;
        String proxyPort;
        LOG.finest("++enter++\t" + callerClassName);
        HashMap<String, String> proxyProperties = new HashMap<String, String>();
        String proxyHost = BigQueryJdbcUrlUtility.parseUriProperty(URL2, "ProxyHost");
        if (proxyHost != null) {
            proxyProperties.put("ProxyHost", proxyHost);
        }
        if ((proxyPort = BigQueryJdbcUrlUtility.parseUriProperty(URL2, "ProxyPort")) != null) {
            if (!Pattern.compile(validPortRegex).matcher(proxyPort).find()) {
                throw new IllegalArgumentException("Illegal port number provided %s. Please provide a valid port number.");
            }
            proxyProperties.put("ProxyPort", proxyPort);
        }
        if ((proxyUid = BigQueryJdbcUrlUtility.parseUriProperty(URL2, "ProxyUid")) != null) {
            proxyProperties.put("ProxyUid", proxyUid);
        }
        if ((proxyPwd = BigQueryJdbcUrlUtility.parseUriProperty(URL2, "ProxyPwd")) != null) {
            proxyProperties.put("ProxyPwd", proxyPwd);
        }
        boolean bl = isMissingProxyHostOrPortWhenProxySet = proxyHost == null && proxyPort != null || proxyHost != null && proxyPort == null;
        if (isMissingProxyHostOrPortWhenProxySet) {
            throw new IllegalArgumentException("Both ProxyHost and ProxyPort parameters need to be specified. No defaulting behavior occurs.");
        }
        boolean bl2 = isMissingProxyUidOrPwdWhenAuthSet = proxyUid == null && proxyPwd != null || proxyUid != null && proxyPwd == null;
        if (isMissingProxyUidOrPwdWhenAuthSet) {
            throw new IllegalArgumentException("Both ProxyUid and ProxyPwd parameters need to be specified for authentication.");
        }
        boolean bl3 = isProxyAuthSetWithoutProxySettings = proxyUid != null && proxyHost == null;
        if (isProxyAuthSetWithoutProxySettings) {
            throw new IllegalArgumentException("Proxy authentication provided via connection string with no proxy host or port set.");
        }
        return proxyProperties;
    }

    static HttpTransportOptions getHttpTransportOptions(Map<String, String> proxyProperties, String sslTrustStorePath, String sslTrustStorePassword, String callerClassName) {
        LOG.finest("++enter++\t" + callerClassName);
        if (!proxyProperties.containsKey("ProxyHost") && sslTrustStorePath == null) {
            return null;
        }
        return HttpTransportOptions.newBuilder().setHttpTransportFactory(BigQueryJdbcProxyUtility.getHttpTransportFactory(proxyProperties, sslTrustStorePath, sslTrustStorePassword, callerClassName)).build();
    }

    private static HttpTransportFactory getHttpTransportFactory(Map<String, String> proxyProperties, String sslTrustStorePath, String sslTrustStorePassword, String callerClassName) {
        LOG.finest("++enter++\t" + callerClassName);
        HttpClientBuilder httpClientBuilder = HttpClients.custom();
        boolean explicitProxySet = proxyProperties.containsKey("ProxyHost");
        if (explicitProxySet) {
            HttpHost proxyHostDetails = new HttpHost(proxyProperties.get("ProxyHost"), Integer.parseInt(proxyProperties.get("ProxyPort")));
            DefaultProxyRoutePlanner httpRoutePlanner = new DefaultProxyRoutePlanner(proxyHostDetails);
            httpClientBuilder.setRoutePlanner(httpRoutePlanner);
            BigQueryJdbcProxyUtility.addAuthToProxyIfPresent(proxyProperties, httpClientBuilder, callerClassName);
        } else {
            httpClientBuilder.useSystemProperties();
        }
        if (sslTrustStorePath != null) {
            try (FileInputStream trustStoreStream = new FileInputStream(sslTrustStorePath);){
                KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
                char[] trustStorePasswordChars = sslTrustStorePassword != null ? sslTrustStorePassword.toCharArray() : null;
                trustStore.load(trustStoreStream, trustStorePasswordChars);
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                trustManagerFactory.init(trustStore);
                SSLContext sslContext = SSLContext.getInstance("TLS");
                sslContext.init(null, trustManagerFactory.getTrustManagers(), null);
                SSLConnectionSocketFactory sslSocketFactory = new SSLConnectionSocketFactory(sslContext);
                httpClientBuilder.setConnectionManager(PoolingHttpClientConnectionManagerBuilder.create().setSSLSocketFactory(sslSocketFactory).build());
            }
            catch (IOException | GeneralSecurityException e) {
                throw new BigQueryJdbcRuntimeException(e);
            }
        }
        BigQueryJdbcProxyUtility.addAuthToProxyIfPresent(proxyProperties, httpClientBuilder, callerClassName);
        CloseableHttpClient httpClient = httpClientBuilder.build();
        Apache5HttpTransport httpTransport = new Apache5HttpTransport(httpClient);
        return () -> httpTransport;
    }

    private static void addAuthToProxyIfPresent(Map<String, String> proxyProperties, HttpClientBuilder closeableHttpClientBuilder, String callerClassName) {
        LOG.finest("++enter++\t" + callerClassName);
        if (proxyProperties.containsKey("ProxyUid") && proxyProperties.containsKey("ProxyPwd")) {
            AuthScope authScope = new AuthScope(proxyProperties.get("ProxyHost"), Integer.parseInt(proxyProperties.get("ProxyPort")));
            UsernamePasswordCredentials usernamePasswordCredentials = new UsernamePasswordCredentials(proxyProperties.get("ProxyUid"), proxyProperties.get("ProxyPwd").toCharArray());
            BasicCredentialsProvider proxyCredentialsProvider = new BasicCredentialsProvider();
            proxyCredentialsProvider.setCredentials(authScope, usernamePasswordCredentials);
            closeableHttpClientBuilder.setDefaultCredentialsProvider(proxyCredentialsProvider);
            closeableHttpClientBuilder.setProxyAuthenticationStrategy(DefaultAuthenticationStrategy.INSTANCE);
        }
    }

    static TransportChannelProvider getTransportChannelProvider(final Map<String, String> proxyProperties, String sslTrustStorePath, String sslTrustStorePassword, String callerClassName) {
        boolean hasSsl;
        LOG.finest("++enter++\t" + callerClassName);
        boolean hasProxy = proxyProperties.containsKey("ProxyHost");
        boolean bl = hasSsl = sslTrustStorePath != null;
        if (!hasProxy && !hasSsl) {
            return null;
        }
        InstantiatingGrpcChannelProvider transportChannelProvider = BigQueryReadStubSettings.defaultGrpcTransportProviderBuilder().setChannelConfigurator(managedChannelBuilder -> {
            if (hasProxy) {
                managedChannelBuilder.proxyDetector(new ProxyDetector(){

                    @Override
                    public ProxiedSocketAddress proxyFor(SocketAddress socketAddress) {
                        return BigQueryJdbcProxyUtility.getHttpConnectProxiedSocketAddress((InetSocketAddress)socketAddress, proxyProperties);
                    }
                });
            }
            if (hasSsl && managedChannelBuilder instanceof NettyChannelBuilder) {
                try (FileInputStream trustStoreStream = new FileInputStream(sslTrustStorePath);){
                    KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
                    char[] trustStorePasswordChars = sslTrustStorePassword != null ? sslTrustStorePassword.toCharArray() : null;
                    trustStore.load(trustStoreStream, trustStorePasswordChars);
                    TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                    trustManagerFactory.init(trustStore);
                    SslContext grpcSslContext = GrpcSslContexts.forClient().trustManager(trustManagerFactory).build();
                    ((NettyChannelBuilder)managedChannelBuilder).sslContext(grpcSslContext);
                }
                catch (IOException | GeneralSecurityException e) {
                    throw new BigQueryJdbcRuntimeException(e);
                }
            }
            return managedChannelBuilder;
        }).build();
        return transportChannelProvider;
    }

    private static HttpConnectProxiedSocketAddress getHttpConnectProxiedSocketAddress(InetSocketAddress socketAddress, Map<String, String> proxyProperties) {
        String proxyHost = proxyProperties.get("ProxyHost");
        int proxyPort = Integer.parseInt(proxyProperties.get("ProxyPort"));
        HttpConnectProxiedSocketAddress.Builder builder = HttpConnectProxiedSocketAddress.newBuilder().setProxyAddress(new InetSocketAddress(proxyHost, proxyPort)).setTargetAddress(socketAddress);
        if (proxyProperties.containsKey("ProxyUid") && proxyProperties.containsKey("ProxyPwd")) {
            builder.setUsername(proxyProperties.get("ProxyUid"));
            builder.setPassword(proxyProperties.get("ProxyPwd"));
        }
        return builder.build();
    }
}

