/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.jdbc;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Optional;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

class BigQueryJdbcRootLogger {
    private static final Logger logger = Logger.getLogger("com.google.cloud.bigquery");
    private static final Logger storageLogger = Logger.getLogger("com.google.cloud.bigquery.storage");
    private static Handler fileHandler = null;
    private static Path currentLogPath = null;
    private static int fileCounter = 0;

    BigQueryJdbcRootLogger() {
    }

    public static Formatter getFormatter() {
        return new Formatter(){
            private static final String PATTERN = "yyyy-MM-dd HH:mm:ss.SSS";
            private static final String FORMAT = "%1$s %2$5s %3$d --- [%4$-7.15s] %5$-50s %6$-20s: %7$s%8$s";
            private static final int MAX_THREAD_NAME_LENGTH = 15;

            Optional<Thread> getThread(long threadId) {
                return Thread.getAllStackTraces().keySet().stream().filter(thread -> thread.getId() == threadId).findFirst();
            }

            @Override
            public String format(LogRecord record) {
                String date = new SimpleDateFormat(PATTERN).format(new Date(record.getMillis()));
                String threadName = this.getThread(record.getThreadID()).map(Thread::getName).map(name -> name.length() > 15 ? name.substring(name.length() - 15) : name).orElse("");
                long processId = Long.parseLong(ManagementFactory.getRuntimeMXBean().getName().split("@")[0]);
                String sourceClassName = record.getLoggerName();
                String sourceMethodName = record.getSourceMethodName();
                return String.format(FORMAT, date, record.getLevel().getName(), processId, threadName, sourceClassName, sourceMethodName, record.getMessage(), System.lineSeparator());
            }
        };
    }

    public static Logger getRootLogger() {
        return logger;
    }

    private static void setHandler() throws IOException {
        for (Handler h2 : logger.getHandlers()) {
            if (h2 instanceof ConsoleHandler) {
                h2.close();
                logger.removeHandler(h2);
                break;
            }
            if (!(h2 instanceof FileHandler)) continue;
            fileHandler = h2;
            break;
        }
        if (fileHandler == null) {
            String fileName = String.format("BigQueryJdbc%d", fileCounter);
            ++fileCounter;
            currentLogPath = Files.createTempFile(fileName, ".log", new FileAttribute[0]);
            currentLogPath.toFile().deleteOnExit();
            fileHandler = new FileHandler(currentLogPath.toString(), 0, 1, true);
            logger.addHandler(fileHandler);
        }
    }

    public static void setLevel(Level level, String logPath) throws IOException {
        if (level != Level.OFF) {
            BigQueryJdbcRootLogger.setPath(logPath);
            if (logger.getHandlers().length == 0) {
                BigQueryJdbcRootLogger.setHandler();
                fileHandler.setFormatter(BigQueryJdbcRootLogger.getFormatter());
                logger.setUseParentHandlers(false);
            }
            fileHandler.setLevel(level);
            logger.setLevel(level);
        } else {
            for (Handler h2 : logger.getHandlers()) {
                h2.close();
                logger.removeHandler(h2);
            }
            fileHandler = null;
            currentLogPath = null;
        }
    }

    static void setPath(String logPath) {
        try {
            Path dir;
            if (!logPath.isEmpty() && !logPath.endsWith("/")) {
                logPath = logPath + "/";
            }
            if (!Files.exists(dir = Paths.get(logPath, new String[0]), new LinkOption[0])) {
                Files.createDirectory(dir, new FileAttribute[0]);
            }
            String fileName = String.format("BigQueryJdbc%d.log", fileCounter);
            ++fileCounter;
            Path destination = Paths.get(logPath + fileName, new String[0]).toAbsolutePath();
            if (currentLogPath != null && !currentLogPath.equals(destination)) {
                Path source = Paths.get(currentLogPath.toUri());
                Files.move(source, destination, StandardCopyOption.REPLACE_EXISTING);
            }
            currentLogPath = destination;
            fileHandler = new FileHandler(currentLogPath.toString(), 0, 1, true);
            fileHandler.setFormatter(BigQueryJdbcRootLogger.getFormatter());
            for (Handler h2 : logger.getHandlers()) {
                if (!(h2 instanceof FileHandler)) continue;
                h2.close();
                logger.removeHandler(h2);
                break;
            }
            logger.addHandler(fileHandler);
        }
        catch (IOException ex) {
            logger.warning("Log File warning : " + ex);
        }
    }

    static {
        logger.setUseParentHandlers(false);
        storageLogger.setUseParentHandlers(true);
    }
}

