/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.jdbc;

import com.google.api.gax.retrying.RetrySettings;
import com.google.cloud.bigquery.FieldList;
import com.google.cloud.bigquery.JobStatistics;
import com.google.cloud.bigquery.QueryJobConfiguration;
import com.google.cloud.bigquery.QueryParameterValue;
import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.StandardSQLTypeName;
import com.google.cloud.bigquery.TableId;
import com.google.cloud.bigquery.exception.BigQueryJdbcException;
import com.google.cloud.bigquery.exception.BigQueryJdbcRuntimeException;
import com.google.cloud.bigquery.jdbc.BigQueryConnection;
import com.google.cloud.bigquery.jdbc.BigQueryJdbcBulkInsertWriter;
import com.google.cloud.bigquery.jdbc.BigQueryJdbcCustomLogger;
import com.google.cloud.bigquery.jdbc.BigQueryJdbcParameter;
import com.google.cloud.bigquery.jdbc.BigQueryParameterHandler;
import com.google.cloud.bigquery.jdbc.BigQueryStatement;
import com.google.cloud.bigquery.storage.v1.BatchCommitWriteStreamsRequest;
import com.google.cloud.bigquery.storage.v1.BatchCommitWriteStreamsResponse;
import com.google.cloud.bigquery.storage.v1.BigQueryWriteClient;
import com.google.cloud.bigquery.storage.v1.TableName;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.protobuf.Descriptors;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.Queue;

class BigQueryPreparedStatement
extends BigQueryStatement
implements PreparedStatement {
    private final BigQueryJdbcCustomLogger LOG = new BigQueryJdbcCustomLogger(this.toString());
    private static final char POSITIONAL_PARAMETER_CHAR = '?';
    protected final BigQueryParameterHandler parameterHandler;
    protected int parameterCount = 0;
    protected String currentQuery;
    private Queue<ArrayList<BigQueryJdbcParameter>> batchParameters = new LinkedList<ArrayList<BigQueryJdbcParameter>>();
    private Schema insertSchema = null;
    private TableName insertTableName = null;

    BigQueryPreparedStatement(BigQueryConnection connection, String query) {
        super(connection);
        this.setCurrentQuery(query);
        this.parameterHandler = new BigQueryParameterHandler(this.parameterCount);
    }

    void setCurrentQuery(String currentQuery) {
        this.parameterCount = this.getParameterCount(currentQuery);
        this.currentQuery = currentQuery;
    }

    private int getParameterCount(String query) {
        this.LOG.finest("++enter++");
        return (int)query.chars().filter(ch -> ch == 63).count();
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        this.LOG.finest("++enter++");
        this.logQueryExecutionStart(this.currentQuery);
        try {
            QueryJobConfiguration.Builder jobConfiguration = this.getJobConfig(this.currentQuery);
            jobConfiguration.setParameterMode("POSITIONAL");
            jobConfiguration = this.parameterHandler.configureParameters(jobConfiguration);
            this.runQuery(this.currentQuery, jobConfiguration.build());
        }
        catch (InterruptedException ex) {
            throw new BigQueryJdbcRuntimeException(ex);
        }
        return this.getCurrentResultSet();
    }

    @Override
    public long executeLargeUpdate() throws SQLException {
        this.LOG.finest("++enter++");
        this.logQueryExecutionStart(this.currentQuery);
        try {
            QueryJobConfiguration.Builder jobConfiguration = this.getJobConfig(this.currentQuery);
            jobConfiguration.setParameterMode("POSITIONAL");
            jobConfiguration = this.parameterHandler.configureParameters(jobConfiguration);
            this.runQuery(this.currentQuery, jobConfiguration.build());
        }
        catch (InterruptedException ex) {
            throw new BigQueryJdbcRuntimeException(ex);
        }
        return this.currentUpdateCount;
    }

    @Override
    public int executeUpdate() throws SQLException {
        this.LOG.finest("++enter++");
        return this.checkUpdateCount(this.executeLargeUpdate());
    }

    @Override
    public boolean execute() throws SQLException {
        this.LOG.finest("++enter++");
        this.logQueryExecutionStart(this.currentQuery);
        try {
            QueryJobConfiguration.Builder jobConfiguration = this.getJobConfig(this.currentQuery);
            jobConfiguration.setParameterMode("POSITIONAL");
            jobConfiguration = this.parameterHandler.configureParameters(jobConfiguration);
            this.runQuery(this.currentQuery, jobConfiguration.build());
        }
        catch (InterruptedException ex) {
            throw new BigQueryJdbcRuntimeException(ex);
        }
        return this.getCurrentResultSet() != null;
    }

    @Override
    public void clearParameters() {
        this.LOG.finest("++enter++");
        this.parameterHandler.clearParameters();
        this.parameterCount = 0;
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) {
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.checkClosed();
        this.parameterHandler.setParameter(parameterIndex, x, Boolean.class);
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.checkClosed();
        this.parameterHandler.setParameter(parameterIndex, x, Byte.class);
    }

    @Override
    public void setShort(int parameterIndex, short x) {
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        this.checkClosed();
        this.parameterHandler.setParameter(parameterIndex, x, Integer.class);
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        this.checkClosed();
        this.parameterHandler.setParameter(parameterIndex, x, Long.class);
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.checkClosed();
        this.parameterHandler.setParameter(parameterIndex, Float.valueOf(x), Float.class);
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.checkClosed();
        this.parameterHandler.setParameter(parameterIndex, x, Double.class);
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.checkClosed();
        this.parameterHandler.setParameter(parameterIndex, x, BigDecimal.class);
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        this.checkClosed();
        this.parameterHandler.setParameter(parameterIndex, x, String.class);
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) {
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.checkClosed();
        this.parameterHandler.setParameter(parameterIndex, x.toString(), String.class);
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.checkClosed();
        this.parameterHandler.setParameter(parameterIndex, x.toString(), String.class);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.checkClosed();
        this.parameterHandler.setParameter(parameterIndex, x.toString(), String.class);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) {
    }

    @Override
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) {
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) {
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) {
    }

    @Override
    public void setObject(int parameterIndex, Object x) {
    }

    @Override
    public void addBatch() {
        this.LOG.finest("++enter++");
        ArrayList<BigQueryJdbcParameter> currentParameterList = this.deepCopyParameterList(this.parameterHandler.parametersList);
        this.batchParameters.add(currentParameterList);
    }

    private ArrayList<BigQueryJdbcParameter> deepCopyParameterList(ArrayList<BigQueryJdbcParameter> parametersList) {
        ArrayList<BigQueryJdbcParameter> copiedParameterList = new ArrayList<BigQueryJdbcParameter>();
        for (BigQueryJdbcParameter parameter : parametersList) {
            BigQueryJdbcParameter newParameter = new BigQueryJdbcParameter(parameter);
            copiedParameterList.add(newParameter);
        }
        return copiedParameterList;
    }

    @Override
    public int[] executeBatch() throws SQLException {
        this.LOG.finest("++enter++");
        int[] result = new int[this.batchParameters.size()];
        if (this.batchParameters.isEmpty()) {
            return result;
        }
        if (this.useWriteAPI().booleanValue()) {
            BigQueryWriteClient writeClient = this.connection.getBigQueryWriteClient();
            try {
                this.LOG.info("Using Write API for bulk INSERT operation.");
                ArrayList<BigQueryJdbcParameter> currentParameterList = this.batchParameters.peek();
                if (this.insertSchema == null && this.insertTableName == null) {
                    JobStatistics.QueryStatistics insertJobQueryStatistics = this.getQueryStatistics(this.getWriteBatchJobConfiguration(currentParameterList));
                    this.setInsertMetadata(insertJobQueryStatistics);
                }
                long rowCount = this.bulkInsertWithWriteAPI(writeClient);
                int[] insertArray = new int[Math.toIntExact(rowCount)];
                Arrays.fill(insertArray, 1);
                int[] nArray = insertArray;
                if (writeClient != null) {
                    writeClient.close();
                }
                return nArray;
            }
            catch (Throwable currentParameterList) {
                try {
                    if (writeClient != null) {
                        try {
                            writeClient.close();
                        }
                        catch (Throwable rowCount) {
                            currentParameterList.addSuppressed(rowCount);
                        }
                    }
                    throw currentParameterList;
                }
                catch (Descriptors.DescriptorValidationException | IOException | InterruptedException e) {
                    throw new BigQueryJdbcRuntimeException(e);
                }
            }
        }
        try {
            int i;
            this.LOG.info("Using individual INSERT query runs.");
            int count = this.batchParameters.size();
            StringBuilder combinedQuery = new StringBuilder();
            for (i = 0; i < count; ++i) {
                if (this.currentQuery.trim().endsWith(";")) {
                    combinedQuery.append(this.currentQuery);
                    continue;
                }
                combinedQuery.append(this.currentQuery).append(";");
            }
            this.runQuery(combinedQuery.toString(), this.getStandardBatchJobConfiguration(combinedQuery.toString()));
            for (i = 0; this.getUpdateCount() != -1 && i < count; ++i) {
                result[i] = this.getUpdateCount();
                this.getMoreResults();
            }
            return result;
        }
        catch (InterruptedException ex) {
            throw new BigQueryJdbcRuntimeException(ex);
        }
        catch (SQLException e) {
            throw new BigQueryJdbcException(e);
        }
    }

    private long bulkInsertWithWriteAPI(BigQueryWriteClient bigQueryWriteClient) throws Descriptors.DescriptorValidationException, IOException, InterruptedException, BigQueryJdbcException {
        this.LOG.finest("++enter++");
        RetrySettings retrySettings = this.connection.getRetrySettings();
        BigQueryJdbcBulkInsertWriter bulkInsertWriter = new BigQueryJdbcBulkInsertWriter();
        bulkInsertWriter.initialize(this.insertTableName, bigQueryWriteClient, retrySettings);
        try {
            long offset = 0L;
            JsonArray jsonArray = new JsonArray();
            Gson gson = new Gson();
            int count = this.batchParameters.size();
            for (int i = 0; i < count; ++i) {
                ArrayList<BigQueryJdbcParameter> parameterList = this.batchParameters.poll();
                FieldList fieldLists = this.insertSchema.getFields();
                if (fieldLists.size() == parameterList.size()) {
                    JsonObject rowObject = new JsonObject();
                    for (int j = 0; j < parameterList.size(); ++j) {
                        BigQueryJdbcParameter parameter = parameterList.get(j);
                        if (parameter.getSqlType() == StandardSQLTypeName.STRING) {
                            rowObject.addProperty(fieldLists.get(j).getName(), parameter.getValue().toString());
                            continue;
                        }
                        rowObject.addProperty(fieldLists.get(j).getName(), gson.toJson(parameter.getValue()));
                    }
                    jsonArray.add(rowObject);
                    if (jsonArray.size() != this.querySettings.getWriteAPIAppendRowCount() && this.batchParameters.size() != 0) continue;
                    bulkInsertWriter.append(jsonArray, offset);
                    this.LOG.finest("Append called ");
                    offset += (long)jsonArray.size();
                    jsonArray = new JsonArray();
                    continue;
                }
                throw new BigQueryJdbcException("Mismatch between field count and parameter count.");
            }
        }
        catch (BigQueryJdbcException e) {
            throw new RuntimeException(e);
        }
        long rowCount = bulkInsertWriter.cleanup(bigQueryWriteClient);
        BatchCommitWriteStreamsRequest commitRequest = BatchCommitWriteStreamsRequest.newBuilder().setParent(this.insertTableName.toString()).addWriteStreams(bulkInsertWriter.getStreamName()).build();
        BatchCommitWriteStreamsResponse commitResponse = bigQueryWriteClient.batchCommitWriteStreams(commitRequest);
        if (!commitResponse.hasCommitTime()) {
            throw new BigQueryJdbcException("Error committing the streams");
        }
        this.LOG.finest("Commit called.");
        return rowCount;
    }

    private void setInsertMetadata(JobStatistics.QueryStatistics statistics) throws SQLException {
        this.LOG.finest("++enter++");
        if (!statistics.getStatementType().equals(JobStatistics.QueryStatistics.StatementType.INSERT) || statistics.getSchema() == null || statistics.getReferencedTables().stream().distinct().count() > 1L) {
            throw new BigQueryJdbcException("Use java.sql.Statement.executeBatch() for heterogeneous DML batches");
        }
        this.insertSchema = statistics.getSchema();
        TableId tableID = statistics.getReferencedTables().get(0);
        this.insertTableName = TableName.of(tableID.getProject(), tableID.getDataset(), tableID.getTable());
        this.LOG.finest(String.format("this.insertTableName : %s, this.insertSchema : %s", this.insertTableName, this.insertSchema.toString()));
    }

    QueryJobConfiguration getWriteBatchJobConfiguration(ArrayList<BigQueryJdbcParameter> currentParameterList) throws SQLException {
        this.LOG.finest("++enter++");
        BigQueryParameterHandler batchHandler = new BigQueryParameterHandler(this.parameterCount, currentParameterList);
        QueryJobConfiguration.Builder jobConfiguration = this.getJobConfig(this.currentQuery);
        jobConfiguration.setParameterMode("POSITIONAL");
        jobConfiguration = batchHandler.configureParameters(jobConfiguration);
        return jobConfiguration.build();
    }

    QueryJobConfiguration getStandardBatchJobConfiguration(String query) throws SQLException {
        this.LOG.finest("++enter++");
        QueryJobConfiguration.Builder jobConfiguration = this.getJobConfig(query);
        jobConfiguration.setParameterMode("POSITIONAL");
        jobConfiguration.setPriority(QueryJobConfiguration.Priority.BATCH);
        int index = 0;
        while (!this.batchParameters.isEmpty()) {
            ArrayList<BigQueryJdbcParameter> parameterList = this.batchParameters.poll();
            for (BigQueryJdbcParameter parameter : parameterList) {
                Object parameterValue = parameter.getValue();
                StandardSQLTypeName sqlType = parameter.getSqlType();
                this.LOG.finest(String.format("Parameter %s of type %s at index %s added to QueryJobConfiguration", new Object[]{parameterValue, sqlType, index++}));
                jobConfiguration.addPositionalParameter(QueryParameterValue.of(parameterValue, sqlType));
            }
        }
        return jobConfiguration.build();
    }

    Boolean useWriteAPI() {
        this.LOG.finest("++enter++");
        if (this.querySettings.isUseWriteAPI() && this.batchParameters.size() >= this.querySettings.getWriteAPIActivationRowCount()) {
            return true;
        }
        return false;
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) {
    }

    @Override
    public void setRef(int parameterIndex, Ref x) {
    }

    @Override
    public void setBlob(int parameterIndex, Blob x) {
    }

    @Override
    public void setClob(int parameterIndex, Clob x) {
    }

    @Override
    public void setArray(int parameterIndex, Array x) {
    }

    @Override
    public ResultSetMetaData getMetaData() {
        return null;
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) {
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) {
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) {
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) {
    }

    @Override
    public void setURL(int parameterIndex, URL x) {
    }

    @Override
    public ParameterMetaData getParameterMetaData() {
        return null;
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) {
    }

    @Override
    public void setNString(int parameterIndex, String value) {
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) {
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) {
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) {
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) {
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) {
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) {
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) {
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) {
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) {
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) {
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) {
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) {
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) {
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) {
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) {
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) {
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) {
    }
}

