/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.jdbc;

import com.google.api.core.InternalApi;
import com.google.cloud.bigquery.jdbc.BigQueryArrowResultSet;
import com.google.cloud.bigquery.jdbc.BigQueryJdbcCustomLogger;
import com.google.cloud.bigquery.jdbc.BigQueryJsonResultSet;
import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;

@InternalApi
class BigQueryResultSetFinalizers {
    private static final BigQueryJdbcCustomLogger LOG = new BigQueryJdbcCustomLogger(BigQueryResultSetFinalizers.class.getName());

    BigQueryResultSetFinalizers() {
    }

    @InternalApi
    static class JsonResultSetFinalizer
    extends PhantomReference<BigQueryJsonResultSet> {
        Thread[] ownedThreads;

        public JsonResultSetFinalizer(BigQueryJsonResultSet referent, ReferenceQueue<? super BigQueryJsonResultSet> q, Thread[] ownedThreads) {
            super(referent, q);
            this.ownedThreads = ownedThreads;
        }

        public void finalizeResources() {
            LOG.finest("++enter++");
            if (this.ownedThreads != null) {
                for (Thread ownedThread : this.ownedThreads) {
                    if (ownedThread.isInterrupted()) continue;
                    ownedThread.interrupt();
                }
            }
        }
    }

    @InternalApi
    static class ArrowResultSetFinalizer
    extends PhantomReference<BigQueryArrowResultSet> {
        Thread ownedThread;

        public ArrowResultSetFinalizer(BigQueryArrowResultSet referent, ReferenceQueue<? super BigQueryArrowResultSet> q, Thread ownedThread) {
            super(referent, q);
            this.ownedThread = ownedThread;
        }

        public void finalizeResources() {
            LOG.finest("++enter++");
            if (this.ownedThread != null && !this.ownedThread.isInterrupted()) {
                this.ownedThread.interrupt();
            }
        }
    }
}

