/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.jdbc;

import com.google.cloud.bigquery.Field;
import com.google.cloud.bigquery.FieldList;
import com.google.cloud.bigquery.StandardSQLTypeName;
import com.google.cloud.bigquery.exception.BigQueryJdbcSqlFeatureNotSupportedException;
import com.google.cloud.bigquery.jdbc.BigQueryJdbcCustomLogger;
import com.google.cloud.bigquery.jdbc.BigQueryJdbcTypeMappings;
import java.sql.Array;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;

class BigQueryResultSetMetadata
implements ResultSetMetaData {
    private final BigQueryJdbcCustomLogger LOG = new BigQueryJdbcCustomLogger(this.toString());
    private final FieldList schemaFieldList;
    private final Statement statement;
    private final int columnCount;
    private static final int DEFAULT_DISPLAY_SIZE = 50;

    private BigQueryResultSetMetadata(FieldList schemaFieldList, Statement statement) {
        this.LOG.finest("++enter++");
        this.schemaFieldList = schemaFieldList;
        this.columnCount = schemaFieldList.size();
        this.statement = statement;
    }

    static BigQueryResultSetMetadata of(FieldList schemaFieldList, Statement statement) {
        return new BigQueryResultSetMetadata(schemaFieldList, statement);
    }

    private Field getField(int sqlColumn) {
        return this.schemaFieldList.get(sqlColumn - 1);
    }

    @Override
    public int getColumnCount() {
        return this.columnCount;
    }

    @Override
    public boolean isAutoIncrement(int column) {
        return false;
    }

    @Override
    public boolean isCaseSensitive(int column) {
        int colType = this.getColumnType(column);
        return colType == -9;
    }

    @Override
    public boolean isSearchable(int column) {
        int colType = this.getColumnType(column);
        return colType != 1111;
    }

    @Override
    public boolean isCurrency(int column) {
        return false;
    }

    @Override
    public int isNullable(int column) {
        Field.Mode colMode = this.getField(column).getMode();
        if (colMode == null) {
            return 2;
        }
        return colMode == Field.Mode.NULLABLE ? 1 : 0;
    }

    @Override
    public boolean isSigned(int column) {
        int colType = this.getColumnType(column);
        return colType == 6 || colType == 8 || colType == -5 || colType == 2;
    }

    @Override
    public int getColumnDisplaySize(int column) {
        int colType = this.getColumnType(column);
        switch (colType) {
            case 16: {
                return 5;
            }
            case -5: 
            case 91: {
                return 10;
            }
            case 2: 
            case 3: 
            case 8: {
                return 14;
            }
            case 93: {
                return 16;
            }
        }
        return 50;
    }

    @Override
    public String getColumnLabel(int column) {
        return this.getField(column).getName();
    }

    @Override
    public String getColumnName(int column) {
        return this.getField(column).getName();
    }

    @Override
    public int getPrecision(int column) {
        return (int)(this.getField(column).getPrecision() != null ? this.getField(column).getPrecision() : 0L);
    }

    @Override
    public int getScale(int column) {
        return (int)(this.getField(column).getScale() != null ? this.getField(column).getScale() : 0L);
    }

    @Override
    public String getTableName(int column) {
        return "";
    }

    @Override
    public String getCatalogName(int column) {
        return "";
    }

    @Override
    public String getSchemaName(int column) {
        return "";
    }

    private StandardSQLTypeName getStandardSQLTypeName(int column) {
        Field field = this.getField(column);
        if (field.getMode() == Field.Mode.REPEATED) {
            return StandardSQLTypeName.ARRAY;
        }
        return this.getField(column).getType().getStandardType();
    }

    @Override
    public int getColumnType(int column) {
        return BigQueryJdbcTypeMappings.standardSQLToJavaSqlTypesMapping.get((Object)this.getStandardSQLTypeName(column));
    }

    @Override
    public String getColumnTypeName(int column) {
        return this.getStandardSQLTypeName(column).name();
    }

    @Override
    public boolean isReadOnly(int column) {
        return false;
    }

    @Override
    public boolean isWritable(int column) {
        return !this.isReadOnly(column);
    }

    @Override
    public boolean isDefinitelyWritable(int column) {
        return false;
    }

    @Override
    public String getColumnClassName(int column) {
        Field field = this.getField(column);
        if (field.getMode() == Field.Mode.REPEATED) {
            return Array.class.getName();
        }
        return BigQueryJdbcTypeMappings.standardSQLToJavaTypeMapping.get((Object)field.getType().getStandardType()).getName();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new BigQueryJdbcSqlFeatureNotSupportedException("unwrap is not implemented");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new BigQueryJdbcSqlFeatureNotSupportedException("isWrapperFor is not implemented");
    }
}

