/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.jdbc;

import com.google.cloud.bigquery.Clustering;
import com.google.cloud.bigquery.ConnectionProperty;
import com.google.cloud.bigquery.DatasetId;
import com.google.cloud.bigquery.EncryptionConfiguration;
import com.google.cloud.bigquery.ExternalTableDefinition;
import com.google.cloud.bigquery.JobInfo;
import com.google.cloud.bigquery.QueryJobConfiguration;
import com.google.cloud.bigquery.RangePartitioning;
import com.google.cloud.bigquery.TimePartitioning;
import com.google.cloud.bigquery.UserDefinedFunction;
import java.util.List;
import java.util.Map;

class BigQuerySettings {
    private final boolean useReadAPI;
    private final int highThroughputActivationRatio;
    private final int highThroughputMinTableSize;
    private final boolean unsupportedHTAPIFallback;
    private final boolean enableSession;
    private final ConnectionProperty sessionInfoConnectionProperty;
    private final boolean useQueryCache;
    private final String queryDialect;
    private final List<ConnectionProperty> queryProperties;
    private final Boolean allowLargeResults;
    private final String kmsKeyName;
    private final Clustering clustering;
    private final JobInfo.CreateDisposition createDisposition;
    private final EncryptionConfiguration destinationEncryptionConfiguration;
    private final String destinationTable;
    private final String destinationDataset;
    private final long destinationDatasetExpirationTime;
    private final long jobTimeoutMs;
    private final int maximumBillingTier;
    private final QueryJobConfiguration.Priority priority;
    private final RangePartitioning rangePartitioning;
    private final List<JobInfo.SchemaUpdateOption> schemaUpdateOptions;
    private final Map<String, ExternalTableDefinition> tableDefinitions;
    private final TimePartitioning timePartitioning;
    private final List<UserDefinedFunction> userDefinedFunctions;
    private final JobInfo.WriteDisposition writeDisposition;
    private final int numBufferedRows;
    private final long maxResultPerPage;
    private final DatasetId defaultDataset;
    private final boolean useWriteAPI;
    private final int writeAPIActivationRowCount;
    private final int writeAPIAppendRowCount;
    private final long maxBytesBilled;
    private final Map<String, String> labels;

    private BigQuerySettings(Builder builder) {
        this.useReadAPI = builder.useReadAPI;
        this.highThroughputActivationRatio = builder.highThroughputActivationRatio;
        this.highThroughputMinTableSize = builder.highThroughputMinTableSize;
        this.useQueryCache = builder.useQueryCache;
        this.queryDialect = builder.queryDialect;
        this.queryProperties = builder.queryProperties;
        this.allowLargeResults = builder.allowLargeResults;
        this.kmsKeyName = builder.kmsKeyName;
        this.clustering = builder.clustering;
        this.createDisposition = builder.createDisposition;
        this.destinationEncryptionConfiguration = builder.destinationEncryptionConfiguration;
        this.destinationTable = builder.destinationTable;
        this.destinationDataset = builder.destinationDataset;
        this.destinationDatasetExpirationTime = builder.destinationDatasetExpirationTime;
        this.jobTimeoutMs = builder.jobTimeoutMs;
        this.maximumBillingTier = builder.maximumBillingTier;
        this.priority = builder.priority;
        this.rangePartitioning = builder.rangePartitioning;
        this.schemaUpdateOptions = builder.schemaUpdateOptions;
        this.tableDefinitions = builder.tableDefinitions;
        this.timePartitioning = builder.timePartitioning;
        this.userDefinedFunctions = builder.userDefinedFunctions;
        this.writeDisposition = builder.writeDisposition;
        this.numBufferedRows = builder.numBufferedRows;
        this.maxResultPerPage = builder.maxResultPerPage;
        this.defaultDataset = builder.defaultDataset;
        this.enableSession = builder.enableSession;
        this.unsupportedHTAPIFallback = builder.unsupportedHTAPIFallback;
        this.sessionInfoConnectionProperty = builder.sessionInfoConnectionProperty;
        this.useWriteAPI = builder.useWriteAPI;
        this.writeAPIActivationRowCount = builder.writeAPIActivationRowCount;
        this.writeAPIAppendRowCount = builder.writeAPIAppendRowCount;
        this.maxBytesBilled = builder.maxBytesBilled;
        this.labels = builder.labels;
    }

    static Builder newBuilder() {
        return new Builder();
    }

    Boolean getUseReadAPI() {
        return this.useReadAPI;
    }

    int getHighThroughputActivationRatio() {
        return this.highThroughputActivationRatio;
    }

    int getHighThroughputMinTableSize() {
        return this.highThroughputMinTableSize;
    }

    boolean isEnableSession() {
        return this.enableSession;
    }

    boolean isUnsupportedHTAPIFallback() {
        return this.unsupportedHTAPIFallback;
    }

    ConnectionProperty getSessionInfoConnectionProperty() {
        return this.sessionInfoConnectionProperty;
    }

    Boolean getUseQueryCache() {
        return this.useQueryCache;
    }

    String getQueryDialect() {
        return this.queryDialect;
    }

    List<ConnectionProperty> getQueryProperties() {
        return this.queryProperties;
    }

    String getKmsKeyName() {
        return this.kmsKeyName;
    }

    Boolean getAllowLargeResults() {
        return this.allowLargeResults;
    }

    Clustering getClustering() {
        return this.clustering;
    }

    JobInfo.CreateDisposition getCreateDisposition() {
        return this.createDisposition;
    }

    EncryptionConfiguration getDestinationEncryptionConfiguration() {
        return this.destinationEncryptionConfiguration;
    }

    String getDestinationTable() {
        return this.destinationTable;
    }

    String getDestinationDataset() {
        return this.destinationDataset;
    }

    long getDestinationDatasetExpirationTime() {
        return this.destinationDatasetExpirationTime;
    }

    Long getJobTimeoutMs() {
        return this.jobTimeoutMs;
    }

    Integer getMaximumBillingTier() {
        return this.maximumBillingTier;
    }

    QueryJobConfiguration.Priority getPriority() {
        return this.priority;
    }

    RangePartitioning getRangePartitioning() {
        return this.rangePartitioning;
    }

    List<JobInfo.SchemaUpdateOption> getSchemaUpdateOptions() {
        return this.schemaUpdateOptions;
    }

    Map<String, ExternalTableDefinition> getTableDefinitions() {
        return this.tableDefinitions;
    }

    TimePartitioning getTimePartitioning() {
        return this.timePartitioning;
    }

    List<UserDefinedFunction> getUserDefinedFunctions() {
        return this.userDefinedFunctions;
    }

    JobInfo.WriteDisposition getWriteDisposition() {
        return this.writeDisposition;
    }

    Integer getNumBufferedRows() {
        return this.numBufferedRows;
    }

    Long getMaxResultPerPage() {
        return this.maxResultPerPage;
    }

    DatasetId getDefaultDataset() {
        return this.defaultDataset;
    }

    boolean isUseWriteAPI() {
        return this.useWriteAPI;
    }

    int getWriteAPIActivationRowCount() {
        return this.writeAPIActivationRowCount;
    }

    int getWriteAPIAppendRowCount() {
        return this.writeAPIAppendRowCount;
    }

    long getMaxBytesBilled() {
        return this.maxBytesBilled;
    }

    Map<String, String> getLabels() {
        return this.labels;
    }

    public String toString() {
        return "BigQuerySettings{enableSession=" + this.enableSession + ", unsupportedHTAPIFallback=" + this.unsupportedHTAPIFallback + ", sessionInfo=" + this.sessionInfoConnectionProperty + ", useReadAPI=" + this.useReadAPI + ", kmsKeyName=" + this.kmsKeyName + ", highThroughputMinTableSize=" + this.highThroughputMinTableSize + ", highThroughputActivationRatio=" + this.highThroughputActivationRatio + ", useQueryCache=" + this.useQueryCache + ", queryDialect=" + this.queryDialect + ", queryProperties=" + this.queryProperties + ", allowLargeResults=" + this.allowLargeResults + ", clustering=" + this.clustering + ", createDisposition=" + (Object)((Object)this.createDisposition) + ", destinationEncryptionConfiguration=" + this.destinationEncryptionConfiguration + ", destinationTable=" + this.destinationTable + ", destinationDataset=" + this.destinationDataset + ", destinationDatasetExpirationTime=" + this.destinationDatasetExpirationTime + ", jobTimeoutMs=" + this.jobTimeoutMs + ", maximumBillingTier=" + this.maximumBillingTier + ", priority=" + (Object)((Object)this.priority) + ", rangePartitioning=" + this.rangePartitioning + ", schemaUpdateOptions=" + this.schemaUpdateOptions + ", tableDefinitions=" + this.tableDefinitions + ", timePartitioning=" + this.timePartitioning + ", userDefinedFunctions=" + this.userDefinedFunctions + ", writeDisposition=" + (Object)((Object)this.writeDisposition) + ", numBufferedRows=" + this.numBufferedRows + ", maxResultPerPage=" + this.maxResultPerPage + ", defaultDataset=" + this.defaultDataset + ", useWriteAPI=" + this.useWriteAPI + ", writeAPIActivationRowCount=" + this.writeAPIActivationRowCount + ", writeAPIAppendRowCount=" + this.writeAPIAppendRowCount + ", maxBytesBilled=" + this.maxBytesBilled + "}";
    }

    Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder {
        private boolean useReadAPI;
        private int highThroughputMinTableSize;
        private int highThroughputActivationRatio;
        private boolean enableSession;
        private boolean unsupportedHTAPIFallback;
        private ConnectionProperty sessionInfoConnectionProperty;
        private boolean useQueryCache;
        private String queryDialect;
        private List<ConnectionProperty> queryProperties;
        private Boolean allowLargeResults;
        private String kmsKeyName;
        private Clustering clustering;
        private JobInfo.CreateDisposition createDisposition;
        private EncryptionConfiguration destinationEncryptionConfiguration;
        private String destinationTable;
        private String destinationDataset;
        private long destinationDatasetExpirationTime;
        private long jobTimeoutMs;
        private int maximumBillingTier;
        private QueryJobConfiguration.Priority priority;
        private RangePartitioning rangePartitioning;
        private List<JobInfo.SchemaUpdateOption> schemaUpdateOptions;
        private Map<String, ExternalTableDefinition> tableDefinitions;
        private TimePartitioning timePartitioning;
        private List<UserDefinedFunction> userDefinedFunctions;
        private JobInfo.WriteDisposition writeDisposition;
        private int numBufferedRows;
        private long maxResultPerPage;
        private DatasetId defaultDataset;
        private boolean useWriteAPI;
        private int writeAPIActivationRowCount;
        private int writeAPIAppendRowCount;
        private long maxBytesBilled;
        private Map<String, String> labels;

        Builder() {
            this.withDefaultValues();
        }

        private Builder(BigQuerySettings querySettings) {
            this.useReadAPI = querySettings.getUseReadAPI();
            this.highThroughputMinTableSize = querySettings.getHighThroughputMinTableSize();
            this.highThroughputActivationRatio = querySettings.getHighThroughputActivationRatio();
            this.enableSession = querySettings.isEnableSession();
            this.unsupportedHTAPIFallback = querySettings.isUnsupportedHTAPIFallback();
            this.sessionInfoConnectionProperty = querySettings.getSessionInfoConnectionProperty();
            this.useQueryCache = querySettings.getUseQueryCache();
            this.queryDialect = querySettings.getQueryDialect();
            this.queryProperties = querySettings.getQueryProperties();
            this.allowLargeResults = querySettings.getAllowLargeResults();
            this.kmsKeyName = querySettings.getKmsKeyName();
            this.clustering = querySettings.getClustering();
            this.createDisposition = querySettings.getCreateDisposition();
            this.destinationEncryptionConfiguration = querySettings.getDestinationEncryptionConfiguration();
            this.destinationTable = querySettings.getDestinationTable();
            this.destinationDataset = querySettings.getDestinationDataset();
            this.destinationDatasetExpirationTime = querySettings.destinationDatasetExpirationTime;
            this.jobTimeoutMs = querySettings.getJobTimeoutMs();
            this.maximumBillingTier = querySettings.getMaximumBillingTier();
            this.priority = querySettings.getPriority();
            this.rangePartitioning = querySettings.getRangePartitioning();
            this.schemaUpdateOptions = querySettings.getSchemaUpdateOptions();
            this.tableDefinitions = querySettings.getTableDefinitions();
            this.timePartitioning = querySettings.getTimePartitioning();
            this.userDefinedFunctions = querySettings.getUserDefinedFunctions();
            this.writeDisposition = querySettings.getWriteDisposition();
            this.numBufferedRows = querySettings.getNumBufferedRows();
            this.maxResultPerPage = querySettings.getMaxResultPerPage();
            this.defaultDataset = querySettings.getDefaultDataset();
            this.useWriteAPI = querySettings.isUseWriteAPI();
            this.writeAPIActivationRowCount = querySettings.getWriteAPIActivationRowCount();
            this.writeAPIAppendRowCount = querySettings.getWriteAPIAppendRowCount();
            this.maxBytesBilled = querySettings.getMaxBytesBilled();
            this.labels = querySettings.getLabels();
        }

        Builder withDefaultValues() {
            return this.setUseReadAPI(false).setQueryDialect("SQL").setNumBufferedRows(10000).setMaxResultPerPage(10000L);
        }

        Builder setUseReadAPI(boolean useReadAPI) {
            this.useReadAPI = useReadAPI;
            return this;
        }

        Builder setHighThroughputMinTableSize(int highThroughputMinTableSize) {
            this.highThroughputMinTableSize = highThroughputMinTableSize;
            return this;
        }

        Builder setHighThroughputActivationRatio(int highThroughputActivationRatio) {
            this.highThroughputActivationRatio = highThroughputActivationRatio;
            return this;
        }

        Builder setEnableSession(boolean enableSession) {
            this.enableSession = enableSession;
            return this;
        }

        Builder setUnsupportedHTAPIFallback(boolean unsupportedHTAPIFallback) {
            this.unsupportedHTAPIFallback = unsupportedHTAPIFallback;
            return this;
        }

        Builder setSessionInfoConnectionProperty(ConnectionProperty sessionInfoConnectionProperty) {
            this.sessionInfoConnectionProperty = sessionInfoConnectionProperty;
            return this;
        }

        Builder setUseQueryCache(boolean useQueryCache) {
            this.useQueryCache = useQueryCache;
            return this;
        }

        Builder setAllowLargeResults(Boolean allowLargeResults) {
            this.allowLargeResults = allowLargeResults;
            return this;
        }

        Builder setKmsKeyName(String kmsKeyName) {
            this.kmsKeyName = kmsKeyName;
            return this;
        }

        Builder setQueryDialect(String queryDialect) {
            this.queryDialect = queryDialect;
            return this;
        }

        Builder setQueryProperties(List<ConnectionProperty> queryProperties) {
            this.queryProperties = queryProperties;
            return this;
        }

        Builder setClustering(Clustering clustering) {
            this.clustering = clustering;
            return this;
        }

        Builder setCreateDisposition(JobInfo.CreateDisposition createDisposition) {
            this.createDisposition = createDisposition;
            return this;
        }

        Builder setDestinationEncryptionConfiguration(EncryptionConfiguration destinationEncryptionConfiguration) {
            this.destinationEncryptionConfiguration = destinationEncryptionConfiguration;
            return this;
        }

        Builder setDestinationTable(String destinationTable) {
            this.destinationTable = destinationTable;
            return this;
        }

        Builder setDestinationDataset(String destinationDataset) {
            this.destinationDataset = destinationDataset;
            return this;
        }

        Builder setDestinationDatasetExpirationTime(long destinationDatasetExpirationTime) {
            this.destinationDatasetExpirationTime = destinationDatasetExpirationTime;
            return this;
        }

        Builder setJobTimeoutMs(long jobTimeoutMs) {
            this.jobTimeoutMs = jobTimeoutMs;
            return this;
        }

        Builder setMaximumBillingTier(int maximumBillingTier) {
            this.maximumBillingTier = maximumBillingTier;
            return this;
        }

        Builder setPriority(QueryJobConfiguration.Priority priority) {
            this.priority = priority;
            return this;
        }

        Builder setRangePartitioning(RangePartitioning rangePartitioning) {
            this.rangePartitioning = rangePartitioning;
            return this;
        }

        Builder setSchemaUpdateOptions(List<JobInfo.SchemaUpdateOption> schemaUpdateOptions) {
            this.schemaUpdateOptions = schemaUpdateOptions;
            return this;
        }

        Builder setTableDefinitions(Map<String, ExternalTableDefinition> tableDefinitions) {
            this.tableDefinitions = tableDefinitions;
            return this;
        }

        Builder setTimePartitioning(TimePartitioning timePartitioning) {
            this.timePartitioning = timePartitioning;
            return this;
        }

        Builder setUserDefinedFunctions(List<UserDefinedFunction> userDefinedFunctions) {
            this.userDefinedFunctions = userDefinedFunctions;
            return this;
        }

        Builder setWriteDisposition(JobInfo.WriteDisposition writeDisposition) {
            this.writeDisposition = writeDisposition;
            return this;
        }

        Builder setNumBufferedRows(int numBufferedRows) {
            this.numBufferedRows = numBufferedRows;
            return this;
        }

        Builder setMaxResultPerPage(long maxResultPerPage) {
            this.maxResultPerPage = maxResultPerPage;
            return this;
        }

        Builder setDefaultDataset(DatasetId defaultDataset) {
            this.defaultDataset = defaultDataset;
            return this;
        }

        Builder setUseWriteAPI(boolean useWriteAPI) {
            this.useWriteAPI = useWriteAPI;
            return this;
        }

        Builder setWriteAPIActivationRowCount(int writeAPIActivationRowCount) {
            this.writeAPIActivationRowCount = writeAPIActivationRowCount;
            return this;
        }

        Builder setWriteAPIAppendRowCount(int writeAPIAppendRowCount) {
            this.writeAPIAppendRowCount = writeAPIAppendRowCount;
            return this;
        }

        Builder setMaxBytesBilled(long maxBytesBilled) {
            this.maxBytesBilled = maxBytesBilled;
            return this;
        }

        Builder setLabels(Map<String, String> labels) {
            this.labels = labels;
            return this;
        }

        BigQuerySettings build() {
            return new BigQuerySettings(this);
        }
    }
}

