/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.jdbc;

import com.google.api.core.InternalApi;
import com.google.api.gax.paging.Page;
import com.google.api.gax.rpc.ServerStream;
import com.google.cloud.RetryOption;
import com.google.cloud.Tuple;
import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.BigQueryException;
import com.google.cloud.bigquery.Dataset;
import com.google.cloud.bigquery.DatasetId;
import com.google.cloud.bigquery.DatasetInfo;
import com.google.cloud.bigquery.EncryptionConfiguration;
import com.google.cloud.bigquery.FieldValueList;
import com.google.cloud.bigquery.Job;
import com.google.cloud.bigquery.JobConfiguration;
import com.google.cloud.bigquery.JobId;
import com.google.cloud.bigquery.JobInfo;
import com.google.cloud.bigquery.JobStatistics;
import com.google.cloud.bigquery.QueryJobConfiguration;
import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.TableId;
import com.google.cloud.bigquery.TableResult;
import com.google.cloud.bigquery.exception.BigQueryJdbcException;
import com.google.cloud.bigquery.exception.BigQueryJdbcRuntimeException;
import com.google.cloud.bigquery.exception.BigQueryJdbcSqlFeatureNotSupportedException;
import com.google.cloud.bigquery.exception.BigQueryJdbcSqlSyntaxErrorException;
import com.google.cloud.bigquery.jdbc.BigQueryArrowBatchWrapper;
import com.google.cloud.bigquery.jdbc.BigQueryArrowResultSet;
import com.google.cloud.bigquery.jdbc.BigQueryConnection;
import com.google.cloud.bigquery.jdbc.BigQueryDaemonPollingTask;
import com.google.cloud.bigquery.jdbc.BigQueryFieldValueListWrapper;
import com.google.cloud.bigquery.jdbc.BigQueryJdbcCustomLogger;
import com.google.cloud.bigquery.jdbc.BigQueryJsonResultSet;
import com.google.cloud.bigquery.jdbc.BigQueryNoOpsStatement;
import com.google.cloud.bigquery.jdbc.BigQueryResultSetFinalizers;
import com.google.cloud.bigquery.jdbc.BigQuerySettings;
import com.google.cloud.bigquery.jdbc.BigQuerySqlTypeConverter;
import com.google.cloud.bigquery.jdbc.BigQueryThreadFactory;
import com.google.cloud.bigquery.storage.v1.ArrowRecordBatch;
import com.google.cloud.bigquery.storage.v1.ArrowSchema;
import com.google.cloud.bigquery.storage.v1.BigQueryReadClient;
import com.google.cloud.bigquery.storage.v1.CreateReadSessionRequest;
import com.google.cloud.bigquery.storage.v1.DataFormat;
import com.google.cloud.bigquery.storage.v1.ReadRowsRequest;
import com.google.cloud.bigquery.storage.v1.ReadRowsResponse;
import com.google.cloud.bigquery.storage.v1.ReadSession;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import java.lang.ref.ReferenceQueue;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;

public class BigQueryStatement
extends BigQueryNoOpsStatement {
    private static final int MAX_PROCESS_QUERY_THREADS_CNT = 50;
    protected static ExecutorService queryTaskExecutor = Executors.newFixedThreadPool(50);
    private final BigQueryJdbcCustomLogger LOG = new BigQueryJdbcCustomLogger(this.toString());
    private static final String DEFAULT_DATASET_NAME = "_google_jdbc";
    private static final String DEFAULT_TABLE_NAME = "temp_table_";
    private static final String JDBC_JOB_PREFIX = "google-jdbc-";
    protected ResultSet currentResultSet;
    protected long currentUpdateCount = -1L;
    protected List<JobId> jobIds = new ArrayList<JobId>();
    protected JobIdWrapper parentJobId = null;
    protected int currentJobIdIndex = -1;
    protected List<String> batchQueries = new ArrayList<String>();
    protected BigQueryConnection connection;
    protected int maxFieldSize = 0;
    protected int maxRows = 0;
    protected boolean isClosed = false;
    protected boolean closeOnCompletion = false;
    protected Object cancelLock = new Object();
    protected boolean isCanceled = false;
    protected boolean poolable;
    protected int queryTimeout = 0;
    protected SQLWarning warning;
    private int fetchDirection = 1000;
    private int fetchSize;
    private String scriptQuery;
    private Map<String, String> extraLabels = new HashMap<String, String>();
    private BigQueryReadClient bigQueryReadClient = null;
    private final BigQuery bigQuery;
    final BigQuerySettings querySettings;
    private BlockingQueue<BigQueryFieldValueListWrapper> bigQueryFieldValueListWrapperBlockingQueue;
    private BlockingQueue<BigQueryArrowBatchWrapper> arrowBatchWrapperBlockingQueue;
    static ReferenceQueue<BigQueryArrowResultSet> referenceQueueArrowRs = new ReferenceQueue();
    static ReferenceQueue<BigQueryJsonResultSet> referenceQueueJsonRs = new ReferenceQueue();
    static List<BigQueryResultSetFinalizers.ArrowResultSetFinalizer> arrowResultSetFinalizers = new ArrayList<BigQueryResultSetFinalizers.ArrowResultSetFinalizer>();
    static List<BigQueryResultSetFinalizers.JsonResultSetFinalizer> jsonResultSetFinalizers = new ArrayList<BigQueryResultSetFinalizers.JsonResultSetFinalizer>();
    private static final ThreadFactory JDBC_THREAD_FACTORY = new BigQueryThreadFactory("BigQuery-Thread-");

    @VisibleForTesting
    public BigQueryStatement(BigQueryConnection connection) {
        this.connection = connection;
        this.bigQuery = connection.getBigQuery();
        this.querySettings = this.generateBigQuerySettings();
    }

    private void resetStatementFields() {
        this.isCanceled = false;
        this.scriptQuery = null;
        this.parentJobId = null;
        this.currentJobIdIndex = -1;
        this.currentUpdateCount = -1L;
    }

    private BigQuerySettings generateBigQuerySettings() {
        Long maxBytesBilled;
        this.LOG.finest("++enter++");
        BigQuerySettings.Builder querySettings = BigQuerySettings.newBuilder();
        DatasetId defaultDataset = this.connection.getDefaultDataset();
        if (defaultDataset != null) {
            querySettings.setDefaultDataset(this.connection.defaultDataset);
        }
        if ((maxBytesBilled = Long.valueOf(this.connection.getMaxBytesBilled())) > 0L) {
            querySettings.setMaxBytesBilled(maxBytesBilled);
        }
        if (this.connection.getLabels() != null && !this.connection.getLabels().isEmpty()) {
            querySettings.setLabels(this.connection.getLabels());
        }
        querySettings.setMaxResultPerPage(this.connection.getMaxResults());
        querySettings.setUseReadAPI(this.connection.isEnableHighThroughputAPI());
        querySettings.setHighThroughputMinTableSize(this.connection.getHighThroughputMinTableSize());
        querySettings.setHighThroughputActivationRatio(this.connection.getHighThroughputActivationRatio());
        querySettings.setUnsupportedHTAPIFallback(this.connection.isUnsupportedHTAPIFallback());
        querySettings.setUseQueryCache(this.connection.isUseQueryCache());
        querySettings.setQueryDialect(this.connection.getQueryDialect());
        querySettings.setKmsKeyName(this.connection.getKmsKeyName());
        querySettings.setQueryProperties(this.connection.getQueryProperties());
        querySettings.setAllowLargeResults(this.connection.isAllowLargeResults());
        if (this.connection.getJobTimeoutInSeconds() > 0L) {
            querySettings.setJobTimeoutMs(this.connection.getJobTimeoutInSeconds() * 1000L);
        }
        if (this.connection.getDestinationTable() != null) {
            querySettings.setDestinationTable(this.connection.getDestinationTable());
        }
        if (this.connection.getDestinationDataset() != null) {
            querySettings.setDestinationDataset(this.connection.getDestinationDataset());
            querySettings.setDestinationDatasetExpirationTime(this.connection.getDestinationDatasetExpirationTime());
        }
        if (this.connection.enableSession) {
            if (this.connection.sessionInfoConnectionProperty == null) {
                querySettings.setEnableSession(this.connection.isSessionEnabled());
            } else {
                querySettings.setSessionInfoConnectionProperty(this.connection.getSessionInfoConnectionProperty());
            }
        }
        querySettings.setUseWriteAPI(this.connection.isEnableWriteAPI());
        querySettings.setWriteAPIActivationRowCount(this.connection.getWriteAPIActivationRowCount());
        querySettings.setWriteAPIAppendRowCount(this.connection.getWriteAPIAppendRowCount());
        return querySettings.build();
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        this.LOG.finest("++enter++");
        this.logQueryExecutionStart(sql);
        try {
            QueryJobConfiguration jobConfiguration = this.setDestinationDatasetAndTableInJobConfig(this.getJobConfig(sql).build());
            this.runQuery(sql, jobConfiguration);
        }
        catch (InterruptedException ex) {
            throw new BigQueryJdbcException(ex);
        }
        if (!this.isSingularResultSet()) {
            throw new BigQueryJdbcException("Query returned more than one or didn't return any ResultSet.");
        }
        return this.getCurrentResultSet();
    }

    @Override
    public long executeLargeUpdate(String sql) throws SQLException {
        this.LOG.finest("++enter++");
        this.logQueryExecutionStart(sql);
        try {
            QueryJobConfiguration.Builder jobConfiguration = this.getJobConfig(sql);
            this.runQuery(sql, jobConfiguration.build());
        }
        catch (InterruptedException ex) {
            throw new BigQueryJdbcRuntimeException(ex);
        }
        if (this.currentUpdateCount == -1L) {
            throw new BigQueryJdbcException("Update query expected to return affected row count. Double check query type.");
        }
        return this.currentUpdateCount;
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        this.LOG.finest("++enter++");
        return this.checkUpdateCount(this.executeLargeUpdate(sql));
    }

    int checkUpdateCount(long updateCount) {
        this.LOG.finest("++enter++");
        if (updateCount > Integer.MAX_VALUE) {
            this.LOG.warning("Warning: Table update exceeded maximum limit!");
            return -2;
        }
        return (int)updateCount;
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        this.LOG.finest("++enter++");
        this.logQueryExecutionStart(sql);
        try {
            QueryJobConfiguration jobConfiguration = this.getJobConfig(sql).build();
            if (this.isLargeResultsEnabled() && this.getQueryType(jobConfiguration, null) == SqlType.SELECT) {
                jobConfiguration = this.setDestinationDatasetAndTableInJobConfig(jobConfiguration);
            }
            this.runQuery(sql, jobConfiguration);
        }
        catch (InterruptedException ex) {
            throw new BigQueryJdbcRuntimeException(ex);
        }
        return this.getCurrentResultSet() != null;
    }

    JobStatistics.QueryStatistics.StatementType getStatementType(QueryJobConfiguration queryJobConfiguration) throws SQLException {
        Job job;
        this.LOG.finest("++enter++");
        QueryJobConfiguration dryRunJobConfiguration = queryJobConfiguration.toBuilder().setDryRun(true).build();
        try {
            job = this.bigQuery.create(JobInfo.of(dryRunJobConfiguration), new BigQuery.JobOption[0]);
        }
        catch (BigQueryException ex) {
            if (ex.getMessage().contains("Syntax error")) {
                throw new BigQueryJdbcSqlSyntaxErrorException(ex);
            }
            throw new BigQueryJdbcException(ex);
        }
        JobStatistics.QueryStatistics statistics = (JobStatistics.QueryStatistics)job.getStatistics();
        return statistics.getStatementType();
    }

    SqlType getQueryType(QueryJobConfiguration jobConfiguration, JobStatistics.QueryStatistics.StatementType statementType) throws SQLException {
        this.LOG.finest("++enter++");
        if (statementType == null) {
            statementType = this.getStatementType(jobConfiguration);
        }
        SqlType sqlType = BigQuerySqlTypeConverter.getSqlTypeFromStatementType(statementType);
        this.LOG.fine(String.format("Query: %s, Statement Type: %s, SQL Type: %s", new Object[]{jobConfiguration.getQuery(), statementType, sqlType}));
        return sqlType;
    }

    JobStatistics.QueryStatistics getQueryStatistics(QueryJobConfiguration queryJobConfiguration) throws BigQueryJdbcSqlSyntaxErrorException, BigQueryJdbcException {
        this.LOG.finest("++enter++");
        QueryJobConfiguration dryRunJobConfiguration = queryJobConfiguration.toBuilder().setDryRun(true).build();
        try {
            Job job = this.bigQuery.create(JobInfo.of(dryRunJobConfiguration), new BigQuery.JobOption[0]);
            return (JobStatistics.QueryStatistics)job.getStatistics();
        }
        catch (BigQueryException ex) {
            if (ex.getMessage().contains("Syntax error")) {
                throw new BigQueryJdbcSqlSyntaxErrorException(ex);
            }
            throw new BigQueryJdbcException(ex);
        }
    }

    @Override
    public void close() throws SQLException {
        this.LOG.fine(String.format("Closing Statement %s.", this));
        if (this.isClosed()) {
            return;
        }
        boolean cancelSucceeded = false;
        try {
            this.cancel();
            cancelSucceeded = true;
        }
        catch (SQLException e) {
            this.LOG.warning(String.format("Failed to cancel statement during close().", e));
        }
        finally {
            if (!cancelSucceeded) {
                this.closeStatementResources();
            }
            this.connection = null;
            this.isClosed = true;
        }
    }

    @Override
    public int getMaxFieldSize() {
        return this.maxFieldSize;
    }

    @Override
    public void setMaxFieldSize(int max) {
        this.maxFieldSize = max;
    }

    @Override
    public int getMaxRows() {
        return this.maxRows;
    }

    @Override
    public void setMaxRows(int max) {
        this.maxRows = max;
    }

    @Override
    public void setEscapeProcessing(boolean enable) {
    }

    @Override
    public int getQueryTimeout() {
        return this.queryTimeout;
    }

    @Override
    public void setQueryTimeout(int seconds) {
        if (seconds < 0) {
            throw new IllegalArgumentException("Query Timeout should be >= 0.");
        }
        this.queryTimeout = seconds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() throws SQLException {
        this.LOG.finest(String.format("Statement %s cancelled", this));
        Object object = this.cancelLock;
        synchronized (object) {
            this.isCanceled = true;
            for (JobId jobId : this.jobIds) {
                try {
                    this.bigQuery.cancel(jobId);
                    this.LOG.info("Job " + jobId + "cancelled.");
                }
                catch (BigQueryException e) {
                    if (e.getMessage() != null && (e.getMessage().contains("Job is already in state DONE") || e.getMessage().contains("Error: 3848323"))) {
                        this.LOG.warning("Attempted to cancel a job that was already done: " + jobId);
                        continue;
                    }
                    throw new BigQueryJdbcException(e);
                }
            }
            this.jobIds.clear();
        }
        this.closeStatementResources();
    }

    @Override
    public SQLWarning getWarnings() {
        return this.warning;
    }

    @Override
    public void clearWarnings() {
        this.warning = null;
    }

    @Override
    public ResultSet getResultSet() {
        return this.currentResultSet;
    }

    @VisibleForTesting
    void setUpdateCount(long count) {
        this.currentUpdateCount = count;
    }

    @Override
    public int getUpdateCount() {
        return (int)this.currentUpdateCount;
    }

    @Override
    public long getLargeUpdateCount() {
        return this.currentUpdateCount;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return this.getMoreResults(1);
    }

    private void closeStatementResources() throws SQLException {
        this.LOG.finest("++enter++");
        if (this.currentResultSet != null) {
            ResultSet tmp = this.currentResultSet;
            this.currentResultSet = null;
            tmp.close();
        }
        this.batchQueries.clear();
        this.currentUpdateCount = -1L;
        this.currentJobIdIndex = -1;
        if (this.connection != null) {
            if (this.connection.isTransactionStarted()) {
                this.connection.rollback();
            }
            this.connection.removeStatement(this);
        }
    }

    private boolean isSingularResultSet() {
        return this.currentResultSet != null && (this.parentJobId == null || this.parentJobId.getJobs().size() == 1);
    }

    private String generateJobId() {
        return JDBC_JOB_PREFIX + UUID.randomUUID().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @InternalApi
    ExecuteResult executeJob(QueryJobConfiguration jobConfiguration) throws InterruptedException, BigQueryException, BigQueryJdbcException {
        Object jobInfo;
        Object result;
        this.LOG.finest("++enter++");
        Job job = null;
        JobId jobId = JobId.newBuilder().setLocation(this.connection.getLocation()).build();
        if (this.connection.getUseStatelessQueryMode()) {
            result = this.bigQuery.queryWithTimeout(jobConfiguration, jobId, null, new BigQuery.JobOption[0]);
            if (result instanceof TableResult) {
                TableResult tableResult = (TableResult)result;
                if (tableResult.getJobId() == null) return new ExecuteResult((TableResult)result, null);
                return new ExecuteResult(tableResult, this.bigQuery.getJob(tableResult.getJobId(), new BigQuery.JobOption[0]));
            }
            if (!(result instanceof Job)) throw new BigQueryJdbcException("Unexpected result type from queryWithTimeout");
            job = (Job)result;
        } else {
            jobId = jobId.toBuilder().setJob(this.generateJobId()).build();
            jobInfo = JobInfo.newBuilder(jobConfiguration).setJobId(jobId).build();
            job = this.bigQuery.create((JobInfo)jobInfo, new BigQuery.JobOption[0]);
        }
        if (job == null) {
            throw new BigQueryJdbcException("Failed to create BQ Job.");
        }
        jobInfo = this.cancelLock;
        synchronized (jobInfo) {
            if (this.isCanceled) {
                job.cancel();
                throw new BigQueryJdbcException("Query was cancelled.");
            }
            jobId = job.getJobId();
            this.jobIds.add(jobId);
        }
        this.LOG.info("Query submitted with Job ID: " + job.getJobId().getJob());
        result = job.getQueryResults(BigQuery.QueryResultsOption.pageSize(this.querySettings.getMaxResultPerPage()));
        Object object = this.cancelLock;
        synchronized (object) {
            this.jobIds.remove(jobId);
            return new ExecuteResult((TableResult)result, job);
        }
    }

    @InternalApi
    void runQuery(String query, QueryJobConfiguration jobConfiguration) throws SQLException, InterruptedException {
        this.LOG.finest("++enter++");
        this.LOG.fine("Run Query started");
        if (this.queryTimeout > 0) {
            jobConfiguration = jobConfiguration.toBuilder().setJobTimeoutMs(Long.valueOf(this.queryTimeout) * 1000L).build();
        }
        try {
            this.resetStatementFields();
            ExecuteResult executeResult = this.executeJob(jobConfiguration);
            JobStatistics.QueryStatistics.StatementType statementType = executeResult.job == null ? this.getStatementType(jobConfiguration) : ((JobStatistics.QueryStatistics)executeResult.job.getStatistics()).getStatementType();
            SqlType queryType = this.getQueryType(jobConfiguration, statementType);
            this.handleQueryResult(query, executeResult.tableResult, queryType);
        }
        catch (InterruptedException ex) {
            throw new BigQueryJdbcRuntimeException(ex);
        }
        catch (BigQueryException ex) {
            if (ex.getMessage().contains("Syntax error")) {
                throw new BigQueryJdbcSqlSyntaxErrorException(ex);
            }
            throw new BigQueryJdbcException(ex);
        }
    }

    private boolean isLargeResultsEnabled() {
        String destinationTable = this.querySettings.getDestinationTable();
        String destinationDataset = this.querySettings.getDestinationDataset();
        return destinationDataset != null || destinationTable != null;
    }

    private QueryJobConfiguration setDestinationDatasetAndTableInJobConfig(QueryJobConfiguration jobConfiguration) {
        String destinationTable = this.querySettings.getDestinationTable();
        String destinationDataset = this.querySettings.getDestinationDataset();
        if (destinationDataset != null || destinationTable != null) {
            if (destinationDataset != null) {
                this.checkIfDatasetExistElseCreate(destinationDataset);
            }
            if (jobConfiguration.useLegacySql().booleanValue() && destinationDataset == null) {
                this.checkIfDatasetExistElseCreate(DEFAULT_DATASET_NAME);
                destinationDataset = DEFAULT_DATASET_NAME;
            }
            if (destinationTable == null) {
                destinationTable = this.getDefaultDestinationTable();
            }
            return jobConfiguration.toBuilder().setAllowLargeResults(this.querySettings.getAllowLargeResults()).setDestinationTable(TableId.of(destinationDataset, destinationTable)).setCreateDisposition(JobInfo.CreateDisposition.CREATE_IF_NEEDED).setWriteDisposition(JobInfo.WriteDisposition.WRITE_TRUNCATE).build();
        }
        return jobConfiguration;
    }

    Job getNextJob() {
        while (this.currentJobIdIndex + 1 < this.parentJobId.getJobs().size()) {
            ++this.currentJobIdIndex;
            Job currentJob = this.parentJobId.getJobs().get(this.currentJobIdIndex);
            JobStatistics.QueryStatistics queryStatistics = (JobStatistics.QueryStatistics)currentJob.getStatistics();
            JobStatistics.ScriptStatistics scriptStatistics = queryStatistics.getScriptStatistics();
            if ("expression".equalsIgnoreCase(scriptStatistics.getEvaluationKind())) continue;
            return currentJob;
        }
        return null;
    }

    void handleQueryResult(String query, TableResult results, SqlType queryType) throws SQLException, InterruptedException {
        this.LOG.finest("++enter++");
        switch (queryType) {
            case SELECT: {
                this.processQueryResponse(query, results);
                break;
            }
            case DML: 
            case DML_EXTRA: {
                try {
                    Job completedJob = this.bigQuery.getJob(results.getJobId(), new BigQuery.JobOption[0]).waitFor(new RetryOption[0]);
                    JobStatistics.QueryStatistics statistics = (JobStatistics.QueryStatistics)completedJob.getStatistics();
                    this.updateAffectedRowCount(statistics.getNumDmlAffectedRows());
                    break;
                }
                catch (InterruptedException ex) {
                    throw new BigQueryJdbcRuntimeException(ex);
                }
                catch (NullPointerException ex) {
                    throw new BigQueryJdbcException(ex);
                }
            }
            case TCL: 
            case DDL: {
                this.updateAffectedRowCount(results.getTotalRows());
                break;
            }
            case SCRIPT: {
                try {
                    Page<Job> childJobs = this.bigQuery.listJobs(BigQuery.JobListOption.parentJobId(results.getJobId().getJob()));
                    ArrayList<Job> childJobList = new ArrayList<Job>();
                    Iterator<Job> iterableJobs = childJobs.iterateAll().iterator();
                    iterableJobs.forEachRemaining(childJobList::add);
                    Collections.reverse(childJobList);
                    this.scriptQuery = query;
                    this.parentJobId = new JobIdWrapper(results.getJobId(), results, childJobList);
                    this.currentJobIdIndex = -1;
                    Job currentJob = this.getNextJob();
                    if (currentJob == null) {
                        return;
                    }
                    JobStatistics.QueryStatistics.StatementType statementType = ((JobStatistics.QueryStatistics)currentJob.getStatistics()).getStatementType();
                    SqlType sqlType = this.getQueryType((QueryJobConfiguration)currentJob.getConfiguration(), statementType);
                    this.handleQueryResult(query, currentJob.getQueryResults(new BigQuery.QueryResultsOption[0]), sqlType);
                    break;
                }
                catch (NullPointerException ex) {
                    throw new BigQueryJdbcException(ex);
                }
            }
            case OTHER: {
                throw new BigQueryJdbcException(String.format("Unexpected value: " + (Object)((Object)queryType), new Object[0]));
            }
        }
    }

    private void updateAffectedRowCount(Long count) throws SQLException {
        if (this.currentResultSet != null) {
            try {
                this.currentResultSet.close();
                this.currentResultSet = null;
            }
            catch (SQLException ex) {
                throw new BigQueryJdbcException(ex);
            }
        }
        this.currentUpdateCount = count;
    }

    @InternalApi
    BigQueryReadClient getBigQueryReadClient() {
        if (this.bigQueryReadClient == null) {
            this.bigQueryReadClient = this.connection.getBigQueryReadClient();
        }
        return this.bigQueryReadClient;
    }

    @InternalApi
    ReadSession getReadSession(CreateReadSessionRequest readSessionRequest) {
        this.LOG.finest("++enter++");
        return this.getBigQueryReadClient().createReadSession(readSessionRequest);
    }

    @InternalApi
    ArrowSchema getArrowSchema(ReadSession readSession) {
        return readSession.getArrowSchema();
    }

    @InternalApi
    ResultSet processArrowResultSet(TableResult results) throws SQLException {
        this.LOG.finest("++enter++");
        long totalRows = this.getMaxRows() > 0 ? (long)this.getMaxRows() : results.getTotalRows();
        JobId currentJobId = results.getJobId();
        TableId destinationTable = this.getDestinationTable(currentJobId);
        Schema schema = results.getSchema();
        try {
            String parent = String.format("projects/%s", destinationTable.getProject());
            String srcTable = String.format("projects/%s/datasets/%s/tables/%s", destinationTable.getProject(), destinationTable.getDataset(), destinationTable.getTable());
            ReadSession.Builder sessionBuilder = ReadSession.newBuilder().setTable(srcTable).setDataFormat(DataFormat.ARROW);
            CreateReadSessionRequest.Builder builder = CreateReadSessionRequest.newBuilder().setParent(parent).setReadSession(sessionBuilder).setMaxStreamCount(1);
            ReadSession readSession = this.getReadSession(builder.build());
            this.arrowBatchWrapperBlockingQueue = new LinkedBlockingDeque<BigQueryArrowBatchWrapper>(this.getBufferSize());
            Thread populateBufferWorker = this.populateArrowBufferedQueue(readSession, this.arrowBatchWrapperBlockingQueue, this.bigQueryReadClient);
            BigQueryArrowResultSet arrowResultSet = BigQueryArrowResultSet.of(schema, this.getArrowSchema(readSession), totalRows, this, this.arrowBatchWrapperBlockingQueue, populateBufferWorker, this.bigQuery);
            arrowResultSetFinalizers.add(new BigQueryResultSetFinalizers.ArrowResultSetFinalizer(arrowResultSet, referenceQueueArrowRs, populateBufferWorker));
            arrowResultSet.setJobId(currentJobId);
            return arrowResultSet;
        }
        catch (Exception ex) {
            throw new BigQueryJdbcException(ex.getMessage(), ex);
        }
    }

    @InternalApi
    Thread populateArrowBufferedQueue(ReadSession readSession, BlockingQueue<BigQueryArrowBatchWrapper> arrowBatchWrapperBlockingQueue, BigQueryReadClient bqReadClient) {
        this.LOG.finest("++enter++");
        Runnable arrowStreamProcessor = () -> {
            block11: {
                String streamName = readSession.getStreams(0).getName();
                ReadRowsRequest readRowsRequest = ReadRowsRequest.newBuilder().setReadStream(streamName).build();
                ServerStream<ReadRowsResponse> stream = bqReadClient.readRowsCallable().call(readRowsRequest);
                for (ReadRowsResponse response : stream) {
                    if (Thread.currentThread().isInterrupted() || queryTaskExecutor.isShutdown()) break;
                    ArrowRecordBatch currentBatch = response.getArrowRecordBatch();
                    arrowBatchWrapperBlockingQueue.put(BigQueryArrowBatchWrapper.of(currentBatch, new boolean[0]));
                }
                try {
                    arrowBatchWrapperBlockingQueue.put(BigQueryArrowBatchWrapper.of(null, true));
                }
                catch (InterruptedException e) {
                    this.LOG.log(Level.WARNING, "\n" + Thread.currentThread().getName() + " Interrupted @ markLast", e);
                }
                break block11;
                catch (InterruptedException | RuntimeException e) {
                    try {
                        this.LOG.log(Level.WARNING, "\n" + Thread.currentThread().getName() + " Interrupted @ arrowStreamProcessor", e);
                    }
                    catch (Throwable throwable) {
                        try {
                            arrowBatchWrapperBlockingQueue.put(BigQueryArrowBatchWrapper.of(null, true));
                        }
                        catch (InterruptedException e2) {
                            this.LOG.log(Level.WARNING, "\n" + Thread.currentThread().getName() + " Interrupted @ markLast", e2);
                        }
                        throw throwable;
                    }
                    try {
                        arrowBatchWrapperBlockingQueue.put(BigQueryArrowBatchWrapper.of(null, true));
                    }
                    catch (InterruptedException e3) {
                        this.LOG.log(Level.WARNING, "\n" + Thread.currentThread().getName() + " Interrupted @ markLast", e3);
                    }
                }
            }
        };
        Thread populateBufferWorker = JDBC_THREAD_FACTORY.newThread(arrowStreamProcessor);
        populateBufferWorker.start();
        return populateBufferWorker;
    }

    void processQueryResponse(String query, TableResult results) throws SQLException {
        this.LOG.finest(String.format("API call completed{Query=%s, Parent Job ID=%s, Total rows=%s} ", query, results.getJobId(), results.getTotalRows()));
        JobId currentJobId = results.getJobId();
        if (currentJobId == null) {
            this.LOG.fine("Standard API with Stateless query used.");
            this.currentResultSet = this.processJsonResultSet(results);
        } else if (this.useReadAPI(results)) {
            this.LOG.fine("HighThroughputAPI used.");
            this.LOG.info("HTAPI job ID: " + currentJobId.getJob());
            this.currentResultSet = this.processArrowResultSet(results);
        } else {
            this.LOG.fine("Standard API used.");
            this.currentResultSet = this.processJsonResultSet(results);
        }
        this.currentUpdateCount = -1L;
    }

    @VisibleForTesting
    boolean useReadAPI(TableResult results) throws BigQueryJdbcSqlFeatureNotSupportedException {
        this.LOG.finest("++enter++");
        if (!this.meetsReadRatio(results)) {
            return false;
        }
        this.LOG.fine("Read API threshold is met.");
        return this.querySettings.getUseReadAPI();
    }

    private boolean meetsReadRatio(TableResult results) {
        this.LOG.finest("++enter++");
        long totalRows = results.getTotalRows();
        if (totalRows == 0L || totalRows < (long)this.querySettings.getHighThroughputMinTableSize()) {
            return false;
        }
        int pageSize = Iterators.size(results.getValues().iterator());
        return totalRows / (long)pageSize > (long)this.querySettings.getHighThroughputActivationRatio();
    }

    BigQueryJsonResultSet processJsonResultSet(TableResult results) {
        String jobIdOrQueryId = results.getJobId() == null ? results.getQueryId() : results.getJobId().getJob();
        this.LOG.info(String.format("BigQuery Job %s completed. Fetching results.", jobIdOrQueryId));
        ArrayList<Thread> threadList = new ArrayList<Thread>();
        Schema schema = results.getSchema();
        long totalRows = this.getMaxRows() > 0 ? (long)this.getMaxRows() : results.getTotalRows();
        this.bigQueryFieldValueListWrapperBlockingQueue = new LinkedBlockingDeque<BigQueryFieldValueListWrapper>(this.getBufferSize());
        LinkedBlockingDeque<Tuple<TableResult, Boolean>> rpcResponseQueue = new LinkedBlockingDeque<Tuple<TableResult, Boolean>>(this.getPageCacheSize(this.getBufferSize(), schema));
        JobId jobId = results.getJobId();
        if (jobId != null) {
            Thread nextPageWorker = this.runNextPageTaskAsync(results, results.getNextPageToken(), jobId, rpcResponseQueue);
            threadList.add(nextPageWorker);
        } else {
            try {
                this.populateFirstPage(results, rpcResponseQueue);
                rpcResponseQueue.put(Tuple.of(null, false));
            }
            catch (InterruptedException e) {
                this.LOG.log(Level.WARNING, "\n" + Thread.currentThread().getName() + " Interrupted @ processJsonQueryResponseResults");
            }
        }
        Thread populateBufferWorker = this.parseAndPopulateRpcDataAsync(schema, this.bigQueryFieldValueListWrapperBlockingQueue, rpcResponseQueue);
        threadList.add(populateBufferWorker);
        Thread[] jsonWorkers = threadList.toArray(new Thread[0]);
        BigQueryJsonResultSet jsonResultSet = BigQueryJsonResultSet.of(schema, totalRows, this.bigQueryFieldValueListWrapperBlockingQueue, this, jsonWorkers, this.bigQuery);
        jsonResultSet.setJobId(jobId);
        jsonResultSet.setQueryId(results.getQueryId());
        jsonResultSetFinalizers.add(new BigQueryResultSetFinalizers.JsonResultSetFinalizer(jsonResultSet, referenceQueueJsonRs, jsonWorkers));
        return jsonResultSet;
    }

    void populateFirstPage(TableResult result, BlockingQueue<Tuple<TableResult, Boolean>> rpcResponseQueue) {
        this.LOG.finest("++enter++");
        try {
            rpcResponseQueue.put(Tuple.of(result, true));
        }
        catch (InterruptedException e) {
            this.LOG.log(Level.WARNING, "\n" + Thread.currentThread().getName() + " Interrupted @ populateFirstPage");
        }
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        if (direction != 1000) {
            throw new BigQueryJdbcSqlFeatureNotSupportedException("Only FETCH_FORWARD is supported.");
        }
        this.fetchDirection = direction;
    }

    @VisibleForTesting
    Thread runNextPageTaskAsync(TableResult result, String firstPageToken, JobId jobId, BlockingQueue<Tuple<TableResult, Boolean>> rpcResponseQueue) {
        this.LOG.finest("++enter++");
        this.populateFirstPage(result, rpcResponseQueue);
        Runnable nextPageTask = () -> {
            String pageToken = firstPageToken;
            TableId destinationTable = null;
            if (firstPageToken != null) {
                destinationTable = this.getDestinationTable(jobId);
            }
            try {
                while (pageToken != null) {
                    if (Thread.currentThread().isInterrupted() || queryTaskExecutor.isShutdown()) {
                        this.LOG.log(Level.WARNING, "\n" + Thread.currentThread().getName() + " Interrupted @ runNextPageTaskAsync");
                        break;
                    }
                    long startTime = System.nanoTime();
                    TableResult results = this.bigQuery.listTableData(destinationTable, BigQuery.TableDataListOption.pageSize(this.querySettings.getMaxResultPerPage()), BigQuery.TableDataListOption.pageToken(pageToken));
                    pageToken = results.getNextPageToken();
                    rpcResponseQueue.put(Tuple.of(results, true));
                    this.LOG.fine(String.format("Fetched %d results from the server in %d ms.", this.querySettings.getMaxResultPerPage(), (int)((System.nanoTime() - startTime) / 1000000L)));
                }
                rpcResponseQueue.put(Tuple.of(null, false));
            }
            catch (Exception ex) {
                throw new BigQueryJdbcRuntimeException(ex);
            }
        };
        Thread nextPageWorker = JDBC_THREAD_FACTORY.newThread(nextPageTask);
        nextPageWorker.start();
        return nextPageWorker;
    }

    @VisibleForTesting
    Thread parseAndPopulateRpcDataAsync(Schema schema, BlockingQueue<BigQueryFieldValueListWrapper> bigQueryFieldValueListWrapperBlockingQueue, BlockingQueue<Tuple<TableResult, Boolean>> rpcResponseQueue) {
        this.LOG.finest("++enter++");
        Runnable populateBufferRunnable = () -> {
            boolean hasRows = true;
            while (hasRows) {
                Iterable<FieldValueList> fieldValueLists;
                try {
                    Tuple nextPageTuple = (Tuple)rpcResponseQueue.take();
                    fieldValueLists = nextPageTuple.x() != null ? ((TableResult)nextPageTuple.x()).getValues() : null;
                    hasRows = (Boolean)nextPageTuple.y();
                }
                catch (InterruptedException e) {
                    this.LOG.log(Level.WARNING, "\n" + Thread.currentThread().getName() + " Interrupted", e);
                    break;
                }
                if (Thread.currentThread().isInterrupted() || queryTaskExecutor.isShutdown() || fieldValueLists == null) break;
                long startTime = System.nanoTime();
                long results = 0L;
                for (FieldValueList fieldValueList : fieldValueLists) {
                    try {
                        if (Thread.currentThread().isInterrupted() || queryTaskExecutor.isShutdown()) break;
                        bigQueryFieldValueListWrapperBlockingQueue.put(BigQueryFieldValueListWrapper.of(schema.getFields(), fieldValueList, new boolean[0]));
                        ++results;
                    }
                    catch (InterruptedException ex) {
                        throw new BigQueryJdbcRuntimeException(ex);
                    }
                }
                this.LOG.fine(String.format("Processed %d results in %d ms.", results, (int)((System.nanoTime() - startTime) / 1000000L)));
            }
            try {
                bigQueryFieldValueListWrapperBlockingQueue.put(BigQueryFieldValueListWrapper.of(null, null, true));
            }
            catch (InterruptedException e) {
                this.LOG.log(Level.WARNING, "\n" + Thread.currentThread().getName() + " Interrupted @ populateBufferAsync", e);
            }
        };
        Thread populateBufferWorker = JDBC_THREAD_FACTORY.newThread(populateBufferRunnable);
        populateBufferWorker.start();
        return populateBufferWorker;
    }

    @VisibleForTesting
    int getPageCacheSize(Integer numBufferedRows, Schema schema) {
        long numCachedRows;
        this.LOG.finest("++enter++");
        int MIN_CACHE_SIZE = 3;
        int MAX_CACHE_SIZE = 20;
        int numColumns = schema.getFields().size();
        long l = numCachedRows = numBufferedRows == null ? 0L : numBufferedRows.longValue();
        int numCachedPages = numCachedRows > 10000L ? 2 : (numColumns > 15 && numCachedRows > 5000L ? 3 : (numCachedRows < 2000L && numColumns < 15 ? 20 : 5));
        return numCachedPages < 3 ? 3 : Math.min(numCachedPages, 20);
    }

    @Override
    public int getFetchDirection() {
        return this.fetchDirection;
    }

    private int getBufferSize() {
        return this.querySettings == null || this.querySettings.getNumBufferedRows() == null || this.querySettings.getNumBufferedRows() < 10000 ? 20000 : Math.min(this.querySettings.getNumBufferedRows() * 2, 100000);
    }

    TableId getDestinationTable(JobId jobId) {
        Job job = this.bigQuery.getJob(jobId, new BigQuery.JobOption[0]);
        this.LOG.finest(String.format("Destination Table retrieved from %s", job.getJobId()));
        return ((QueryJobConfiguration)job.getConfiguration()).getDestinationTable();
    }

    QueryJobConfiguration.Builder getJobConfig(String query) {
        this.LOG.finest("++enter++");
        QueryJobConfiguration.Builder queryConfigBuilder = QueryJobConfiguration.newBuilder(query);
        if (this.querySettings.getJobTimeoutMs() > 0L) {
            queryConfigBuilder.setJobTimeoutMs(this.querySettings.getJobTimeoutMs());
        }
        if (this.querySettings.getMaxBytesBilled() > 0L) {
            queryConfigBuilder.setMaximumBytesBilled(this.querySettings.getMaxBytesBilled());
        }
        if (this.querySettings.getDefaultDataset() != null) {
            queryConfigBuilder.setDefaultDataset(this.querySettings.getDefaultDataset());
        }
        HashMap<String, String> mergedLabels = new HashMap<String, String>();
        if (this.querySettings.getLabels() != null) {
            mergedLabels.putAll(this.querySettings.getLabels());
        }
        if (this.extraLabels != null) {
            mergedLabels.putAll(this.extraLabels);
        }
        queryConfigBuilder.setLabels(mergedLabels);
        queryConfigBuilder.setUseQueryCache(this.querySettings.getUseQueryCache());
        queryConfigBuilder.setMaxResults(this.querySettings.getMaxResultPerPage());
        if (this.querySettings.getSessionInfoConnectionProperty() != null) {
            queryConfigBuilder.setConnectionProperties(ImmutableList.of(this.querySettings.getSessionInfoConnectionProperty()));
        } else {
            queryConfigBuilder.setCreateSession(this.querySettings.isEnableSession());
        }
        if (this.querySettings.getKmsKeyName() != null) {
            EncryptionConfiguration encryption = EncryptionConfiguration.newBuilder().setKmsKeyName(this.querySettings.getKmsKeyName()).build();
            queryConfigBuilder.setDestinationEncryptionConfiguration(encryption);
        }
        if (this.querySettings.getQueryProperties() != null) {
            queryConfigBuilder.setConnectionProperties(this.querySettings.getQueryProperties());
        }
        boolean useLegacy = QueryDialectType.BIG_QUERY.equals((Object)QueryDialectType.valueOf(this.querySettings.getQueryDialect()));
        queryConfigBuilder.setUseLegacySql(useLegacy);
        return queryConfigBuilder;
    }

    private void checkIfDatasetExistElseCreate(String datasetName) {
        Dataset dataset = this.bigQuery.getDataset(DatasetId.of(datasetName), new BigQuery.DatasetOption[0]);
        if (dataset == null) {
            this.LOG.info(String.format("Creating a hidden dataset: %s ", datasetName));
            DatasetInfo datasetInfo = DatasetInfo.newBuilder(datasetName).setDefaultTableLifetime(this.querySettings.getDestinationDatasetExpirationTime()).build();
            this.bigQuery.create(datasetInfo, new BigQuery.DatasetOption[0]);
        }
    }

    private String getDefaultDestinationTable() {
        String timeOfCreation = String.valueOf(Instant.now().toEpochMilli());
        String randomizedId = String.valueOf(new Random().nextInt(9999));
        return DEFAULT_TABLE_NAME + timeOfCreation + randomizedId;
    }

    @InternalApi
    JobIdWrapper insertJob(JobConfiguration jobConfiguration) throws SQLException {
        Job job;
        JobInfo jobInfo = JobInfo.of(jobConfiguration);
        this.LOG.finest("++enter++");
        try {
            job = this.bigQuery.create(jobInfo, new BigQuery.JobOption[0]);
        }
        catch (BigQueryException ex) {
            throw new BigQueryJdbcException(ex);
        }
        return new JobIdWrapper(job.getJobId(), null, null);
    }

    @Override
    public void setFetchSize(int rows) {
        this.fetchSize = rows;
    }

    @Override
    public int getFetchSize() {
        return this.fetchSize;
    }

    public Map<String, String> getExtraLabels() {
        return this.extraLabels;
    }

    public void setExtraLabels(Map<String, String> extraLabels) {
        this.extraLabels = extraLabels;
    }

    @Override
    public int getResultSetConcurrency() {
        return 1007;
    }

    ResultSet getCurrentResultSet() {
        return this.currentResultSet;
    }

    @Override
    public int getResultSetType() {
        return 1003;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        SqlType sqlType;
        if (sql == null || sql.isEmpty()) {
            return;
        }
        this.LOG.finest("++enter++");
        sql = sql.trim();
        if (!sql.endsWith(";")) {
            sql = sql + "; ";
        }
        if (!SqlType.DML.equals((Object)(sqlType = this.getQueryType(QueryJobConfiguration.newBuilder(sql).build(), null)))) {
            throw new IllegalArgumentException("addBatch currently supports DML operations.");
        }
        this.batchQueries.add(sql);
    }

    @Override
    public void clearBatch() {
        this.batchQueries.clear();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        this.LOG.finest("++enter++");
        int[] result = new int[this.batchQueries.size()];
        if (this.batchQueries.isEmpty()) {
            return result;
        }
        try {
            String combinedQueries = String.join((CharSequence)"", this.batchQueries);
            QueryJobConfiguration.Builder jobConfiguration = this.getJobConfig(combinedQueries);
            jobConfiguration.setPriority(QueryJobConfiguration.Priority.BATCH);
            this.runQuery(combinedQueries, jobConfiguration.build());
        }
        catch (InterruptedException ex) {
            throw new BigQueryJdbcRuntimeException(ex);
        }
        for (int i = 0; this.getUpdateCount() != -1 && i < this.batchQueries.size(); ++i) {
            result[i] = this.getUpdateCount();
            this.getMoreResults();
        }
        this.clearBatch();
        return result;
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    public boolean hasMoreResults() {
        if (this.parentJobId == null) {
            return false;
        }
        return this.currentJobIdIndex + 1 < this.parentJobId.getJobs().size();
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        this.LOG.finest("++enter++");
        this.checkClosed();
        if (current != 1) {
            throw new BigQueryJdbcSqlFeatureNotSupportedException("The JDBC driver only supports Statement.CLOSE_CURRENT_RESULT.");
        }
        if (this.parentJobId == null) {
            return false;
        }
        try {
            Job currentJob;
            if (this.currentResultSet != null) {
                this.currentResultSet.close();
                this.currentResultSet = null;
                if (this.isClosed) {
                    return false;
                }
            }
            if ((currentJob = this.getNextJob()) != null) {
                JobStatistics.QueryStatistics.StatementType statementType = ((JobStatistics.QueryStatistics)currentJob.getStatistics()).getStatementType();
                SqlType sqlType = this.getQueryType((QueryJobConfiguration)currentJob.getConfiguration(), statementType);
                this.handleQueryResult(this.scriptQuery, currentJob.getQueryResults(new BigQuery.QueryResultsOption[0]), sqlType);
                return sqlType == SqlType.SELECT;
            }
            this.resetStatementFields();
            return false;
        }
        catch (InterruptedException | SQLException ex) {
            throw new BigQueryJdbcRuntimeException(ex);
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        return iface.isInstance(this);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (!this.isWrapperFor(iface)) {
            throw new BigQueryJdbcException(String.format("Unable to cast Statement to %s class.", iface.getName()));
        }
        return (T)this;
    }

    @Override
    public int getResultSetHoldability() {
        return 2;
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public void setPoolable(boolean poolable) {
        this.poolable = poolable;
    }

    @Override
    public boolean isPoolable() {
        return this.poolable;
    }

    @Override
    public void closeOnCompletion() {
        this.closeOnCompletion = true;
    }

    @Override
    public boolean isCloseOnCompletion() {
        return this.closeOnCompletion;
    }

    protected void logQueryExecutionStart(String sql) {
        if (sql == null) {
            return;
        }
        String sanitizedSql = sql.trim().replaceAll("\\s+", " ");
        String truncatedSql = sanitizedSql.length() > 256 ? sanitizedSql.substring(0, 256) + "..." : sanitizedSql;
        this.LOG.info("Executing query: " + truncatedSql);
        this.LOG.info("Using query settings: " + this.querySettings.toString());
    }

    void checkClosed() throws SQLException {
        if (this.isClosed()) {
            throw new BigQueryJdbcException("This " + this.getClass().getName() + " has been closed");
        }
    }

    static {
        BigQueryDaemonPollingTask.startGcDaemonTask(referenceQueueArrowRs, referenceQueueJsonRs, arrowResultSetFinalizers, jsonResultSetFinalizers);
    }

    static enum QueryDialectType {
        SQL,
        BIG_QUERY;

    }

    static enum SqlType {
        SELECT,
        DML,
        DML_EXTRA,
        DDL,
        SCRIPT,
        TCL,
        OTHER;

    }

    static class JobIdWrapper {
        private JobId jobId;
        private TableResult firstPage;
        private ArrayList<Job> jobs;

        public JobIdWrapper(JobId jobId, TableResult firstPage, ArrayList<Job> jobs) {
            this.jobId = jobId;
            this.firstPage = firstPage;
            this.jobs = jobs;
        }

        JobId getJobId() {
            return this.jobId;
        }

        void setJobId(JobId jobId) {
            this.jobId = jobId;
        }

        TableResult getResults() {
            return this.firstPage;
        }

        void setResults(TableResult firstPage) {
            this.firstPage = firstPage;
        }

        ArrayList<Job> getJobs() {
            return this.jobs;
        }

        void setJobs(ArrayList<Job> jobs) {
            this.jobs = jobs;
        }
    }

    private class ExecuteResult {
        public final TableResult tableResult;
        public final Job job;

        ExecuteResult(TableResult tableResult, Job job) {
            this.tableResult = tableResult;
            this.job = job;
        }
    }
}

