/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.jdbc;

import com.google.api.core.InternalApi;
import com.google.cloud.bigquery.jdbc.BigQueryJdbcCustomLogger;
import java.util.concurrent.ThreadFactory;

@InternalApi
class BigQueryThreadFactory
implements ThreadFactory {
    private static final BigQueryJdbcCustomLogger LOG = new BigQueryJdbcCustomLogger(BigQueryThreadFactory.class.getName());
    private String threadPrefix;
    private int threadSerialNum = 0;

    public BigQueryThreadFactory(String threadPrefix) {
        this.threadPrefix = threadPrefix;
    }

    public BigQueryThreadFactory() {
        this.threadPrefix = "DEFAULT_POOL_";
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread t2 = new Thread(r, this.threadPrefix + ++this.threadSerialNum);
        t2.setDaemon(true);
        LOG.finest(String.format("New thread %s created.", t2.getName()));
        return t2;
    }
}

