/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.jdbc;

import com.google.api.core.InternalApi;
import com.google.cloud.bigquery.jdbc.BigQueryCoercion;
import com.google.cloud.bigquery.jdbc.BigQueryTypeCoercer;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

@InternalApi
class BigQueryTypeCoercerBuilder {
    private final Map<Class<?>, Map<Class<?>, BigQueryCoercion<?, ?>>> allCoercions = new HashMap();

    BigQueryTypeCoercerBuilder() {
    }

    BigQueryTypeCoercerBuilder registerTypeCoercion(BigQueryCoercion<?, ?> coercion) {
        Type[] typeArguments = ((ParameterizedType)coercion.getClass().getGenericInterfaces()[0]).getActualTypeArguments();
        Class sourceClass = (Class)typeArguments[0];
        Class targetClass = (Class)typeArguments[1];
        this.registerInternal(coercion, sourceClass, targetClass);
        return this;
    }

    <I, O> BigQueryTypeCoercerBuilder registerTypeCoercion(Function<I, O> function, Class<I> sourceClass, Class<O> targetClass) {
        this.registerInternal(function::apply, sourceClass, targetClass);
        return this;
    }

    BigQueryTypeCoercer build() {
        return new BigQueryTypeCoercer(this.allCoercions);
    }

    private void registerInternal(BigQueryCoercion<?, ?> coercion, Class<?> sourceClass, Class<?> targetClass) {
        Map mapBySource = this.allCoercions.getOrDefault(sourceClass, new HashMap());
        mapBySource.put(targetClass, coercion);
        this.allCoercions.putIfAbsent(sourceClass, mapBySource);
    }
}

