/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.jdbc;

import com.google.api.core.InternalApi;
import com.google.cloud.bigquery.FieldValue;
import com.google.cloud.bigquery.Range;
import com.google.cloud.bigquery.jdbc.BigQueryCoercion;
import com.google.cloud.bigquery.jdbc.BigQueryTypeCoercer;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Period;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoUnit;
import java.util.Base64;
import java.util.concurrent.TimeUnit;
import org.apache.arrow.vector.PeriodDuration;
import org.apache.arrow.vector.util.Text;

@InternalApi
class BigQueryTypeCoercionUtility {
    static BigQueryTypeCoercer INSTANCE = BigQueryTypeCoercer.builder().registerTypeCoercion(new FieldValueToString()).registerTypeCoercion(new FieldValueToInteger()).registerTypeCoercion(new FieldValueToFloat()).registerTypeCoercion(new FieldValueToShort()).registerTypeCoercion(new FieldValueToLong()).registerTypeCoercion(new FieldValueToDouble()).registerTypeCoercion(new FieldValueToBigDecimal()).registerTypeCoercion(new FieldValueToBoolean()).registerTypeCoercion(new FieldValueToBytesArray()).registerTypeCoercion(new FieldValueToTimestamp()).registerTypeCoercion(new FieldValueToTime()).registerTypeCoercion(new FieldValueToDate()).registerTypeCoercion(new FieldValueToObject()).registerTypeCoercion(new StringToBytesArray()).registerTypeCoercion(new RangeToString()).registerTypeCoercion(new IntegerToLong()).registerTypeCoercion(new BytesArrayToString()).registerTypeCoercion(Timestamp::valueOf, LocalDateTime.class, Timestamp.class).registerTypeCoercion(Text::toString, Text.class, String.class).registerTypeCoercion(new TextToInteger()).registerTypeCoercion(new LongToTimestamp()).registerTypeCoercion(new LongToTime()).registerTypeCoercion(new IntegerToDate()).registerTypeCoercion(ts -> Date.valueOf(ts.toLocalDateTime().toLocalDate()), Timestamp.class, Date.class).registerTypeCoercion(ts -> Time.valueOf(ts.toLocalDateTime().toLocalTime()), Timestamp.class, Time.class).registerTypeCoercion(time -> Timestamp.valueOf(LocalDateTime.of(LocalDate.ofEpochDay(0L), time.toLocalTime())), Time.class, Timestamp.class).registerTypeCoercion(date -> new Timestamp(date.getTime()), Date.class, Timestamp.class).registerTypeCoercion(new TimestampToString()).registerTypeCoercion(new TimeToString()).registerTypeCoercion(l -> l != 0L, Long.class, Boolean.class).registerTypeCoercion(d -> d != 0.0, Double.class, Boolean.class).registerTypeCoercion(bd -> bd.compareTo(BigDecimal.ZERO) != 0, BigDecimal.class, Boolean.class).registerTypeCoercion(i -> i != 0, Integer.class, Boolean.class).registerTypeCoercion(f -> f.floatValue() != 0.0f, Float.class, Boolean.class).registerTypeCoercion(s2 -> s2 != 0, Short.class, Boolean.class).registerTypeCoercion(b -> b != false ? 1L : 0L, Boolean.class, Long.class).registerTypeCoercion(b -> b != false ? 1.0 : 0.0, Boolean.class, Double.class).registerTypeCoercion(b -> Float.valueOf(b != false ? 1.0f : 0.0f), Boolean.class, Float.class).registerTypeCoercion(b -> (short)(b != false ? 1 : 0), Boolean.class, Short.class).registerTypeCoercion(b -> (byte)(b != false ? 1 : 0), Boolean.class, Byte.class).registerTypeCoercion(b -> b != false ? BigDecimal.ONE : BigDecimal.ZERO, Boolean.class, BigDecimal.class).registerTypeCoercion(new PeriodDurationToString()).registerTypeCoercion(unused -> (byte)0, Void.class, Byte.class).registerTypeCoercion(unused -> 0, Void.class, Integer.class).registerTypeCoercion(unused -> 0L, Void.class, Long.class).registerTypeCoercion(unused -> 0.0, Void.class, Double.class).registerTypeCoercion(unused -> Float.valueOf(0.0f), Void.class, Float.class).registerTypeCoercion(unused -> (short)0, Void.class, Short.class).build();

    BigQueryTypeCoercionUtility() {
    }

    private static class RangeToString
    implements BigQueryCoercion<Range, String> {
        private RangeToString() {
        }

        @Override
        public String coerce(Range value) {
            FieldValue startValue = value.getStart();
            FieldValue endValue = value.getEnd();
            String start = startValue.isNull() ? "UNBOUNDED" : startValue.getStringValue();
            String end = endValue.isNull() ? "UNBOUNDED" : endValue.getStringValue();
            return String.format("[%s, %s)", start, end);
        }
    }

    private static class IntegerToLong
    implements BigQueryCoercion<Integer, Long> {
        private IntegerToLong() {
        }

        @Override
        public Long coerce(Integer intValue) {
            if (intValue == null) {
                return 0L;
            }
            return (long)intValue;
        }
    }

    private static class FieldValueToString
    implements BigQueryCoercion<FieldValue, String> {
        private FieldValueToString() {
        }

        @Override
        public String coerce(FieldValue fieldValue) {
            if (FieldValue.Attribute.REPEATED.equals((Object)fieldValue.getAttribute())) {
                return fieldValue.getValue().toString();
            }
            if (FieldValue.Attribute.RANGE.equals((Object)fieldValue.getAttribute())) {
                Range rangeValue = fieldValue.getRangeValue();
                return INSTANCE.coerceTo(String.class, rangeValue);
            }
            if (FieldValue.Attribute.RECORD.equals((Object)fieldValue.getAttribute())) {
                return fieldValue.getRecordValue().toString();
            }
            return fieldValue.getStringValue();
        }
    }

    private static class FieldValueToShort
    implements BigQueryCoercion<FieldValue, Short> {
        private FieldValueToShort() {
        }

        @Override
        public Short coerce(FieldValue fieldValue) {
            return (short)fieldValue.getLongValue();
        }
    }

    private static class FieldValueToFloat
    implements BigQueryCoercion<FieldValue, Float> {
        private FieldValueToFloat() {
        }

        @Override
        public Float coerce(FieldValue fieldValue) {
            return Float.valueOf((float)fieldValue.getDoubleValue());
        }
    }

    private static class FieldValueToInteger
    implements BigQueryCoercion<FieldValue, Integer> {
        private FieldValueToInteger() {
        }

        @Override
        public Integer coerce(FieldValue fieldValue) {
            return (int)fieldValue.getLongValue();
        }
    }

    private static class FieldValueToLong
    implements BigQueryCoercion<FieldValue, Long> {
        private FieldValueToLong() {
        }

        @Override
        public Long coerce(FieldValue fieldValue) {
            return fieldValue.getLongValue();
        }
    }

    private static class FieldValueToDouble
    implements BigQueryCoercion<FieldValue, Double> {
        private FieldValueToDouble() {
        }

        @Override
        public Double coerce(FieldValue fieldValue) {
            return fieldValue.getDoubleValue();
        }
    }

    private static class FieldValueToBigDecimal
    implements BigQueryCoercion<FieldValue, BigDecimal> {
        private FieldValueToBigDecimal() {
        }

        @Override
        public BigDecimal coerce(FieldValue fieldValue) {
            return fieldValue.getNumericValue();
        }
    }

    private static class FieldValueToBoolean
    implements BigQueryCoercion<FieldValue, Boolean> {
        private FieldValueToBoolean() {
        }

        @Override
        public Boolean coerce(FieldValue fieldValue) {
            return !fieldValue.isNull() && fieldValue.getBooleanValue();
        }
    }

    private static class BytesArrayToString
    implements BigQueryCoercion<byte[], String> {
        private BytesArrayToString() {
        }

        @Override
        public String coerce(byte[] value) {
            return Base64.getEncoder().encodeToString(value);
        }
    }

    private static class StringToBytesArray
    implements BigQueryCoercion<String, byte[]> {
        private StringToBytesArray() {
        }

        @Override
        public byte[] coerce(String value) {
            return value.getBytes();
        }
    }

    private static class FieldValueToBytesArray
    implements BigQueryCoercion<FieldValue, byte[]> {
        private FieldValueToBytesArray() {
        }

        @Override
        public byte[] coerce(FieldValue fieldValue) {
            return fieldValue.getBytesValue();
        }
    }

    private static class FieldValueToTimestamp
    implements BigQueryCoercion<FieldValue, Timestamp> {
        private FieldValueToTimestamp() {
        }

        @Override
        public Timestamp coerce(FieldValue fieldValue) {
            String rawValue = fieldValue.getStringValue();
            if (rawValue.contains("T")) {
                return Timestamp.valueOf(rawValue.replace('T', ' '));
            }
            long microseconds = fieldValue.getTimestampValue();
            Instant instant = Instant.EPOCH.plus(microseconds, ChronoUnit.MICROS);
            LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, ZoneId.of("UTC"));
            return Timestamp.valueOf(localDateTime);
        }
    }

    private static class FieldValueToTime
    implements BigQueryCoercion<FieldValue, Time> {
        private FieldValueToTime() {
        }

        @Override
        public Time coerce(FieldValue fieldValue) {
            String strTime = fieldValue.getStringValue();
            try {
                LocalTime localTime = LocalTime.parse(strTime);
                long millis = TimeUnit.NANOSECONDS.toMillis(localTime.toNanoOfDay());
                return new Time(millis);
            }
            catch (DateTimeParseException e) {
                throw new IllegalArgumentException("Cannot parse the value " + strTime + " to java.sql.Time", e);
            }
        }
    }

    private static class FieldValueToDate
    implements BigQueryCoercion<FieldValue, Date> {
        private FieldValueToDate() {
        }

        @Override
        public Date coerce(FieldValue fieldValue) {
            return Date.valueOf(fieldValue.getStringValue());
        }
    }

    private static class FieldValueToObject
    implements BigQueryCoercion<FieldValue, Object> {
        private FieldValueToObject() {
        }

        @Override
        public Object coerce(FieldValue fieldValue) {
            return fieldValue.getValue();
        }
    }

    private static class TextToInteger
    implements BigQueryCoercion<Text, Integer> {
        private TextToInteger() {
        }

        @Override
        public Integer coerce(Text value) {
            return Integer.parseInt(value.toString());
        }
    }

    private static class LongToTimestamp
    implements BigQueryCoercion<Long, Timestamp> {
        private LongToTimestamp() {
        }

        @Override
        public Timestamp coerce(Long value) {
            Instant instant = Instant.ofEpochMilli(value / 1000L).plusNanos(value % 1000L * 1000L);
            LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, ZoneId.of("UTC"));
            return Timestamp.valueOf(localDateTime);
        }
    }

    private static class LongToTime
    implements BigQueryCoercion<Long, Time> {
        private LongToTime() {
        }

        @Override
        public Time coerce(Long value) {
            int HH = (int)TimeUnit.MICROSECONDS.toHours(value);
            int MM = (int)(TimeUnit.MICROSECONDS.toMinutes(value) % 60L);
            int SS = (int)(TimeUnit.MICROSECONDS.toSeconds(value) % 60L);
            return new Time(HH, MM, SS);
        }
    }

    private static class IntegerToDate
    implements BigQueryCoercion<Integer, Date> {
        private IntegerToDate() {
        }

        @Override
        public Date coerce(Integer value) {
            LocalDate date = LocalDate.ofEpochDay(value.intValue());
            return Date.valueOf(date);
        }
    }

    private static class PeriodDurationToString
    implements BigQueryCoercion<PeriodDuration, String> {
        private PeriodDurationToString() {
        }

        @Override
        public String coerce(PeriodDuration value) {
            StringBuilder builder = new StringBuilder();
            Period period = value.getPeriod().normalized();
            builder.append(period.getYears()).append("-").append(period.getMonths()).append(" ").append(period.getDays()).append(" ");
            Duration duration = value.getDuration();
            if (duration.isNegative()) {
                builder.append("-");
                duration = duration.negated();
            }
            long hours = duration.toHours();
            duration = duration.minusHours(hours);
            long minutes = duration.toMinutes();
            duration = duration.minusMinutes(minutes);
            long seconds = duration.getSeconds();
            duration = duration.minusSeconds(seconds);
            long microseconds = duration.toNanos() / 1000L;
            builder.append(hours).append(":").append(minutes).append(":").append(seconds).append(".").append(microseconds);
            String result = builder.toString();
            result = result.replaceFirst("--", "-");
            return result;
        }
    }

    private static class TimeToString
    implements BigQueryCoercion<Time, String> {
        private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("HH:mm:ss.SSS");

        private TimeToString() {
        }

        @Override
        public String coerce(Time value) {
            return FORMATTER.format(value.toLocalTime());
        }
    }

    private static class TimestampToString
    implements BigQueryCoercion<Timestamp, String> {
        private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSSSSS");

        private TimestampToString() {
        }

        @Override
        public String coerce(Timestamp value) {
            return FORMATTER.format(value.toLocalDateTime());
        }
    }
}

