/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.jdbc;

import com.google.cloud.bigquery.exception.BigQueryJdbcException;
import com.google.cloud.bigquery.jdbc.BigQueryDriver;
import com.google.cloud.bigquery.jdbc.BigQueryJdbcCustomLogger;
import com.google.cloud.bigquery.jdbc.BigQueryJdbcRootLogger;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;

public class DataSource
implements javax.sql.DataSource {
    private final BigQueryJdbcCustomLogger LOG = new BigQueryJdbcCustomLogger(this.toString());
    private String URL;
    private String projectId;
    private String defaultDataset;
    private String location;
    private String userAgent;
    private Boolean enableHighThroughputAPI;
    private Integer highThroughputMinTableSize;
    private Integer highThroughputActivationRatio;
    private Boolean unsupportedHTAPIFallback;
    private String kmsKeyName;
    private Map<String, String> queryProperties;
    private String logLevel;
    private Boolean enableSession;
    private String logPath;
    private Integer oAuthType;
    private String oAuthServiceAcctEmail;
    private String oAuthPvtKeyPath;
    private String oAuthPvtKey;
    private String oAuthAccessToken;
    private String oAuthRefreshToken;
    private Boolean useQueryCache;
    private String queryDialect;
    private Boolean allowLargeResults;
    private String destinationTable;
    private String destinationDataset;
    private Long destinationDatasetExpirationTime;
    private String universeDomain;
    private String proxyHost;
    private String proxyPort;
    private String proxyUid;
    private String proxyPwd;
    private String oAuthClientId;
    private String oAuthClientSecret;
    private Integer jobCreationMode;
    private Long maxResults;
    private String partnerToken;
    private Boolean enableWriteAPI;
    private String additionalProjects;
    private Boolean filterTablesOnDefaultDataset;
    private Integer requestGoogleDriveScope;
    private Integer metadataFetchThreadCount;
    private String sslTrustStorePath;
    private String sslTrustStorePassword;

    @Override
    public Connection getConnection() throws SQLException {
        if (this.getURL() == null) {
            throw new BigQueryJdbcException("Connection URL is null. Please specify a valid Connection URL to get Connection.");
        }
        if (!BigQueryDriver.getRegisteredDriver().acceptsURL(this.getURL())) {
            throw new BigQueryJdbcException("The URL " + this.getURL() + " is invalid. Please specify a valid Connection URL. ");
        }
        return DriverManager.getConnection(this.getURL(), this.createProperties());
    }

    private Properties createProperties() {
        Properties connectionProperties = new Properties();
        if (this.projectId != null) {
            connectionProperties.setProperty("ProjectId", this.projectId);
        }
        if (this.defaultDataset != null) {
            connectionProperties.setProperty("DefaultDataset", this.defaultDataset);
        }
        if (this.location != null) {
            connectionProperties.setProperty("Location", this.location);
        }
        if (this.enableHighThroughputAPI != null) {
            connectionProperties.setProperty("EnableHighThroughputAPI", String.valueOf(this.enableHighThroughputAPI));
        }
        if (this.unsupportedHTAPIFallback != null) {
            connectionProperties.setProperty("UnsupportedHTAPIFallback", String.valueOf(this.unsupportedHTAPIFallback));
        }
        if (this.highThroughputMinTableSize != null) {
            connectionProperties.setProperty("HighThroughputMinTableSize", String.valueOf(this.highThroughputMinTableSize));
        }
        if (this.highThroughputActivationRatio != null) {
            connectionProperties.setProperty("HighThroughputActivationRatio", String.valueOf(this.highThroughputActivationRatio));
        }
        if (this.kmsKeyName != null) {
            connectionProperties.setProperty("KMSKeyName", this.kmsKeyName);
        }
        if (this.queryProperties != null) {
            connectionProperties.setProperty("QueryProperties", this.queryProperties.toString());
        }
        if (this.enableSession != null) {
            connectionProperties.setProperty("EnableSession", String.valueOf(this.enableSession));
        }
        if (this.logLevel != null) {
            connectionProperties.setProperty("LogLevel", this.logLevel);
        }
        if (this.logPath != null) {
            connectionProperties.setProperty("LogPath", this.logPath);
        }
        if (this.oAuthType != null) {
            connectionProperties.setProperty("OAuthType", String.valueOf(this.oAuthType));
        }
        if (this.oAuthServiceAcctEmail != null) {
            connectionProperties.setProperty("OAuthServiceAcctEmail", this.oAuthServiceAcctEmail);
        }
        if (this.oAuthPvtKeyPath != null) {
            connectionProperties.setProperty("OAuthPvtKeyPath", this.oAuthPvtKeyPath);
        }
        if (this.oAuthPvtKey != null) {
            connectionProperties.setProperty("OAuthPvtKey", this.oAuthPvtKey);
        }
        if (this.oAuthAccessToken != null) {
            connectionProperties.setProperty("OAuthAccessToken", this.oAuthAccessToken);
        }
        if (this.oAuthRefreshToken != null) {
            connectionProperties.setProperty("OAuthRefreshToken", this.oAuthRefreshToken);
        }
        if (this.useQueryCache != null) {
            connectionProperties.setProperty("UseQueryCache", String.valueOf(this.useQueryCache));
        }
        if (this.queryDialect != null) {
            connectionProperties.setProperty("QueryDialect", this.queryDialect);
        }
        if (this.allowLargeResults != null) {
            connectionProperties.setProperty("AllowLargeResults", String.valueOf(this.allowLargeResults));
        }
        if (this.destinationTable != null) {
            connectionProperties.setProperty("LargeResultTable", this.destinationTable);
        }
        if (this.destinationDataset != null) {
            connectionProperties.setProperty("LargeResultDataset", this.destinationDataset);
        }
        if (this.destinationDatasetExpirationTime != null) {
            connectionProperties.setProperty("LargeResultsDatasetExpirationTime", String.valueOf(this.destinationDatasetExpirationTime));
        }
        if (this.universeDomain != null) {
            connectionProperties.setProperty("universeDomain", this.universeDomain);
        }
        if (this.proxyHost != null) {
            connectionProperties.setProperty("ProxyHost", this.proxyHost);
        }
        if (this.proxyPort != null) {
            connectionProperties.setProperty("ProxyPort", this.proxyPort);
        }
        if (this.proxyUid != null) {
            connectionProperties.setProperty("ProxyUid", this.proxyUid);
        }
        if (this.proxyPwd != null) {
            connectionProperties.setProperty("ProxyPwd", this.proxyPwd);
        }
        if (this.oAuthClientId != null) {
            connectionProperties.setProperty("OAuthClientId", this.oAuthClientId);
        }
        if (this.oAuthClientSecret != null) {
            connectionProperties.setProperty("OAuthClientSecret", this.oAuthClientSecret);
        }
        if (this.jobCreationMode != null) {
            connectionProperties.setProperty("JobCreationMode", String.valueOf(this.jobCreationMode));
        }
        if (this.maxResults != null) {
            connectionProperties.setProperty("MaxResults", String.valueOf(this.maxResults));
        }
        if (this.partnerToken != null && !this.partnerToken.isEmpty()) {
            connectionProperties.setProperty("PartnerToken", this.partnerToken);
        }
        if (this.enableWriteAPI != null) {
            connectionProperties.setProperty("EnableWriteAPI", String.valueOf(this.enableWriteAPI));
        }
        if (this.additionalProjects != null) {
            connectionProperties.setProperty("AdditionalProjects", this.additionalProjects);
        }
        if (this.filterTablesOnDefaultDataset != null) {
            connectionProperties.setProperty("FilterTablesOnDefaultDataset", String.valueOf(this.filterTablesOnDefaultDataset));
        }
        if (this.requestGoogleDriveScope != null) {
            connectionProperties.setProperty("RequestGoogleDriveScope", String.valueOf(this.requestGoogleDriveScope));
        }
        if (this.metadataFetchThreadCount != null) {
            connectionProperties.setProperty("MetaDataFetchThreadCount", String.valueOf(this.metadataFetchThreadCount));
        }
        if (this.sslTrustStorePath != null) {
            connectionProperties.setProperty("SSLTrustStore", String.valueOf(this.sslTrustStorePath));
        }
        if (this.sslTrustStorePassword != null) {
            connectionProperties.setProperty("SSLTrustStorePwd", String.valueOf(this.sslTrustStorePassword));
        }
        return connectionProperties;
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        this.LOG.warning("Username and Password is not supported in Bigquery JDBC Driver. Values discarded.");
        return this.getConnection();
    }

    public String getURL() {
        return this.URL;
    }

    public void setURL(String URL2) {
        this.URL = URL2;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public String getDefaultDataset() {
        return this.defaultDataset;
    }

    public void setDefaultDataset(String defaultDataset) {
        this.defaultDataset = defaultDataset;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public String getPartnerToken() {
        return this.partnerToken;
    }

    public void setPartnerToken(String partnerToken) {
        this.partnerToken = partnerToken;
    }

    public boolean getEnableHighThroughputAPI() {
        return this.enableHighThroughputAPI;
    }

    public void setEnableHighThroughputAPI(Boolean enableHighThroughputAPI) {
        this.enableHighThroughputAPI = enableHighThroughputAPI;
    }

    public int getHighThroughputMinTableSize() {
        return this.highThroughputMinTableSize;
    }

    public int getHighThroughputActivationRatio() {
        return this.highThroughputActivationRatio;
    }

    public void setHighThroughputMinTableSize(Integer highThroughputMinTableSize) {
        this.highThroughputMinTableSize = highThroughputMinTableSize;
    }

    public void setHighThroughputActivationRatio(Integer highThroughputActivationRatio) {
        this.highThroughputActivationRatio = highThroughputActivationRatio;
    }

    public void setKmsKeyName(String kmsKeyName) {
        this.kmsKeyName = kmsKeyName;
    }

    public String getKmsKeyName() {
        return this.kmsKeyName;
    }

    public void setQueryProperties(Map<String, String> queryProperties) {
        this.queryProperties = queryProperties;
    }

    public Map<String, String> getQueryProperties() {
        return this.queryProperties;
    }

    public void setUnsupportedHTAPIFallback(Boolean unsupportedHTAPIFallback) {
        this.unsupportedHTAPIFallback = unsupportedHTAPIFallback;
    }

    public boolean getUnsupportedHTAPIFallback() {
        return this.unsupportedHTAPIFallback;
    }

    public boolean getEnableSession() {
        return this.enableSession;
    }

    public void setEnableSession(Boolean enableSession) {
        this.enableSession = enableSession;
    }

    public String getLogLevel() {
        return this.logLevel;
    }

    public void setLogLevel(String logLevel) {
        this.logLevel = logLevel;
    }

    public String getLogPath() {
        return this.logPath;
    }

    public void setLogPath(String logPath) {
        this.logPath = logPath;
    }

    public String getUniverseDomain() {
        return this.universeDomain;
    }

    public void setUniverseDomain(String universeDomain) {
        this.universeDomain = universeDomain;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public String getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(String proxyPort) {
        this.proxyPort = proxyPort;
    }

    public String getProxyUid() {
        return this.proxyUid;
    }

    public void setProxyUid(String proxyUid) {
        this.proxyUid = proxyUid;
    }

    public String getProxyPwd() {
        return this.proxyPwd;
    }

    public void setProxyPwd(String proxyPwd) {
        this.proxyPwd = proxyPwd;
    }

    public int getOAuthType() {
        return this.oAuthType;
    }

    public void setOAuthType(Integer oAuthType) {
        this.oAuthType = oAuthType;
    }

    public String getOAuthServiceAcctEmail() {
        return this.oAuthServiceAcctEmail;
    }

    public void setOAuthServiceAcctEmail(String oAuthServiceAcctEmail) {
        this.oAuthServiceAcctEmail = oAuthServiceAcctEmail;
    }

    public String getOAuthPvtKeyPath() {
        return this.oAuthPvtKeyPath;
    }

    public String getOAuthPvtKey() {
        return this.oAuthPvtKey;
    }

    public void setOAuthPvtKey(String oAuthPvtKey) {
        this.oAuthPvtKey = oAuthPvtKey;
    }

    public void setOAuthPvtKeyPath(String oAuthPvtKeyPath) {
        this.oAuthPvtKeyPath = oAuthPvtKeyPath;
    }

    public String getOAuthAccessToken() {
        return this.oAuthAccessToken;
    }

    public void setOAuthAccessToken(String oAuthAccessToken) {
        this.oAuthAccessToken = oAuthAccessToken;
    }

    public String getOAuthRefreshToken() {
        return this.oAuthRefreshToken;
    }

    public void setOAuthRefreshToken(String oAuthRefreshToken) {
        this.oAuthRefreshToken = oAuthRefreshToken;
    }

    public Boolean getUseQueryCache() {
        return this.useQueryCache;
    }

    public String getQueryDialect() {
        return this.queryDialect;
    }

    public Boolean getAllowLargeResults() {
        return this.allowLargeResults;
    }

    public String getDestinationTable() {
        return this.destinationTable;
    }

    public String getDestinationDataset() {
        return this.destinationDataset;
    }

    public Long getDestinationDatasetExpirationTime() {
        return this.destinationDatasetExpirationTime;
    }

    public void setUseQueryCache(Boolean useQueryCache) {
        this.useQueryCache = useQueryCache;
    }

    public void setQueryDialect(String queryDialect) {
        this.queryDialect = queryDialect;
    }

    public void setAllowLargeResults(Boolean allowLargeResults) {
        this.allowLargeResults = allowLargeResults;
    }

    public void setDestinationTable(String destinationTable) {
        this.destinationTable = destinationTable;
    }

    public void setDestinationDataset(String destinationDataset) {
        this.destinationDataset = destinationDataset;
    }

    public void setDestinationDatasetExpirationTime(long destinationDatasetExpirationTime) {
        this.destinationDatasetExpirationTime = destinationDatasetExpirationTime;
    }

    public String getOAuthClientId() {
        return this.oAuthClientId;
    }

    public void setOAuthClientId(String oAuthClientId) {
        this.oAuthClientId = oAuthClientId;
    }

    public String getOAuthClientSecret() {
        return this.oAuthClientSecret;
    }

    public void setOAuthClientSecret(String oAuthClientSecret) {
        this.oAuthClientSecret = oAuthClientSecret;
    }

    public Integer getJobCreationMode() {
        return this.jobCreationMode;
    }

    public void setJobCreationMode(Integer jobCreationMode) {
        this.jobCreationMode = jobCreationMode;
    }

    public Boolean getEnableWriteAPI() {
        return this.enableWriteAPI;
    }

    public void setEnableWriteAPI(Boolean enableWriteAPI) {
        this.enableWriteAPI = enableWriteAPI;
    }

    public String getAdditionalProjects() {
        return this.additionalProjects;
    }

    public void setAdditionalProjects(String additionalProjects) {
        this.additionalProjects = additionalProjects;
    }

    public Boolean getFilterTablesOnDefaultDataset() {
        return this.filterTablesOnDefaultDataset;
    }

    public void setFilterTablesOnDefaultDataset(Boolean filterTablesOnDefaultDataset) {
        this.filterTablesOnDefaultDataset = filterTablesOnDefaultDataset;
    }

    public Integer getRequestGoogleDriveScope() {
        return this.requestGoogleDriveScope;
    }

    public void setRequestGoogleDriveScope(Integer requestGoogleDriveScope) {
        this.requestGoogleDriveScope = requestGoogleDriveScope;
    }

    public Integer getMetadataFetchThreadCount() {
        return this.metadataFetchThreadCount;
    }

    public void setMetadataFetchThreadCount(Integer metadataFetchThreadCount) {
        this.metadataFetchThreadCount = metadataFetchThreadCount;
    }

    public String getSSLTrustStorePath() {
        return this.sslTrustStorePath;
    }

    public void setSSLTrustStorePath(String sslTrustStorePath) {
        this.sslTrustStorePath = sslTrustStorePath;
    }

    public String getSSLTrustStorePassword() {
        return this.sslTrustStorePassword;
    }

    public void setSSLTrustStorePassword(String sslTrustStorePassword) {
        this.sslTrustStorePassword = sslTrustStorePassword;
    }

    @Override
    public PrintWriter getLogWriter() {
        return null;
    }

    @Override
    public void setLogWriter(PrintWriter out) {
    }

    @Override
    public void setLoginTimeout(int seconds) {
    }

    @Override
    public int getLoginTimeout() {
        return 0;
    }

    @Override
    public Logger getParentLogger() {
        return BigQueryJdbcRootLogger.getRootLogger();
    }

    @Override
    public <T> T unwrap(Class<T> iface) {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        return false;
    }

    static {
        try {
            Class.forName("com.google.cloud.bigquery.jdbc.BigQueryDriver");
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalStateException("DataSource failed to load com.google.cloud.bigquery.jdbc.BigQueryDriver", ex);
        }
    }
}

