/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.storage.v1;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.bigquery.storage.v1.BaseBigQueryReadSettings;
import com.google.cloud.bigquery.storage.v1.CreateReadSessionRequest;
import com.google.cloud.bigquery.storage.v1.ProjectName;
import com.google.cloud.bigquery.storage.v1.ReadRowsRequest;
import com.google.cloud.bigquery.storage.v1.ReadRowsResponse;
import com.google.cloud.bigquery.storage.v1.ReadSession;
import com.google.cloud.bigquery.storage.v1.SplitReadStreamRequest;
import com.google.cloud.bigquery.storage.v1.SplitReadStreamResponse;
import com.google.cloud.bigquery.storage.v1.stub.BigQueryReadStub;
import com.google.cloud.bigquery.storage.v1.stub.BigQueryReadStubSettings;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class BaseBigQueryReadClient
implements BackgroundResource {
    private final BaseBigQueryReadSettings settings;
    private final BigQueryReadStub stub;

    public static final BaseBigQueryReadClient create() throws IOException {
        return BaseBigQueryReadClient.create(BaseBigQueryReadSettings.newBuilder().build());
    }

    public static final BaseBigQueryReadClient create(BaseBigQueryReadSettings settings) throws IOException {
        return new BaseBigQueryReadClient(settings);
    }

    public static final BaseBigQueryReadClient create(BigQueryReadStub stub) {
        return new BaseBigQueryReadClient(stub);
    }

    protected BaseBigQueryReadClient(BaseBigQueryReadSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((BigQueryReadStubSettings)settings.getStubSettings()).createStub();
    }

    protected BaseBigQueryReadClient(BigQueryReadStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final BaseBigQueryReadSettings getSettings() {
        return this.settings;
    }

    public BigQueryReadStub getStub() {
        return this.stub;
    }

    public final ReadSession createReadSession(ProjectName parent, ReadSession readSession, int maxStreamCount) {
        CreateReadSessionRequest request = CreateReadSessionRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setReadSession(readSession).setMaxStreamCount(maxStreamCount).build();
        return this.createReadSession(request);
    }

    public final ReadSession createReadSession(String parent, ReadSession readSession, int maxStreamCount) {
        CreateReadSessionRequest request = CreateReadSessionRequest.newBuilder().setParent(parent).setReadSession(readSession).setMaxStreamCount(maxStreamCount).build();
        return this.createReadSession(request);
    }

    public final ReadSession createReadSession(CreateReadSessionRequest request) {
        return this.createReadSessionCallable().call(request);
    }

    public final UnaryCallable<CreateReadSessionRequest, ReadSession> createReadSessionCallable() {
        return this.stub.createReadSessionCallable();
    }

    public final ServerStreamingCallable<ReadRowsRequest, ReadRowsResponse> readRowsCallable() {
        return this.stub.readRowsCallable();
    }

    public final SplitReadStreamResponse splitReadStream(SplitReadStreamRequest request) {
        return this.splitReadStreamCallable().call(request);
    }

    public final UnaryCallable<SplitReadStreamRequest, SplitReadStreamResponse> splitReadStreamCallable() {
        return this.stub.splitReadStreamCallable();
    }

    @Override
    public final void close() {
        this.stub.close();
    }

    @Override
    public void shutdown() {
        this.stub.shutdown();
    }

    @Override
    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    @Override
    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    @Override
    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

