/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.storage.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class WriteStreamName
implements ResourceName {
    private static final PathTemplate PROJECT_DATASET_TABLE_STREAM = PathTemplate.createWithoutUrlEncoding("projects/{project}/datasets/{dataset}/tables/{table}/streams/{stream}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String dataset;
    private final String table;
    private final String stream;

    @Deprecated
    protected WriteStreamName() {
        this.project = null;
        this.dataset = null;
        this.table = null;
        this.stream = null;
    }

    private WriteStreamName(Builder builder) {
        this.project = Preconditions.checkNotNull(builder.getProject());
        this.dataset = Preconditions.checkNotNull(builder.getDataset());
        this.table = Preconditions.checkNotNull(builder.getTable());
        this.stream = Preconditions.checkNotNull(builder.getStream());
    }

    public String getProject() {
        return this.project;
    }

    public String getDataset() {
        return this.dataset;
    }

    public String getTable() {
        return this.table;
    }

    public String getStream() {
        return this.stream;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static WriteStreamName of(String project, String dataset, String table, String stream) {
        return WriteStreamName.newBuilder().setProject(project).setDataset(dataset).setTable(table).setStream(stream).build();
    }

    public static String format(String project, String dataset, String table, String stream) {
        return WriteStreamName.newBuilder().setProject(project).setDataset(dataset).setTable(table).setStream(stream).build().toString();
    }

    public static WriteStreamName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map<String, String> matchMap = PROJECT_DATASET_TABLE_STREAM.validatedMatch(formattedString, "WriteStreamName.parse: formattedString not in valid format");
        return WriteStreamName.of(matchMap.get("project"), matchMap.get("dataset"), matchMap.get("table"), matchMap.get("stream"));
    }

    public static List<WriteStreamName> parseList(List<String> formattedStrings) {
        ArrayList<WriteStreamName> list = new ArrayList<WriteStreamName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(WriteStreamName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<WriteStreamName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (WriteStreamName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_DATASET_TABLE_STREAM.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            WriteStreamName writeStreamName = this;
            synchronized (writeStreamName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder<String, String> fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put("project", this.project);
                    }
                    if (this.dataset != null) {
                        fieldMapBuilder.put("dataset", this.dataset);
                    }
                    if (this.table != null) {
                        fieldMapBuilder.put("table", this.table);
                    }
                    if (this.stream != null) {
                        fieldMapBuilder.put("stream", this.stream);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    @Override
    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_DATASET_TABLE_STREAM.instantiate("project", this.project, "dataset", this.dataset, "table", this.table, "stream", this.stream);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            WriteStreamName that = (WriteStreamName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.dataset, that.dataset) && Objects.equals(this.table, that.table) && Objects.equals(this.stream, that.stream);
        }
        return false;
    }

    public int hashCode() {
        int h2 = 1;
        h2 *= 1000003;
        h2 ^= Objects.hashCode(this.project);
        h2 *= 1000003;
        h2 ^= Objects.hashCode(this.dataset);
        h2 *= 1000003;
        h2 ^= Objects.hashCode(this.table);
        h2 *= 1000003;
        return h2 ^= Objects.hashCode(this.stream);
    }

    public static class Builder {
        private String project;
        private String dataset;
        private String table;
        private String stream;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getDataset() {
            return this.dataset;
        }

        public String getTable() {
            return this.table;
        }

        public String getStream() {
            return this.stream;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setDataset(String dataset) {
            this.dataset = dataset;
            return this;
        }

        public Builder setTable(String table) {
            this.table = table;
            return this;
        }

        public Builder setStream(String stream) {
            this.stream = stream;
            return this;
        }

        private Builder(WriteStreamName writeStreamName) {
            this.project = writeStreamName.project;
            this.dataset = writeStreamName.dataset;
            this.table = writeStreamName.table;
            this.stream = writeStreamName.stream;
        }

        public WriteStreamName build() {
            return new WriteStreamName(this);
        }
    }
}

