/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.vector.complex.impl;

import java.time.Period;
import org.apache.arrow.vector.complex.impl.AbstractFieldReader;
import org.apache.arrow.vector.complex.writer.IntervalYearWriter;
import org.apache.arrow.vector.holders.IntervalYearHolder;
import org.apache.arrow.vector.holders.NullableIntervalYearHolder;
import org.apache.arrow.vector.types.Types;

public class IntervalYearHolderReaderImpl
extends AbstractFieldReader {
    private IntervalYearHolder holder;

    public IntervalYearHolderReaderImpl(IntervalYearHolder holder) {
        this.holder = holder;
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException("You can't call size on a Holder value reader.");
    }

    @Override
    public boolean next() {
        throw new UnsupportedOperationException("You can't call next on a single value reader.");
    }

    @Override
    public void setPosition(int index) {
        throw new UnsupportedOperationException("You can't call next on a single value reader.");
    }

    @Override
    public Types.MinorType getMinorType() {
        return Types.MinorType.INTERVALYEAR;
    }

    @Override
    public boolean isSet() {
        return true;
    }

    @Override
    public void read(IntervalYearHolder h2) {
        h2.value = this.holder.value;
    }

    @Override
    public void read(NullableIntervalYearHolder h2) {
        h2.value = this.holder.value;
        h2.isSet = this.isSet() ? 1 : 0;
    }

    @Override
    public Period readPeriod() {
        return Period.ofMonths(this.holder.value);
    }

    @Override
    public Object readObject() {
        return this.readPeriod();
    }

    @Override
    public void copyAsValue(IntervalYearWriter writer) {
        writer.write(this.holder);
    }
}

