#version 330 core

// Brush preview vertex shader
// Renders a circular brush indicator on the terrain
// Vertices are pre-positioned in world space with terrain-conforming heights

layout (location = 0) in vec3 aPos;       // World position (already terrain-conforming)
layout (location = 1) in vec2 aLocalPos;  // Normalized position within brush (-1 to 1)

out vec3 FragPos;
out vec2 LocalPos;      // Position relative to brush center (-1 to 1)
out vec2 WorldPosXZ;    // World position X,Z for tile grid calculation

uniform mat4 projection_view;
uniform vec3 brushCenter;    // World position of brush center
uniform float brushRadius;   // Brush radius in world units

void main()
{
    // aPos is already the world position with terrain height
    FragPos = aPos;
    LocalPos = aLocalPos;      // Normalized position within brush (-1 to 1)
    WorldPosXZ = aPos.xz;      // Pass world X,Z to fragment shader

    gl_Position = projection_view * vec4(aPos, 1.0);
}
