#version 330 core
layout (location = 0) in vec3 aPos;
layout (location = 1) in vec2 aTexCoord;
layout (location = 2) in vec3 aInstancePos;
layout (location = 3) in float aInstanceSize;
layout (location = 4) in float aInstanceAge;

uniform mat4 view;
uniform mat4 projection;
uniform vec3 cameraRight;
uniform vec3 cameraUp;
uniform float time;

out vec2 TexCoord;
out float BubbleAge;
out float BubbleSize;

void main()
{
    // Billboard the bubble to face the camera
    // Add slight squash/stretch animation based on rise
    float squash = 1.0 + sin(time * 4.0 + aInstanceAge * 10.0) * 0.1;
    float stretch = 1.0 - sin(time * 4.0 + aInstanceAge * 10.0) * 0.05;

    vec3 right = cameraRight * aPos.x * aInstanceSize * squash;
    vec3 up = cameraUp * aPos.y * aInstanceSize * stretch;

    vec3 worldPos = aInstancePos + right + up;

    gl_Position = projection * view * vec4(worldPos, 1.0);
    TexCoord = aTexCoord;
    BubbleAge = aInstanceAge;
    BubbleSize = aInstanceSize;
}
