#version 330 core

layout(location = 0) in vec3 position;
// Instance matrix (4 vec4s = mat4)
layout(location = 4) in vec4 instanceMatrix0;
layout(location = 5) in vec4 instanceMatrix1;
layout(location = 6) in vec4 instanceMatrix2;
layout(location = 7) in vec4 instanceMatrix3;

uniform mat4 lightSpaceMatrix;

void main()
{
    // Reconstruct instance model matrix from 4 vec4 columns
    mat4 instanceModel = mat4(instanceMatrix0, instanceMatrix1, instanceMatrix2, instanceMatrix3);

    vec4 worldPos = instanceModel * vec4(position, 1.0);
    gl_Position = lightSpaceMatrix * worldPos;
}
