#version 330

// Simple water fragment shader for top-down map rendering
// Just a solid blue color with slight transparency and edge fading

in highp vec2 texCoord0;
in vec3 worldPos;
in float edgeFade;

out vec4 outputColor;

uniform float waterTransparency = 0.7;

// Water color for map view (dark blue)
const vec3 waterColor = vec3(0.1, 0.3, 0.5);

// Edge fade color (matches terrain edge fade)
const vec3 fadeColor = vec3(0.1, 0.15, 0.25);

void main()
{
    float smoothFade = smoothstep(0.0, 1.0, edgeFade);
    vec3 finalColor = mix(fadeColor, waterColor, smoothFade);
    float finalAlpha = waterTransparency * smoothFade;
    outputColor = vec4(finalColor, finalAlpha);
}
