#version 330

// Simple water vertex shader for top-down map rendering

layout(location = 0) in vec3 position;
layout(location = 1) in vec3 normal;
layout(location = 2) in vec4 texCoords;

out highp vec2 texCoord0;
out vec3 worldPos;
out float edgeFade;

uniform mat4 MVP;
uniform mat4 model;
uniform float terrainWidth;
uniform float terrainHeight;
uniform float fadeDistance;

void main()
{
    vec4 worldPosition = model * vec4(position, 1.0);
    worldPos = worldPosition.xyz;

    texCoord0 = vec2(texCoords[0], texCoords[1]);

    // Calculate edge fade
    float fadeX = min(worldPos.x, terrainWidth - worldPos.x);
    float fadeZ = min(worldPos.z, terrainHeight - worldPos.z);
    float minDist = min(fadeX, fadeZ);
    edgeFade = clamp(minDist / max(fadeDistance, 1.0), 0.0, 1.0);

    gl_Position = MVP * vec4(position, 1.0);
}
