#version 330 core

layout(location = 0) in vec3 position;
layout(location = 1) in vec3 normal;
layout(location = 2) in vec4 texCoords;

out vec2 texCoord0;
out vec2 texCoord1;
out vec3 surfaceNormal;
out vec3 toLightVector;
out vec3 worldPos;
out float distFromCamera;

uniform mat4 model;
uniform mat4 view;
uniform mat4 projection;
uniform vec3 lightPosition;
uniform vec3 cameraPos;

void main()
{
    vec4 worldPosition = model * vec4(position, 1.0);

    surfaceNormal = mat3(transpose(inverse(model))) * normal;
    toLightVector = lightPosition - worldPosition.xyz;

    worldPos = worldPosition.xyz;
    distFromCamera = length(worldPos - cameraPos);

    texCoord0 = vec2(texCoords[0], texCoords[1]);
    texCoord1 = vec2(texCoords[2], texCoords[3]);

    gl_Position = projection * view * worldPosition;
}
