#version 330 core

// Simple water fragment shader for editor mode
// Bright blue base with texture overlay for clear visibility

in vec2 v_texCoord;
in float v_alpha;
in vec3 v_worldPos;
flat in uint v_isDanger;

out vec4 outputColor;

uniform sampler2D basic_texture;
uniform float time;
uniform vec3 cameraPos;
uniform float view_distance;

void main()
{
    // Sample water texture - swap BGR to RGB (Carnivores texture format)
    vec4 texSample = textureLod(basic_texture, fract(v_texCoord), 0.0);
    vec3 waterTexColor = vec3(texSample.b, texSample.g, texSample.r);

    // Handle danger water (lava) - keep distinct orange/red
    if (v_isDanger == 1u) {
        vec3 lavaColor = vec3(0.9, 0.3, 0.1);
        vec3 finalColor = mix(waterTexColor, lavaColor, 0.6);
        outputColor = vec4(finalColor, 0.85);
        return;
    }

    // Bright blue base color for editor visibility
    vec3 editorBlue = vec3(0.2, 0.5, 0.9);

    // Blend texture with editor blue (texture visible but blue tinted)
    vec3 baseColor = mix(editorBlue, waterTexColor, 0.35);

    // Simple animated ripple for liveliness
    float ripple = sin(v_worldPos.x * 0.3 + time * 1.5) * cos(v_worldPos.z * 0.3 + time * 1.2);
    baseColor += vec3(ripple * 0.05);

    // Distance fade for visibility
    float dist = length(v_worldPos - cameraPos);
    float fogFactor = clamp((dist - view_distance * 0.6) / (view_distance * 0.35), 0.0, 0.5);
    vec3 fogColor = vec3(0.7, 0.8, 0.95);
    vec3 finalColor = mix(baseColor, fogColor, fogFactor);

    // Semi-transparent for seeing terrain underneath
    outputColor = vec4(finalColor, 0.7);
}
