#version 330 core

// Simple water vertex shader for editor mode
// Renders flat water planes with minimal effects for visibility

layout(location = 0) in vec3 position;
layout(location = 1) in vec2 texCoord;
layout(location = 2) in vec3 normal;
layout(location = 3) in float alpha;
layout(location = 4) in uint flags;

out vec2 v_texCoord;
out float v_alpha;
out vec3 v_worldPos;
flat out uint v_isDanger;

uniform mat4 MVP;
uniform mat4 model;

void main()
{
    vec4 worldPosition = model * vec4(position, 1.0);
    gl_Position = MVP * worldPosition;

    v_texCoord = texCoord;
    v_alpha = alpha;
    v_worldPos = worldPosition.xyz;
    v_isDanger = flags;
}
