#version 330 core
in vec2 TexCoord;
in float Alpha;

out vec4 FragColor;

uniform sampler2D weatherTexture;

void main()
{
    vec4 texColor = texture(weatherTexture, TexCoord);

    // Output white/light color with alpha from texture and instance
    FragColor = vec4(texColor.rgb, texColor.a * Alpha);

    // Discard nearly transparent pixels for performance
    if (FragColor.a < 0.01) discard;
}
