#version 330 core
layout (location = 0) in vec3 aPos;
layout (location = 1) in vec2 aTexCoord;
layout (location = 2) in vec3 aInstancePos;
layout (location = 3) in float aInstanceSize;
layout (location = 4) in float aInstanceRotation;
layout (location = 5) in float aInstanceAlpha;

uniform mat4 view;
uniform mat4 projection;
uniform int weatherType; // 0 = rain falling, 1 = snow, 2 = splash/ground effect

out vec2 TexCoord;
out float Alpha;

void main()
{
    // Extract camera vectors for billboarding
    vec3 cameraRight = vec3(view[0][0], view[1][0], view[2][0]);
    vec3 cameraUp = vec3(view[0][1], view[1][1], view[2][1]);

    vec3 localPos = aPos;
    vec3 worldPos;

    // For rain falling: stretch vertically significantly to create long streak effect
    if (weatherType == 0) {
        localPos.y *= 8.0; // Elongate rain drops vertically (longer streaks)
        localPos.x *= 0.3; // Make them thinner horizontally

        // Billboard the particle to face the camera
        worldPos = aInstancePos +
                   (localPos.x * cameraRight + localPos.y * cameraUp) * aInstanceSize;
    }
    // For snow: apply rotation for tumbling effect
    else if (weatherType == 1) {
        float c = cos(aInstanceRotation);
        float s = sin(aInstanceRotation);
        vec2 rotated = vec2(
            localPos.x * c - localPos.y * s,
            localPos.x * s + localPos.y * c
        );
        localPos.xy = rotated;

        // Billboard the particle to face the camera
        worldPos = aInstancePos +
                   (localPos.x * cameraRight + localPos.y * cameraUp) * aInstanceSize;
    }
    // For splash/ground effects: render flat on ground (XZ plane)
    else {
        // Render flat on the ground - natural splash appearance
        // localPos.x -> world X, localPos.y -> world Z, Y stays at instance height
        worldPos = aInstancePos + vec3(localPos.x * aInstanceSize, 0.0, localPos.y * aInstanceSize);
    }

    gl_Position = projection * view * vec4(worldPos, 1.0);
    TexCoord = aTexCoord;
    Alpha = aInstanceAlpha;
}
