#version 330 core

in vec2 TexCoord;
in float BubbleAge;
in float BubbleSize;

out vec4 FragColor;

void main()
{
    // Calculate distance from center for circular bubble shape
    vec2 center = TexCoord - vec2(0.5);
    float dist = length(center);

    // Discard pixels outside the bubble
    if (dist > 0.5) {
        discard;
    }

    // Bubble color - light blue-white with transparency
    // Fresnel-like effect: edges are more opaque than center
    float edgeFactor = smoothstep(0.0, 0.5, dist);

    // Base bubble color (light cyan/white)
    vec3 bubbleColor = vec3(0.85, 0.95, 1.0);

    // Highlight on upper-left for 3D effect
    vec2 highlightOffset = center - vec2(-0.15, 0.15);
    float highlightDist = length(highlightOffset);
    float highlight = 1.0 - smoothstep(0.0, 0.25, highlightDist);
    bubbleColor += vec3(0.15) * highlight;

    // Secondary smaller highlight for extra shininess
    vec2 highlight2Offset = center - vec2(-0.25, 0.2);
    float highlight2Dist = length(highlight2Offset);
    float highlight2 = 1.0 - smoothstep(0.0, 0.1, highlight2Dist);
    bubbleColor += vec3(0.2) * highlight2;

    // Edge darkening for depth
    float edgeDarken = 1.0 - edgeFactor * 0.3;
    bubbleColor *= edgeDarken;

    // Alpha: transparent center, more opaque edges (bubble membrane effect)
    // Smaller bubbles are slightly more opaque
    float sizeOpacityBoost = (1.5 - BubbleSize) * 0.1;
    float alpha = 0.15 + edgeFactor * 0.45 + sizeOpacityBoost;

    // Soft edge falloff
    float softEdge = 1.0 - smoothstep(0.4, 0.5, dist);
    alpha *= softEdge;

    // Clamp alpha
    alpha = clamp(alpha, 0.0, 0.7);

    FragColor = vec4(bubbleColor, alpha);
}
