#version 330 core

layout(location = 0) in vec3 position;
layout(location = 1) in vec2 texCoord;

out vec2 TexCoord;
out vec3 FragPos;
out vec3 ViewDir;
out float DistanceFromCamera;

uniform mat4 MVP;
uniform mat4 model;
uniform vec3 cameraPos;

void main()
{
    vec4 worldPos = model * vec4(position, 1.0);
    FragPos = worldPos.xyz;

    // View direction from camera to fragment
    ViewDir = normalize(FragPos - cameraPos);

    // Distance from camera to this vertex
    DistanceFromCamera = length(FragPos - cameraPos);

    TexCoord = texCoord;

    gl_Position = MVP * vec4(position, 1.0);
}
