#version 330 core

layout(location = 0) in vec3 position;
layout(location = 1) in vec2 texCoord;
layout(location = 2) in vec3 normal;

out vec2 texCoord0;
out vec3 surfaceNormal;
out vec3 toLightVector;
out vec3 viewDirection;
out vec3 worldPos;
out float distFromCamera;

uniform mat4 MVP;
uniform mat4 model;
uniform vec3 cameraPos;

void main()
{
    vec4 worldPosition = model * vec4(position, 1.0);

    // Sun position
    vec3 lightPosition = vec3(5000.0, 10000.0, 5000.0);

    surfaceNormal = mat3(transpose(inverse(model))) * normal;
    toLightVector = lightPosition - worldPosition.xyz;
    viewDirection = normalize(cameraPos - worldPosition.xyz);

    worldPos = worldPosition.xyz;
    distFromCamera = length(worldPos - cameraPos);

    texCoord0 = texCoord;

    gl_Position = MVP * worldPosition;
}
