#version 330 core
in vec2 TexCoord;
in vec3 ParticleColor;
in float Alpha;

out vec4 FragColor;

uniform sampler2D particleTexture;
uniform float alphaMultiplier;
uniform int isBloodPool;

void main()
{
    vec4 texColor = texture(particleTexture, TexCoord);
    vec3 finalColor = ParticleColor * texColor.rgb;

    if (isBloodPool == 1) {
        // Wet blood pool effect - add subtle specular highlights and depth
        // Simulate wet surface with slight color variation
        float wetHighlight = pow(max(0.0, 1.0 - length(TexCoord - vec2(0.35, 0.35)) * 2.5), 3.0);

        // Add a subtle glossy highlight (simulates light reflection on wet surface)
        finalColor += vec3(0.15, 0.02, 0.02) * wetHighlight;

        // Darken the edges slightly for depth/pooling effect
        float edgeDarkening = 1.0 - texColor.a * 0.3;
        finalColor *= mix(1.0, edgeDarkening, 0.5);

        // Increase saturation slightly for richer blood color
        float luminance = dot(finalColor, vec3(0.299, 0.587, 0.114));
        finalColor = mix(vec3(luminance), finalColor, 1.3);
    }

    FragColor = vec4(finalColor, texColor.a * Alpha * alphaMultiplier);

    // Discard fully transparent pixels
    if (FragColor.a < 0.01) discard;
}