#version 330 core
layout (location = 0) in vec3 aPos;
layout (location = 1) in vec2 TexCoords;

out vec2 TexCoords0;
out vec3 WorldPos;
out vec3 CameraRelativePos;  // Position relative to camera for proper fade
out vec2 RadialUV;           // Radial UV for stretch correction

uniform mat4 projection;
uniform mat4 view;
uniform float time;
uniform vec3 cameraPos;  // Camera position in world space

void main()
{
    // Very slow cloud movement for distant sky effect
    // Reduced speed by 10x for more realistic distant cloud drift
    TexCoords0 = TexCoords + vec2(time * 0.0000005, time * 0.00000025);

    // Pass world position for reference
    WorldPos = aPos;

    // Calculate camera-relative position for circular fade
    // Since the sky plane moves with the camera (view translation is zeroed),
    // the vertex positions are already relative to camera XZ.
    CameraRelativePos = aPos;

    // Calculate radial UV coordinates to reduce edge stretching
    // Convert XZ position to polar-like coordinates for more uniform sampling
    float skyDistance = 4000.0;  // Match SKY_DISTANCE constant
    RadialUV = aPos.xz / skyDistance;  // Normalized -1 to 1 range

    vec4 pos = projection * view * vec4(aPos, 1.0);
    // Use .xyww trick to place clouds at maximum depth (z=w means z/w=1.0 after perspective divide)
    // This ensures terrain, objects, and characters always draw over the sky/clouds
    gl_Position = pos.xyww;
}
