/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.ext.paymentgateway;

import biz.papercut.pcng.ext.paymentgateway.AESProperty;
import biz.papercut.pcng.ext.paymentgateway.BasePaymentGatewayPlugin;
import biz.papercut.pcng.ext.paymentgateway.CreditCardGatewayPlugin;
import biz.papercut.pcng.ext.paymentgateway.EventLog;
import biz.papercut.pcng.ext.paymentgateway.GatewayUtils;
import biz.papercut.pcng.ext.paymentgateway.PaymentGatewayRequestLogMessageBuilder;
import biz.papercut.pcng.plugin.PluginManager;
import biz.papercut.pcng.plugin.WebServerPlugin;
import biz.papercut.pcng.server.ServerConfig;
import biz.papercut.pcng.service.LicenseManager;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.Date;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthorizeNetPlugin
extends BasePaymentGatewayPlugin
implements WebServerPlugin {
    private static final Logger logger = LoggerFactory.getLogger(AuthorizeNetPlugin.class);
    public static final String POSTBACK_URL_PATH = "/rpc/gateway/authorize-net";
    public static final String CONFIG_PREFIX = "authorize-net.";
    @AESProperty
    public static final String CONFIG_LOGIN = "authorize-net.login";
    @AESProperty
    public static final String CONFIG_TRANSACTION_KEY = "authorize-net.transaction-key";
    @AESProperty
    public static final String CONFIG_MD5_HASH_VALUE = "authorize-net.md5-hash-value";
    @AESProperty
    public static final String CONFIG_SHA2_HASH_VALUE = "authorize-net.sha2-hash-value";
    public static final String CONFIG_PUBLIC_RELAY_RESPONSE_HOSTNAME = "public-relay-response-hostname";
    public static final String CONFIG_POST_URL = "post-url";
    public static final String CONFIG_SUCCESS_MESSAGE = "success-message";
    public static final String CONFIG_PAYMENT_FORM_DESCRIPTION = "payment-form-description";
    public static final int PAYMENT_DESCRIPTION_MAX_LENGTH = 255;
    public static final String CONFIG_POSTBACK_ALLOWED_IP = "postback-allowed-ip";
    public static final int MAX_ORDER_NUMBER_LENGTH = 25;
    private static final String CHARSET_NAME_UTF8 = "UTF8";
    private static final String ALGORITHM_NAME_HMAC_MD5 = "HmacMD5";
    private static final String ALGORITHM_NAME_HMAC_SHA2 = "HmacSHA512";
    private static final List<String> PAGES = List.of("ExtnAuthorizeNet");
    private static final String FINGERPRINT_HASH_FIELD_SEPARATOR = "^";
    private static final String RESPONSE_CODE_SUCCESS = "1";
    private static final String RESPONSE_CODE_DECLINED = "2";
    private final Map<String, AuthorizeNetOrder> _authorizeNetOrders = Collections.synchronizedMap(new HashMap());

    @Override
    public String getConfigPrefix() {
        return CONFIG_PREFIX;
    }

    @Override
    public boolean isLicensed() {
        LicenseManager lm = (LicenseManager)this.getApplicationContext().getBean("licenseManager", LicenseManager.class);
        return GatewayUtils.isLicensed(lm, "payment-gateways-authorize-net");
    }

    public String createNewOrder(String username, double amount, String returnRedirectURL) {
        String orderId = this.getCreditCardGatewayPlugin().createNewOrder(username, amount, 25);
        AuthorizeNetOrder ano = new AuthorizeNetOrder(returnRedirectURL + "&order-id=" + orderId);
        this._authorizeNetOrders.put(orderId, ano);
        return orderId;
    }

    public String getIsConfigured() {
        String errorSuffix = "  Please check the payment gateway config file.";
        try {
            Mac.getInstance(ALGORITHM_NAME_HMAC_MD5);
            Mac.getInstance(ALGORITHM_NAME_HMAC_SHA2);
        }
        catch (NoSuchAlgorithmException nsae) {
            String error = "Required cryptography functionality is not present.  Contact support for assistance.";
            EventLog.getInstance().logEvent("ERROR: " + error);
            return error;
        }
        if (StringUtils.isBlank((String)this.getGatewayConfig().getString(CONFIG_LOGIN))) {
            String error = "Login/'API Login ID' not provided.";
            EventLog.getInstance().logEvent("ERROR: " + error);
            return error + errorSuffix;
        }
        if (StringUtils.isBlank((String)this.getGatewayConfig().getString(CONFIG_SHA2_HASH_VALUE)) && StringUtils.isBlank((String)this.getGatewayConfig().getString(CONFIG_TRANSACTION_KEY))) {
            String error = "Transaction key not provided.";
            EventLog.getInstance().logEvent("ERROR: " + error);
            return error + errorSuffix;
        }
        if (StringUtils.isBlank((String)this.getGatewayConfig().getString(CONFIG_MD5_HASH_VALUE)) && StringUtils.isBlank((String)this.getGatewayConfig().getString(CONFIG_SHA2_HASH_VALUE))) {
            EventLog.getInstance().logEvent("Warning: no Hash Value was provided. Specifying a value will provide better security.");
        }
        if (StringUtils.isBlank((String)this.getGatewayConfig().getString("authorize-net.public-relay-response-hostname"))) {
            String error = "Public relay response hostname not provided.";
            EventLog.getInstance().logEvent("ERROR: " + error);
            return error + errorSuffix;
        }
        if (this.getPaymentFormDescription().length() > 255) {
            String error = "Payment description (authorize-net.payment-form-description) must not be longer than 255 characters.";
            EventLog.getInstance().logEvent("ERROR: " + error);
            return error + errorSuffix;
        }
        if (StringUtils.isBlank((String)this.getGatewayConfig().getString("authorize-net.allowed-amounts"))) {
            String error = "Must specify at least one allowed payment amount.";
            EventLog.getInstance().logEvent("ERROR: " + error);
            return error + errorSuffix;
        }
        URL paymentPageURL = null;
        try {
            paymentPageURL = this.getGatewayConfig().getURL("authorize-net.post-url");
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        if (paymentPageURL == null) {
            EventLog.getInstance().logEvent("ERROR: Invalid POST URL: " + this.getGatewayConfig().getString("authorize-net.post-url") + ".");
            return "Invalid POST URL." + errorSuffix;
        }
        return null;
    }

    public List<String> additionalPages(String username) {
        if (this.isPluginEnabled() && this.isAccessibleByUser(username)) {
            return PAGES;
        }
        return null;
    }

    public void preStartupHook(WebServerPlugin.WebServer server) {
        if (!this.isPluginEnabled()) {
            return;
        }
        if (SystemUtils.IS_OS_WINDOWS) {
            logger.info("Enabling HTTP port 80 for Authorize.Net payment gateway.");
            server.listenOnPort(80);
        }
        server.addServlet(AuthorizeNetPOSTBackServlet.class, "/rpc/gateway/authorize-net/*");
    }

    public String calculateFingerprintHash(String login, String sequenceNumber, String timestamp, String amount) {
        if (StringUtils.isBlank((String)this.getGatewayConfig().getString(CONFIG_SHA2_HASH_VALUE))) {
            String transactionKey = this.getGatewayConfig().getString(CONFIG_TRANSACTION_KEY);
            return this.calculateFingerprintMD5Hash(transactionKey, login, sequenceNumber, timestamp, amount);
        }
        String signatureKey = this.getGatewayConfig().getString(CONFIG_SHA2_HASH_VALUE);
        return this.calculateFingerprintSHA2Hash(signatureKey, login, sequenceNumber, timestamp, amount);
    }

    public String calculateFingerprintMD5Hash(String transactionKey, String login, String sequenceNumber, String timestamp, String amount) {
        try {
            String message = login + FINGERPRINT_HASH_FIELD_SEPARATOR + sequenceNumber + FINGERPRINT_HASH_FIELD_SEPARATOR + timestamp + FINGERPRINT_HASH_FIELD_SEPARATOR + amount + FINGERPRINT_HASH_FIELD_SEPARATOR;
            return this.digestHMACMD5AsHexString(transactionKey, message);
        }
        catch (NoSuchAlgorithmException nsae) {
            logger.error("Error initializing cryptography: {}", (Object)nsae.getMessage());
            return null;
        }
        catch (InvalidKeyException ike) {
            logger.error("Error initializing cryptography: {}", (Object)ike.getMessage());
            return null;
        }
    }

    public String calculateFingerprintSHA2Hash(String signatureKey, String login, String sequenceNumber, String timestamp, String amount) {
        try {
            String message = login + FINGERPRINT_HASH_FIELD_SEPARATOR + sequenceNumber + FINGERPRINT_HASH_FIELD_SEPARATOR + timestamp + FINGERPRINT_HASH_FIELD_SEPARATOR + amount + FINGERPRINT_HASH_FIELD_SEPARATOR;
            return this.digestHMACSHA2AHexString(signatureKey, message);
        }
        catch (NoSuchAlgorithmException nsae) {
            logger.error("Error initializing cryptography: {}", (Object)nsae.getMessage());
            return null;
        }
        catch (InvalidKeyException ike) {
            logger.error("Error initializing cryptography: {}", (Object)ike.getMessage());
            return null;
        }
    }

    public void verifyTransaction(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Object returnRedirectURL = "http://" + request.getServerName() + ":" + ServerConfig.getInstance().getServerPort() + "/user";
        String mD5HashValue = this.getGatewayConfig().getString(CONFIG_MD5_HASH_VALUE);
        String sHA2HashValue = this.getGatewayConfig().getString(CONFIG_SHA2_HASH_VALUE);
        String login = this.getGatewayConfig().getString(CONFIG_LOGIN);
        String transactionId = request.getParameter("x_trans_id");
        String testRequest = request.getParameter("x_test_request");
        String responseCode = request.getParameter("x_response_code");
        String authCode = request.getParameter("x_auth_code");
        String cvv2ResponseCode = request.getParameter("x_cvv2_resp_code");
        String cavvResponseCode = request.getParameter("x_cavv_response");
        String avsCode = request.getParameter("x_avs_code");
        String method = request.getParameter("x_method");
        String accountNumber = request.getParameter("x_account_number");
        String amountStr = request.getParameter("x_amount");
        String company = request.getParameter("x_company");
        String firstName = request.getParameter("x_first_name");
        String lastName = request.getParameter("x_last_name");
        String address = request.getParameter("x_address");
        String city = request.getParameter("x_city");
        String state = request.getParameter("x_state");
        String zip = request.getParameter("x_zip");
        String country = request.getParameter("x_country");
        String phone = request.getParameter("x_phone");
        String fax = request.getParameter("x_fax");
        String email = request.getParameter("x_email");
        String shipToCompany = request.getParameter("x_ship_to_company");
        String shipToFirstName = request.getParameter("x_ship_to_first_name");
        String shipToLastName = request.getParameter("x_ship_to_last_name");
        String shipToAddress = request.getParameter("x_ship_to_address");
        String shipToCity = request.getParameter("x_ship_to_city");
        String shipToState = request.getParameter("x_ship_to_state");
        String shipToZip = request.getParameter("x_ship_to_zip");
        String shipToCountry = request.getParameter("x_ship_to_country");
        String invoiceNuber = request.getParameter("x_invoice_num");
        String digest_MD5 = StringUtils.lowerCase((String)request.getParameter("x_MD5_Hash"));
        String digest_SHA2 = StringUtils.lowerCase((String)request.getParameter("x_SHA2_Hash"));
        String userName = request.getParameter("x_cust_id");
        String orderId = request.getParameter("x_po_num");
        String responseReasonCode = request.getParameter("x_response_reason_code");
        String responseReasonText = request.getParameter("x_response_reason_text");
        String reason = responseReasonCode + " - " + responseReasonText;
        AuthorizeNetOrder ano = this._authorizeNetOrders.get(orderId);
        if (ano == null) {
            String msg = "Invalid order ID: " + orderId + ". Ignoring order and sending error page.";
            EventLog.getInstance().logEvent(msg);
            logger.error(msg);
            this.sendResponsePage(response, ResponsePageType.Error, transactionId, orderId, authCode, userName, amountStr, (String)returnRedirectURL, reason);
            return;
        }
        returnRedirectURL = ano.getReturnRedirectURL();
        if (!this.isIPAddressValid(request.getRemoteAddr(), this.getGatewayConfig().getString("authorize-net.postback-allowed-ip"))) {
            String msg = "Invalid IP address (" + request.getRemoteAddr() + ") accessing Authorize.Net postback URL: " + request.getRequestURI();
            EventLog.getInstance().logEvent(msg);
            logger.error(msg);
            this.sendResponsePage(response, ResponsePageType.Error, transactionId, orderId, authCode, userName, amountStr, (String)returnRedirectURL, reason);
            return;
        }
        if (!RESPONSE_CODE_SUCCESS.equals(responseCode)) {
            ResponsePageType type = RESPONSE_CODE_DECLINED.equals(responseCode) ? ResponsePageType.Declined : ResponsePageType.Error;
            String msg = "Failed transaction reported by Authorize.Net. Reason " + reason;
            EventLog.getInstance().logEvent(msg);
            logger.error(msg);
            this.sendResponsePage(response, type, transactionId, orderId, authCode, userName, amountStr, (String)returnRedirectURL, reason);
            return;
        }
        if (StringUtils.isBlank((String)this.getGatewayConfig().getString(CONFIG_SHA2_HASH_VALUE))) {
            message = mD5HashValue + login + transactionId + amountStr;
            String calculatedDigest = this.digestMD5AsHexString(message);
            if (logger.isDebugEnabled()) {
                logger.debug("Calculated digest on '{}': '{}', expected: '{}'", new Object[]{message, calculatedDigest, digest_MD5});
            }
            if (!calculatedDigest.equals(digest_MD5)) {
                String msg = "Calculated digest does not match Authorize.Net's digest. Configuration error or possible attack attempt. Ensure that the configured 'MD5 Hash Value' is correct.";
                EventLog.getInstance().logEvent(msg);
                logger.error(msg);
                this.sendResponsePage(response, ResponsePageType.Error, transactionId, orderId, authCode, userName, amountStr, (String)returnRedirectURL, reason);
                return;
            }
        } else {
            try {
                message = FINGERPRINT_HASH_FIELD_SEPARATOR + transactionId + FINGERPRINT_HASH_FIELD_SEPARATOR + testRequest + FINGERPRINT_HASH_FIELD_SEPARATOR + responseCode + FINGERPRINT_HASH_FIELD_SEPARATOR + authCode + FINGERPRINT_HASH_FIELD_SEPARATOR + cvv2ResponseCode + FINGERPRINT_HASH_FIELD_SEPARATOR + cavvResponseCode + FINGERPRINT_HASH_FIELD_SEPARATOR + avsCode + FINGERPRINT_HASH_FIELD_SEPARATOR + method + FINGERPRINT_HASH_FIELD_SEPARATOR + accountNumber + FINGERPRINT_HASH_FIELD_SEPARATOR + amountStr + FINGERPRINT_HASH_FIELD_SEPARATOR + company + FINGERPRINT_HASH_FIELD_SEPARATOR + firstName + FINGERPRINT_HASH_FIELD_SEPARATOR + lastName + FINGERPRINT_HASH_FIELD_SEPARATOR + address + FINGERPRINT_HASH_FIELD_SEPARATOR + city + FINGERPRINT_HASH_FIELD_SEPARATOR + state + FINGERPRINT_HASH_FIELD_SEPARATOR + zip + FINGERPRINT_HASH_FIELD_SEPARATOR + country + FINGERPRINT_HASH_FIELD_SEPARATOR + phone + FINGERPRINT_HASH_FIELD_SEPARATOR + fax + FINGERPRINT_HASH_FIELD_SEPARATOR + email + FINGERPRINT_HASH_FIELD_SEPARATOR + shipToCompany + FINGERPRINT_HASH_FIELD_SEPARATOR + shipToFirstName + FINGERPRINT_HASH_FIELD_SEPARATOR + shipToLastName + FINGERPRINT_HASH_FIELD_SEPARATOR + shipToAddress + FINGERPRINT_HASH_FIELD_SEPARATOR + shipToCity + FINGERPRINT_HASH_FIELD_SEPARATOR + shipToState + FINGERPRINT_HASH_FIELD_SEPARATOR + shipToZip + FINGERPRINT_HASH_FIELD_SEPARATOR + shipToCountry + FINGERPRINT_HASH_FIELD_SEPARATOR + invoiceNuber + FINGERPRINT_HASH_FIELD_SEPARATOR;
                String calculatedDigest = this.digestHMACSHA2AHexString(sHA2HashValue, message);
                if (logger.isDebugEnabled()) {
                    logger.debug("Calculated digest: '{}', expected: '{}'", (Object)calculatedDigest, (Object)digest_SHA2);
                }
                if (!calculatedDigest.equals(digest_SHA2)) {
                    String msg = "Calculated digest does not match Authorize.Net's digest. Configuration error or possible attack attempt. Ensure that the configured 'SHA2 Hash Value' is correct.";
                    EventLog.getInstance().logEvent(msg);
                    logger.error(msg);
                    this.sendResponsePage(response, ResponsePageType.Error, transactionId, orderId, authCode, userName, amountStr, (String)returnRedirectURL, reason);
                    return;
                }
            }
            catch (NoSuchAlgorithmException nsae) {
                logger.error("Error initializing cryptography: {}", (Object)nsae.getMessage());
                return;
            }
            catch (InvalidKeyException ike) {
                logger.error("Error initializing cryptography: {}", (Object)ike.getMessage());
                return;
            }
        }
        double amountAdded = 0.0;
        try {
            amountAdded = Double.parseDouble(amountStr);
        }
        catch (NumberFormatException nfe) {
            String msg = "Invalid Authorize.Net post data. Invalid amount: " + amountStr;
            EventLog.getInstance().logEvent(msg);
            logger.error(msg);
            this.sendResponsePage(response, ResponsePageType.Error, transactionId, orderId, authCode, userName, amountStr, (String)returnRedirectURL, reason);
            return;
        }
        String msg = "Authorize.Net reported successful transaction for order id " + orderId + ", completing order.  Remote address: " + request.getRemoteAddr();
        EventLog.getInstance().logEvent(msg);
        logger.info(msg);
        CreditCardGatewayPlugin.OrderResponse orderResponse = this.getCreditCardGatewayPlugin().confirmOrder(orderId, amountAdded);
        if (orderResponse.isSuccess()) {
            String m = "Order " + orderId + " confirmed.";
            EventLog.getInstance().logEvent(m);
            logger.info(m);
            this.sendResponsePage(response, ResponsePageType.Success, transactionId, orderId, authCode, userName, amountStr, (String)returnRedirectURL, reason);
            ano.setSuccessful(true);
        } else {
            String errorMsg = "Could not confirm order " + orderId + ", message: " + orderResponse.getMessage();
            EventLog.getInstance().logEvent(errorMsg);
            logger.error(errorMsg);
            this.sendResponsePage(response, ResponsePageType.Error, transactionId, orderId, authCode, userName, amountStr, (String)returnRedirectURL, reason);
            ano.setSuccessful(false);
        }
    }

    private void sendResponsePage(HttpServletResponse response, ResponsePageType type, String transactionId, String orderId, String authCode, String userName, String total, String returnRedirectURL, String reason) throws IOException {
        response.setContentType("text/html");
        if (type == ResponsePageType.Error) {
            response.setStatus(500);
        }
        StringBuilder page = new StringBuilder();
        String successMessage = this.getGatewayConfig().getString("authorize-net.success-message");
        String errorMessage = this.getGatewayConfig().getString("user-error-message");
        String paymentFormDescription = this.getPaymentFormDescription();
        String timestamp = new Date().toString();
        page.append("<html>");
        page.append("<head><title>");
        switch (type.ordinal()) {
            case 0: {
                page.append("Payment Receipt");
                break;
            }
            case 1: {
                page.append("Payment Declined");
                break;
            }
            case 2: {
                page.append("Payment Error");
            }
        }
        page.append("</title></head>");
        page.append("<body style=\"text-align: center;\">");
        switch (type.ordinal()) {
            case 0: {
                page.append("<h1>Payment Receipt</h1>");
                page.append("<pre>").append(successMessage).append("</pre>");
                break;
            }
            case 1: {
                page.append("<h1>Payment Declined</h1>");
                page.append("<p>Your payment was declined.</p>");
                page.append("<p>Reason: ").append(reason).append(".</p>");
                break;
            }
            case 2: {
                page.append("<h1>Payment Error</h1>");
                page.append("<pre>").append(errorMessage).append("</pre>");
            }
        }
        if (type != ResponsePageType.Declined) {
            page.append("<table style=\"margin: 1em auto; text-align: left;\"><tbody>");
            page.append("<tr>");
            page.append("<th>Description:</th>");
            page.append("<td>").append(paymentFormDescription).append("</td>");
            page.append("</tr>");
            page.append("<tr>");
            page.append("<th>Date/Time:</th>");
            page.append("<td>").append(timestamp).append("</td>");
            page.append("</tr>");
            page.append("<tr>");
            page.append("<th>Transaction ID:</th>");
            page.append("<td>").append(transactionId).append("</td>");
            page.append("</tr>");
            page.append("<tr>");
            page.append("<th>Order ID:</th>");
            page.append("<td>").append(orderId).append("</td>");
            page.append("</tr>");
            page.append("<tr>");
            page.append("<th>Authorization Code:</th>");
            page.append("<td>").append(authCode).append("</td>");
            page.append("</tr>");
            page.append("<tr>");
            page.append("<th>User Name:</th>");
            page.append("<td>").append(userName).append("</td>");
            page.append("</tr>");
            page.append("<tr>");
            page.append("<th>Total:</th>");
            page.append("<td>").append(total).append("</td>");
            page.append("</tr>");
            page.append("</tbody></table>");
        }
        page.append("<a href=\"").append(returnRedirectURL).append("\">");
        switch (type.ordinal()) {
            case 0: {
                page.append("Done");
                break;
            }
            case 1: 
            case 2: {
                page.append("OK");
            }
        }
        page.append("</a>");
        page.append("</body>");
        page.append("</html>");
        response.getWriter().write(page.toString());
    }

    public Boolean finalize(String orderId) {
        AuthorizeNetOrder ano = this._authorizeNetOrders.get(orderId);
        if (ano == null) {
            return null;
        }
        Boolean success = ano.getSuccessful();
        this._authorizeNetOrders.remove(orderId);
        return success;
    }

    public String getPaymentFormDescription() {
        return StringUtils.trimToEmpty((String)this.getGatewayConfig().getString("authorize-net.payment-form-description"));
    }

    private String digestHMACMD5AsHexString(String secret, String message) throws NoSuchAlgorithmException, InvalidKeyException {
        SecretKeySpec key = new SecretKeySpec(secret.getBytes(StandardCharsets.UTF_8), ALGORITHM_NAME_HMAC_MD5);
        Mac mac = Mac.getInstance(key.getAlgorithm());
        mac.init(key);
        byte[] messageUTF8 = message.getBytes(StandardCharsets.UTF_8);
        byte[] digest = mac.doFinal(messageUTF8);
        return new String(Hex.encodeHex((byte[])digest));
    }

    private String digestHMACSHA2AHexString(String secret, String message) throws NoSuchAlgorithmException, InvalidKeyException {
        byte[] secretByte = AuthorizeNetPlugin.hexStringToByteArray(secret);
        SecretKeySpec key = new SecretKeySpec(secretByte, ALGORITHM_NAME_HMAC_SHA2);
        Mac mac = Mac.getInstance(key.getAlgorithm());
        mac.init(key);
        byte[] messageUTF8 = message.getBytes(StandardCharsets.UTF_8);
        byte[] digest = mac.doFinal(messageUTF8);
        return AuthorizeNetPlugin.toHexString(digest);
    }

    public static byte[] hexStringToByteArray(String secret) {
        int len = secret.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(secret.charAt(i), 16) << 4) + Character.digit(secret.charAt(i + 1), 16));
        }
        return data;
    }

    private static String toHexString(byte[] digest) {
        Formatter formatter = new Formatter();
        for (byte b : digest) {
            formatter.format("%02x", b);
        }
        return formatter.toString();
    }

    private String digestMD5AsHexString(String message) {
        return StringUtils.lowerCase((String)DigestUtils.md5Hex((String)message));
    }

    public static class AuthorizeNetOrder {
        private final String _returnRedirectURL;
        private Boolean _successful;

        public AuthorizeNetOrder(String returnRedirectURL) {
            this._returnRedirectURL = returnRedirectURL;
            this._successful = null;
        }

        public String getReturnRedirectURL() {
            return this._returnRedirectURL;
        }

        public Boolean getSuccessful() {
            return this._successful;
        }

        public void setSuccessful(Boolean successful) {
            this._successful = successful;
        }
    }

    public static class AuthorizeNetPOSTBackServlet
    extends HttpServlet {
        private final PaymentGatewayRequestLogMessageBuilder logMessageBuilder = new PaymentGatewayRequestLogMessageBuilder("POSTback servlet").withSelectedParameters(this.getParametersToLog());

        protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
            this.debugLogRequest(request);
            this.getAuthorizeNetPlugin().verifyTransaction(request, response);
        }

        protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
            this.debugLogRequest(request);
            response.setContentType("text/html");
            response.getWriter().write("<html><body><h1>The Authorize.Net POSTback URL is accessible as of " + String.valueOf(new Date()) + "</h1><p>Remember to ensure that the URL is externally accessible (i.e. that the Authorize.Net server has access)</p></body></html>");
        }

        private AuthorizeNetPlugin getAuthorizeNetPlugin() {
            return (AuthorizeNetPlugin)PluginManager.getInstance().getPluginByClass(AuthorizeNetPlugin.class);
        }

        private void debugLogRequest(HttpServletRequest request) {
            if (logger.isDebugEnabled()) {
                logger.debug(this.buildLogMessageFromRequest(request));
            }
        }

        String buildLogMessageFromRequest(HttpServletRequest request) {
            return this.logMessageBuilder.buildFrom(request);
        }

        private List<String> getParametersToLog() {
            return List.of("x_trans_id", "x_test_request", "x_response_code", "x_auth_code", "x_avs_code", "x_cvv2_resp_code", "x_cavv_response", "x_method", "x_account_number", "x_amount", "x_invoice_num", "x_cust_id", "x_po_num", "x_response_reason_code", "x_response_reason_text");
        }
    }

    private static enum ResponsePageType {
        Success,
        Declined,
        Error;

    }
}

