/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.ext.paymentgateway;

import biz.papercut.pcng.domain.Group;
import biz.papercut.pcng.domain.User;
import biz.papercut.pcng.ext.paymentgateway.AESProperty;
import biz.papercut.pcng.ext.paymentgateway.CreditCardGatewayPlugin;
import biz.papercut.pcng.ext.paymentgateway.EventLog;
import biz.papercut.pcng.ext.paymentgateway.GatewayConfig;
import biz.papercut.pcng.ext.paymentgateway.GatewayUtils;
import biz.papercut.pcng.ext.paymentgateway.PaymentGatewayRequestLogMessageBuilder;
import biz.papercut.pcng.plugin.EnableablePlugin;
import biz.papercut.pcng.plugin.PluginManager;
import biz.papercut.pcng.plugin.SpringContextPlugin;
import biz.papercut.pcng.plugin.UserLinkPlugin;
import biz.papercut.pcng.plugin.WebServerPlugin;
import biz.papercut.pcng.service.LicenseManager;
import biz.papercut.pcng.service.UserManager;
import biz.papercut.pcng.util.IPAddressChecker;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.Collator;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.eclipse.jetty.ee10.webapp.WebAppContext;
import org.eclipse.jetty.server.Connector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class BarclaycardEPDQPlugin
implements UserLinkPlugin,
WebServerPlugin,
SpringContextPlugin,
EnableablePlugin {
    private static final Logger logger = LoggerFactory.getLogger(BarclaycardEPDQPlugin.class);
    public static final String RETURN_URL_PATH = "/rpc/gateway/barclaycardepdq/";
    private static final String POSTBACK_URL_PATH = "/rpc/gateway/barclaycardepdq/*";
    private static final String ORDER_STATUS_SUCCESS = "5,9";
    private static final String CONFIG_PREFIX = "barclaycard-epdq.";
    public static final String CONFIG_ENABLED = "barclaycard-epdq.enabled";
    public static final String CONFIG_CLIENT_ID = "barclaycard-epdq.client-id";
    @AESProperty
    public static final String CONFIG_EPDQ_PASSPHRASE = "barclaycard-epdq.epdq-passphrase";
    @AESProperty
    public static final String CONFIG_EPDQ_PASSPHRASE_OUT = "barclaycard-epdq.epdq-passphrase-out";
    @AESProperty
    public static final String CONFIG_SECURITY_TOKEN = "barclaycard-epdq.security-token";
    public static final String CONFIG_MERCHANT_NAME = "barclaycard-epdq.merchant-name";
    public static final String CONFIG_CURRENCY_CODE = "barclaycard-epdq.currency-code";
    public static final String CONFIG_PAGE_TITLE = "barclaycard-epdq.page-title";
    public static final String CONFIG_PAGE_HEADING = "barclaycard-epdq.page-heading";
    public static final String CONFIG_ALLOWED_GROUPS = "barclaycard-epdq.allowed-groups";
    public static final String CONFIG_ALLOWED_AMOUNTS = "barclaycard-epdq.allowed-amounts";
    public static final String CONFIG_POSTBACK_ENABLE_PORT_80 = "barclaycard-epdq.postback-enable-port-80";
    public static final String CONFIG_POSTBACK_ALLOWED_IP = "barclaycard-epdq.postback-allowed-ip";
    public static final String CONFIG_EPDQ_PAYMENT_PAGE_URL = "barclaycard-epdq.epdq-payment-page-url";
    public static final String CONFIG_EPDQ_SHA_ALGORITHM = "barclaycard-epdq.epdq-sha-algorithm";
    public static final String CONFIG_EPDQ_LANGUAGE = "barclaycard-epdq.language";
    private static final List<String> PAGES = List.of("ExtnBarclaycardEPDQ");
    @Nullable
    private ApplicationContext _applicationContext;
    private final Map<String, BarclaycardEPDQOrder> _barclaycardOrders = Collections.synchronizedMap(new HashMap());
    @Nullable
    private Connector _connector;
    @Nullable
    private WebAppContext _context;

    public boolean isPluginEnabled() {
        Boolean enabled = GatewayConfig.getInstance().getBoolean(CONFIG_ENABLED);
        return enabled != null && enabled != false;
    }

    public boolean isLicensed() {
        LicenseManager lm = (LicenseManager)this.getApplicationContext().getBean("licenseManager", LicenseManager.class);
        return GatewayUtils.isLicensed(lm, "payment-gateways-barclaycard");
    }

    @CheckForNull
    public String getIsConfigured() {
        URL paymentPageURL;
        GatewayConfig conf = GatewayConfig.getInstance();
        String errorSuffix = "  Please check the payment gateway config file.";
        if (StringUtils.isBlank((String)conf.getString(CONFIG_CLIENT_ID))) {
            EventLog.getInstance().logEvent("ePDQ PSPID not provided.");
            return "ePDQ PSPID not provided." + errorSuffix;
        }
        if (StringUtils.isBlank((String)conf.getString(CONFIG_EPDQ_PASSPHRASE))) {
            EventLog.getInstance().logEvent("ePDQ passphrase not provided.");
            return "ePDQ passphrase not provided." + errorSuffix;
        }
        String algorithm = conf.getString(CONFIG_EPDQ_SHA_ALGORITHM);
        if (StringUtils.isBlank((String)algorithm)) {
            EventLog.getInstance().logEvent("ePDQ encoding Algorithm not provided.");
            return "ePDQ encoding Algorithm not provided." + errorSuffix;
        }
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            EventLog.getInstance().logEvent("Invalid ePDQ encoding Algorithm.");
            return "Invalid ePDQ encoding Algorithm." + errorSuffix;
        }
        if (StringUtils.isBlank((String)conf.getString(CONFIG_EPDQ_LANGUAGE))) {
            EventLog.getInstance().logEvent("ePDQ language setting is not provided.");
            return "ePDQ language setting not provided." + errorSuffix;
        }
        if (StringUtils.isBlank((String)conf.getString(CONFIG_ALLOWED_AMOUNTS))) {
            EventLog.getInstance().logEvent("Must specify at least one allowed payment amount.");
            return "Must specify at least one allowed payment amount." + errorSuffix;
        }
        if (StringUtils.isBlank((String)conf.getString(CONFIG_EPDQ_PASSPHRASE_OUT))) {
            EventLog.getInstance().logEvent("ePDQ out passphrase not provided.");
            return "ePDQ out passphrase not provided." + errorSuffix;
        }
        try {
            paymentPageURL = conf.getURL(CONFIG_EPDQ_PAYMENT_PAGE_URL);
        }
        catch (MalformedURLException murle) {
            paymentPageURL = null;
        }
        if (paymentPageURL == null) {
            EventLog.getInstance().logEvent("Invalid ePDQ payment page URL: " + conf.getString(CONFIG_EPDQ_PAYMENT_PAGE_URL) + ".");
            return "Invalid ePDQ payment page URL." + errorSuffix;
        }
        return null;
    }

    public boolean isAccessibleByUser(String username) {
        if (!this.isPluginEnabled()) {
            return false;
        }
        User u = null;
        if (StringUtils.isNotBlank((String)username)) {
            u = this.getUserManager().getUser(username);
        }
        if (u == null) {
            logger.debug("Unable to find user: {}", (Object)username);
            return false;
        }
        GatewayConfig conf = GatewayConfig.getInstance();
        List<String> allowedGroups = conf.getStringList(CONFIG_ALLOWED_GROUPS);
        if (allowedGroups.isEmpty()) {
            return true;
        }
        for (Group group : u.getGroups()) {
            for (String allowedGroup : allowedGroups) {
                if (!allowedGroup.equalsIgnoreCase(group.getGroupName())) continue;
                return true;
            }
        }
        return false;
    }

    public List<String> additionalPages(String username) {
        if (this.isPluginEnabled() && this.isAccessibleByUser(username)) {
            return PAGES;
        }
        return null;
    }

    @CheckForNull
    public String getPageTitle() {
        return StringUtils.trimToNull((String)GatewayConfig.getInstance().getString(CONFIG_PAGE_TITLE));
    }

    public void preStartupHook(WebServerPlugin.WebServer server) {
        Boolean enablePort80;
        if (!this.isPluginEnabled()) {
            return;
        }
        if (SystemUtils.IS_OS_WINDOWS && ((enablePort80 = GatewayConfig.getInstance().getBoolean(CONFIG_POSTBACK_ENABLE_PORT_80)) == null || enablePort80.booleanValue())) {
            server.listenOnPort(80);
        }
        server.addServlet(BarclaycardEPDQCallbackServlet.class, POSTBACK_URL_PATH);
    }

    public ApplicationContext getApplicationContext() {
        return this._applicationContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this._applicationContext = applicationContext;
    }

    private boolean isIPAddressValid(String address) {
        String allowed = GatewayConfig.getInstance().getString(CONFIG_POSTBACK_ALLOWED_IP);
        if (StringUtils.isNotBlank((String)allowed) && !"*".equals(allowed)) {
            return IPAddressChecker.isAddressInRange((String)allowed, (String)address);
        }
        return true;
    }

    public String getEncryptedDataInputTag(String orderId, double amount) {
        GatewayConfig conf = GatewayConfig.getInstance();
        String clientId = conf.getString(CONFIG_CLIENT_ID);
        String currencyCode = conf.getString(CONFIG_CURRENCY_CODE);
        DecimalFormat fmt = new DecimalFormat("0");
        String amountStr = fmt.format(amount * 100.0);
        String language = conf.getString(CONFIG_EPDQ_LANGUAGE);
        String shaAlgorithm = conf.getString(CONFIG_EPDQ_SHA_ALGORITHM);
        String passphrase = conf.getString(CONFIG_EPDQ_PASSPHRASE);
        StringBuilder data = new StringBuilder();
        data.append("AMOUNT=").append(amountStr).append(passphrase);
        data.append("CURRENCY=").append(currencyCode).append(passphrase);
        data.append("LANGUAGE=").append(language).append(passphrase);
        data.append("ORDERID=").append(orderId).append(passphrase);
        data.append("PSPID=").append(clientId).append(passphrase);
        GatewayUtils.LogHelper.logDebug(logger, "Request parameters for " + orderId + "is :" + String.valueOf(data));
        return this.getSHAEncryptedString(data.toString(), shaAlgorithm);
    }

    private String getSHAEncryptedString(String data, String algorithm) {
        StringBuilder response = new StringBuilder();
        try {
            byte[] result;
            MessageDigest crypt = MessageDigest.getInstance(algorithm);
            crypt.reset();
            for (byte b : result = crypt.digest(data.getBytes(StandardCharsets.UTF_8))) {
                response.append(String.format("%02X", b));
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return response.toString();
    }

    public void processPostback(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String token = GatewayConfig.getInstance().getString(CONFIG_SECURITY_TOKEN);
        if (StringUtils.isNotBlank((String)token) && !request.getRequestURI().contains(token)) {
            String msg = "Postback URL contains an invalid or missing security token.";
            EventLog.getInstance().logEvent(msg);
            logger.error(msg);
            response.sendError(403, "Invalid request");
            return;
        }
        if (!this.isIPAddressValid(request.getRemoteAddr())) {
            String msg = "Invalid IP address (" + request.getRemoteAddr() + ") accessing Barclaycard postback URL: " + request.getRequestURI();
            EventLog.getInstance().logEvent(msg);
            logger.error(msg);
            response.sendError(403, "Invalid request");
            return;
        }
        String amountStr = request.getParameter("amount");
        String ncError = request.getParameter("NCERROR");
        String orderId = request.getParameter("orderID");
        String transactionStatus = request.getParameter("STATUS");
        String shasign = request.getParameter("SHASIGN");
        if (StringUtils.isEmpty((String)orderId)) {
            String msg = "Invalid Barclaycard post data. Missing order id.";
            EventLog.getInstance().logEvent(msg);
            logger.error(msg);
            response.sendError(500, "Unexpected post data");
            return;
        }
        double amountAdded = 0.0;
        try {
            amountAdded = Double.parseDouble(amountStr);
        }
        catch (NumberFormatException nfe) {
            String msg = "Invalid Barclaycard post data. Invalid amount: " + StringUtils.trimToEmpty((String)amountStr);
            EventLog.getInstance().logEvent(msg);
            logger.error(msg);
            response.sendError(500, "Unexpected post data");
            return;
        }
        String passphraseOut = GatewayConfig.getInstance().getString(CONFIG_EPDQ_PASSPHRASE_OUT);
        String algorithm = GatewayConfig.getInstance().getString(CONFIG_EPDQ_SHA_ALGORITHM);
        String ShaOutCalculated = this.getResponseSHAEncryptedString(request, passphraseOut, algorithm);
        if (!shasign.equalsIgnoreCase(ShaOutCalculated)) {
            String msg = "Invalid Barclaycard post data as encrypted string does not match.";
            EventLog.getInstance().logEvent(msg);
            logger.error(msg);
            response.sendError(500, "Unexpected post data");
            return;
        }
        if (ncError != null && !ncError.isEmpty() && !ncError.equalsIgnoreCase("0")) {
            String errMsg = "Barclaycard responded with error " + ncError + " for orderId :" + orderId;
            EventLog.getInstance().logEvent(errMsg);
            logger.error(errMsg);
        } else {
            String msg = "Barclaycard responded with status " + transactionStatus + " for orderId :" + orderId;
            EventLog.getInstance().logEvent(msg);
            logger.info(msg);
        }
        BarclaycardEPDQOrder bo = this._barclaycardOrders.get(orderId);
        boolean orderSuccess = Arrays.asList(ORDER_STATUS_SUCCESS.split(",")).contains(transactionStatus);
        String msg = orderSuccess ? "Barclaycard reported successful transaction for order id " + orderId + ", completing order.  Remote address: " + request.getRemoteAddr() : "Barclaycard reported failed transaction for order id " + orderId + ", cancelling order.  Remote address: " + request.getRemoteAddr();
        EventLog.getInstance().logEvent(msg);
        logger.info(msg);
        if (bo != null) {
            this._barclaycardOrders.put(orderId, new BarclaycardEPDQOrder(bo.getReturnRedirectURL(), orderSuccess));
        }
        if (orderSuccess) {
            CreditCardGatewayPlugin.OrderResponse orderResponse = BarclaycardEPDQPlugin.getCreditCardGatewayPlugin().confirmOrder(orderId, amountAdded);
            if (orderResponse.isSuccess()) {
                EventLog.getInstance().logEvent("Order " + orderId + " confirmed.");
            } else {
                String errorMsg = "Could not confirm order " + orderId + ", message: " + orderResponse.getMessage();
                EventLog.getInstance().logEvent(errorMsg);
                logger.error(errorMsg);
                response.sendError(500, "Unexpected post data");
            }
        }
    }

    private String getResponseSHAEncryptedString(HttpServletRequest request, String shaPassphraseOut, String algorithm) {
        ArrayList list = new ArrayList(request.getParameterMap().keySet());
        list.sort(Collator.getInstance());
        StringBuilder data = new StringBuilder();
        for (String parameter : list) {
            String paramValue = request.getParameter(parameter);
            if (parameter.equalsIgnoreCase("SHASIGN") || paramValue == null || paramValue.trim().isEmpty()) continue;
            data.append(parameter.toUpperCase()).append("=").append(paramValue).append(shaPassphraseOut);
        }
        return this.getSHAEncryptedString(data.toString(), algorithm);
    }

    public void processReturn(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String orderId = request.getParameter("orderID");
        BarclaycardEPDQOrder bo = this._barclaycardOrders.remove(orderId);
        if (bo == null) {
            String msg = "User accessed Barclaycard callback URL with the invalid order id " + orderId + ".  Redirecting user to the login page.";
            EventLog.getInstance().logEvent(msg);
            logger.error(msg);
            response.sendRedirect("/");
            return;
        }
        boolean success = false;
        Boolean s = bo.getSuccessful();
        if (s != null && s.booleanValue()) {
            success = true;
        }
        String redirectURL = bo.getReturnRedirectURL() + "&success=" + success;
        String msg = "Barclaycard server returned user after payment processing, order id: " + orderId + ", successful: " + success + ".  Redirecting user to: " + redirectURL;
        EventLog.getInstance().logEvent(msg);
        logger.debug(msg);
        response.sendRedirect(redirectURL);
    }

    static PluginManager getPluginManager() {
        return PluginManager.getInstance();
    }

    static CreditCardGatewayPlugin getCreditCardGatewayPlugin() {
        return (CreditCardGatewayPlugin)BarclaycardEPDQPlugin.getPluginManager().getPluginByClass(CreditCardGatewayPlugin.class);
    }

    static BarclaycardEPDQPlugin getBarclaycardEPDQPlugin() {
        return (BarclaycardEPDQPlugin)BarclaycardEPDQPlugin.getPluginManager().getPluginByClass(BarclaycardEPDQPlugin.class);
    }

    public String createNewOrder(String username, double amount, String returnURL) {
        String orderId = BarclaycardEPDQPlugin.getCreditCardGatewayPlugin().createNewOrder(username, amount);
        BarclaycardEPDQOrder bo = new BarclaycardEPDQOrder(returnURL, null);
        this._barclaycardOrders.put(orderId, bo);
        return orderId;
    }

    private UserManager getUserManager() {
        return (UserManager)this.getApplicationContext().getBean("userManager", UserManager.class);
    }

    private static List<String> getParametersToLog() {
        return List.of("amount", "NCERROR", "orderID", "STATUS");
    }

    public static class BarclaycardEPDQCallbackServlet
    extends HttpServlet {
        private static final Logger logger = LoggerFactory.getLogger(BarclaycardEPDQCallbackServlet.class);
        private final PaymentGatewayRequestLogMessageBuilder logMessageBuilder = new PaymentGatewayRequestLogMessageBuilder("Callback servlet").withSelectedParameters(BarclaycardEPDQPlugin.getParametersToLog());

        protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
            this.debugLogRequest(request);
            BarclaycardEPDQPlugin.getBarclaycardEPDQPlugin().processPostback(request, response);
        }

        protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
            this.debugLogRequest(request);
            if (StringUtils.isNotBlank((String)request.getParameter("orderID"))) {
                BarclaycardEPDQPlugin.getBarclaycardEPDQPlugin().processReturn(request, response);
                return;
            }
            response.getWriter().write("<html><body><h1>The Barclaycard ePDQ Postback URL is accessible as of " + String.valueOf(new Date()) + "</h1><p>Remember to ensure that the URL is externally accessible (i.e. that the Barclaycard server has access)</p></body></html>");
        }

        private void debugLogRequest(HttpServletRequest request) {
            if (logger.isDebugEnabled()) {
                GatewayUtils.LogHelper.logDebug(logger, this.buildLogMessageFromRequest(request));
            }
        }

        String buildLogMessageFromRequest(HttpServletRequest request) {
            return this.logMessageBuilder.buildFrom(request);
        }
    }

    public static class BarclaycardEPDQOrder {
        private final String _returnRedirectURL;
        @CheckForNull
        private final Boolean _successful;

        public BarclaycardEPDQOrder(String returnRedirectURL, @Nullable Boolean successful) {
            this._returnRedirectURL = returnRedirectURL;
            this._successful = successful;
        }

        public String getReturnRedirectURL() {
            return this._returnRedirectURL;
        }

        @CheckForNull
        public Boolean getSuccessful() {
            return this._successful;
        }
    }
}

